DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.22248100565334E-11   0.00000000000000E+00   1.97004157457819E-13   1.66370296602369E-22
      1.22247884334426E-08   1.22249854376002E-08  -7.89593879202802E-19  -2.50634423491833E-01  -2.50634423491828E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48782128774092E-12   0.00000000000000E+00  -4.48782128774092E-12
      3.69848470502360E-18  -2.50634423491830E-01  -2.46784373370037E-01   0.00000000000000E+00  -1.99541774419011E-13
     -9.82945547313368E-23  -1.22202980745380E-08  -1.22204976163125E-08  -2.90889082582080E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.24273277020760E-11   0.00000000000000E+00   2.04427065848635E-13   1.68637141880077E-22
      1.24272869205193E-08   1.24274913475853E-08  -7.88042275316089E-19  -2.51349385892121E-01  -2.51349385892117E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74581126119965E-12   0.00000000000000E+00  -4.74581126119965E-12
      3.69528128242229E-18  -2.51349385892093E-01  -2.47435620879697E-01   0.00000000000000E+00  -2.10079483319645E-13
     -9.83791886521307E-23  -1.24225354568407E-08  -1.24227455363241E-08  -2.90723900710620E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.26296616581442E-11   0.00000000000000E+00   3.87984164685294E-14   1.70046384314041E-22
      1.26295624593844E-08   1.26296012578011E-08  -7.86445318605295E-19  -2.52123214179542E-01  -2.52123214179538E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58741381244871E-12   0.00000000000000E+00  -4.58741381244871E-12
      3.69110100158570E-18  -2.52123214179500E-01  -2.48145673396875E-01   0.00000000000000E+00  -4.56073769267536E-14
     -9.87295487258505E-23  -1.26249682366116E-08  -1.26250138439886E-08  -2.90465568298040E-18
      3.31643750000000E-09
      0.00000000000000E+00  -1.28223519168056E-11   0.00000000000000E+00   4.12064450338418E-14   1.70682262054465E-22
      1.28223332810394E-08   1.28223744874846E-08  -7.84873672107988E-19  -2.52920928691221E-01  -2.52920928691217E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04893211443309E-12   0.00000000000000E+00  -4.04893211443309E-12
      3.68612005591017E-18  -2.52920928691198E-01  -2.48882486566431E-01   0.00000000000000E+00  -4.83429296698042E-14
     -9.82375901796730E-23  -1.28182772124404E-08  -1.28183255553702E-08  -2.90124638380218E-18
      4.97719062500000E-09
      0.00000000000000E+00  -1.29970406069743E-11   0.00000000000000E+00   4.12554713322138E-14   1.70598974170705E-22
      1.29970415738472E-08   1.29970828293187E-08  -7.83404424977689E-19  -2.53694847297923E-01  -2.53694847297919E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.23858909820968E-12   0.00000000000000E+00  -3.23858909820968E-12
      3.68074155894473E-18  -2.53694847298376E-01  -2.49601108706587E-01   0.00000000000000E+00  -4.76392286612181E-14
     -9.84812972674135E-23  -1.29937966009917E-08  -1.29938442402205E-08  -2.89733713396704E-18
      6.97719062500000E-09
      0.00000000000000E+00  -1.31351750917344E-11   0.00000000000000E+00   2.80388436425593E-14   1.70048752093312E-22
      1.31351596323049E-08   1.31351876711487E-08  -7.82213913564536E-19  -2.54337765695025E-01  -2.54337765695022E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39854136126211E-12   0.00000000000000E+00  -2.39854136126211E-12
      3.67594447622221E-18  -2.54337765696374E-01  -2.50200248909265E-01   0.00000000000000E+00  -3.31146129271595E-14
     -9.83124540886257E-23  -1.31327560151744E-08  -1.31327891297875E-08  -2.89373056265767E-18
      8.97719062500000E-09
      0.00000000000000E+00  -1.32283975000001E-11   0.00000000000000E+00   2.31555188502088E-15   1.69702663823959E-22
      1.32283978849850E-08   1.32284002005371E-08  -7.81397129913830E-19  -2.54785260090903E-01  -2.54785260090901E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74215348867410E-12   0.00000000000000E+00  -1.74215348867410E-12
      3.67246016924485E-18  -2.54785260093094E-01  -2.50618162199729E-01   0.00000000000000E+00  -6.12819621743462E-15
     -9.86059571664839E-23  -1.32266519188521E-08  -1.32266580470484E-08  -2.89106303933103E-18
      1.09771906250000E-08
      0.00000000000000E+00  -1.32924132818337E-11   0.00000000000000E+00   5.38151407402409E-15   1.68828096232088E-22
      1.32924171292371E-08   1.32924225107514E-08  -7.80830177509122E-19  -2.55098453554109E-01  -2.55098453554108E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25172203304492E-12   0.00000000000000E+00  -1.25172203304492E-12
      3.66995672517877E-18  -2.55098453557190E-01  -2.50911032149777E-01   0.00000000000000E+00  -8.21535562390235E-15
     -9.76769257018945E-23  -1.32911625733626E-08  -1.32911707887183E-08  -2.88912654766965E-18
      1.29771906250000E-08
      0.00000000000000E+00  -1.33367742899050E-11   0.00000000000000E+00   2.81814370077307E-14   1.68437732815130E-22
      1.33368459670344E-08   1.33368741484715E-08  -7.80433914340676E-19  -2.55318391399801E-01  -2.55318391399800E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93691099268359E-13   0.00000000000000E+00  -8.93691099268359E-13
      3.66816934298023E-18  -2.55318391402346E-01  -2.51116860053299E-01   0.00000000000000E+00  -3.03439861204321E-14
     -9.84864869896557E-23  -1.33359501133860E-08  -1.33359804573723E-08  -2.88773542863955E-18
      1.49771906250000E-08
      0.00000000000000E+00  -1.33679096558183E-11   0.00000000000000E+00   3.13502611505356E-15   1.68418589203825E-22
      1.33678979734442E-08   1.33679011084705E-08  -7.80155892433404E-19  -2.55473131269859E-01  -2.55473131269858E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35614102001241E-13   0.00000000000000E+00  -6.35614102001241E-13
      3.66689811477623E-18  -2.55473131271215E-01  -2.51261735839622E-01   0.00000000000000E+00  -4.62751435045473E-15
     -9.86316744771475E-23  -1.33672608668540E-08  -1.33672654943685E-08  -2.88674222234282E-18
      1.69771906250000E-08
      0.00000000000000E+00  -1.33896768585365E-11   0.00000000000000E+00   1.41782654332388E-14   1.67335128060839E-22
      1.33896664702162E-08   1.33896806484818E-08  -7.79960314257575E-19  -2.55582154075488E-01  -2.55582154075487E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51000313077413E-13   0.00000000000000E+00  -4.51000313077413E-13
      3.66599611415007E-18  -2.55582154074938E-01  -2.51363842398125E-01   0.00000000000000E+00  -1.53092573026321E-14
     -9.87042237726168E-23  -1.33892143389113E-08  -1.33892296481687E-08  -2.88603579989250E-18
      1.89771906250000E-08
      0.00000000000000E+00  -1.34050149296502E-11   0.00000000000000E+00   9.21334037997298E-16   1.68166254236955E-22
      1.34049783223026E-08   1.34049792436368E-08  -7.79822563191278E-19  -2.55659016343231E-01  -2.55659016343231E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19514593818106E-13   0.00000000000000E+00  -3.19514593818106E-13
      3.66535708496244E-18  -2.55659016339182E-01  -2.51435839319885E-01   0.00000000000000E+00  -1.68212064858878E-15
     -9.86482334990942E-23  -1.34046580469222E-08  -1.34046597290430E-08  -2.88553452177116E-18
      2.09771906250000E-08
      0.00000000000000E+00  -1.34157607639034E-11   0.00000000000000E+00   3.40909972214435E-15   1.68057771226521E-22
      1.34157557161458E-08   1.34157591252457E-08  -7.79725436867924E-19  -2.55713239567639E-01  -2.55713239567638E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26146921275375E-13   0.00000000000000E+00  -2.26146921275375E-13
      3.66490479111989E-18  -2.55713239559190E-01  -2.51486637751380E-01   0.00000000000000E+00  -3.96703715911258E-15
     -9.86088428649858E-23  -1.34155290112872E-08  -1.34155329783245E-08  -2.88517935425196E-18
      2.29771906250000E-08
      0.00000000000000E+00  -1.34233838770917E-11   0.00000000000000E+00   3.19446686091203E-16   1.68049839505826E-22
      1.34233533831366E-08   1.34233537025835E-08  -7.79656923327983E-19  -2.55751502380774E-01  -2.55751502380773E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59957455190324E-13   0.00000000000000E+00  -1.59957455190324E-13
      3.66458487620951E-18  -2.55751502367256E-01  -2.51522486098449E-01   0.00000000000000E+00  -7.03329023928755E-16
     -9.86936467815914E-23  -1.34231930417992E-08  -1.34231937451283E-08  -2.88492795288152E-18
      2.49771906250000E-08
      0.00000000000000E+00  -1.34287108718497E-11   0.00000000000000E+00   8.93599575783826E-16   1.68006788799985E-22
      1.34287107439383E-08   1.34287116375380E-08  -7.79608572189156E-19  -2.55778510418110E-01  -2.55778510418110E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13093603228880E-13   0.00000000000000E+00  -1.13093603228880E-13
      3.66435868900305E-18  -2.55778510400197E-01  -2.51547791553725E-01   0.00000000000000E+00  -1.17016345205608E-15
     -9.86873258698294E-23  -1.34285973737712E-08  -1.34285985439348E-08  -2.88475011681389E-18
      2.69771906250000E-08
      0.00000000000000E+00  -1.34325683508124E-11   0.00000000000000E+00   7.17533529757068E-16   1.68162456126277E-22
      1.34324908531054E-08   1.34324915706391E-08  -7.79574442947193E-19  -2.55797576992640E-01  -2.55797576992640E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.99357362528614E-14   0.00000000000000E+00  -7.99357362528614E-14
      3.66419881753054E-18  -2.55797576973005E-01  -2.51565656774379E-01   0.00000000000000E+00  -9.18050807996759E-16
     -9.86922904571421E-23  -1.34324107168519E-08  -1.34324116349028E-08  -2.88462437458335E-18
      2.89771906250000E-08
      0.00000000000000E+00  -1.34351400034542E-11   0.00000000000000E+00   2.53455768059688E-16   1.67869584618210E-22
      1.34351587228905E-08   1.34351589763464E-08  -7.79550348569730E-19  -2.55811038639230E-01  -2.55811038639230E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64883572879790E-14   0.00000000000000E+00  -5.64883572879790E-14
      3.66408584081597E-18  -2.55811038622970E-01  -2.51578270537162E-01   0.00000000000000E+00  -3.92025567860831E-16
     -9.86914802747276E-23  -1.34351020959635E-08  -1.34351024879891E-08  -2.88453549224624E-18
      3.09771906250000E-08
      0.00000000000000E+00  -1.34369768981984E-11   0.00000000000000E+00   2.01162948153034E-16   1.68135251816357E-22
      1.34370418242878E-08   1.34370420254509E-08  -7.79533336497308E-19  -2.55820544011259E-01  -2.55820544011259E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99131215776854E-14   0.00000000000000E+00  -3.99131215776854E-14
      3.66400601457281E-18  -2.55820544006046E-01  -2.51587177435468E-01   0.00000000000000E+00  -2.99656387965909E-16
     -9.86918264376543E-23  -1.34370018126728E-08  -1.34370021123293E-08  -2.88447267807550E-18
      3.29771906250000E-08
      0.00000000000000E+00  -1.34383545692565E-11   0.00000000000000E+00   9.32088841834640E-16   1.68199178000000E-22
      1.34383711034651E-08   1.34383720355541E-08  -7.79521323107339E-19  -2.55827256597374E-01  -2.55827256597374E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81987834442491E-14   0.00000000000000E+00  -2.81987834442491E-14
      3.66394961700592E-18  -2.55827256613474E-01  -2.51593467568812E-01   0.00000000000000E+00  -1.01232294059896E-15
     -9.86925995931624E-23  -1.34383428244477E-08  -1.34383438367707E-08  -2.88442829389858E-18
      3.49771906250000E-08
      0.00000000000000E+00  -1.34393648613658E-11   0.00000000000000E+00   6.14238959099152E-17   1.68041235434558E-22
      1.34393100496027E-08   1.34393101110268E-08  -7.79512840520710E-19  -2.55831996495005E-01  -2.55831996495005E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99209599552097E-14   0.00000000000000E+00  -1.99209599552097E-14
      3.66390977508601E-18  -2.55831996542670E-01  -2.51597909079930E-01   0.00000000000000E+00  -1.11631177032531E-16
     -9.86929828441078E-23  -1.34392900784355E-08  -1.34392901900668E-08  -2.88439693456530E-18
      3.69771906250000E-08
      0.00000000000000E+00  -1.34399159297890E-11   0.00000000000000E+00   2.39569271740678E-16   1.68026750034707E-22
      1.34399727712295E-08   1.34399730107989E-08  -7.79506850002950E-19  -2.55835344004815E-01  -2.55835344004815E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40726461937884E-14   0.00000000000000E+00  -1.40726461937884E-14
      3.66388162979363E-18  -2.55835344090729E-01  -2.51601045997567E-01   0.00000000000000E+00  -2.76696697236883E-16
     -9.86934189902210E-23  -1.34399586614559E-08  -1.34399589381527E-08  -2.88437477979067E-18
      3.89771906250000E-08
      0.00000000000000E+00  -1.34403751534750E-11   0.00000000000000E+00   2.10961170373771E-17   1.68015880845751E-22
      1.34404408700941E-08   1.34404408911904E-08  -7.79502619503834E-19  -2.55837708042481E-01  -2.55837708042481E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94066993553553E-15   0.00000000000000E+00  -9.94066993553553E-15
      3.66386174845375E-18  -2.55837708165861E-01  -2.51603261298642E-01   0.00000000000000E+00  -4.56995616185573E-17
     -9.86932855655959E-23  -1.34404309048208E-08  -1.34404309505205E-08  -2.88435912894992E-18
      4.09771906250000E-08
      0.00000000000000E+00  -1.34407425324239E-11   0.00000000000000E+00   6.36674061426491E-17   1.68012797686663E-22
      1.34407713754462E-08   1.34407714391138E-08  -7.79499631665209E-19  -2.55839377697497E-01  -2.55839377697497E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02185241474519E-15   0.00000000000000E+00  -7.02185241474519E-15
      3.66384770474892E-18  -2.55839377845131E-01  -2.51604825934013E-01   0.00000000000000E+00  -8.14658214095304E-17
     -9.86935278888217E-23  -1.34407643357955E-08  -1.34407644172614E-08  -2.88434807308371E-18
      4.29771906250000E-08
      0.00000000000000E+00  -1.34410180666355E-11   0.00000000000000E+00   8.15256269635992E-18   1.68010720185182E-22
      1.34410048183938E-08   1.34410048265466E-08  -7.79497521470439E-19  -2.55840556914793E-01  -2.55840556914793E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95997470648407E-15   0.00000000000000E+00  -4.95997470648407E-15
      3.66383778479951E-18  -2.55840557056460E-01  -2.51605930950645E-01   0.00000000000000E+00  -2.03168360918453E-17
     -9.86935360187439E-23  -1.34409998462549E-08  -1.34409998665719E-08  -2.88434026332907E-18
      4.49771906250000E-08
      0.00000000000000E+00  -1.34412017561099E-11   0.00000000000000E+00   1.78853867088476E-17   1.68009203602213E-22
      1.34411696772895E-08   1.34411696951751E-08  -7.79496031018510E-19  -2.55841389811723E-01  -2.55841389811723E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.50360093916655E-15   0.00000000000000E+00  -3.50360093916655E-15
      3.66383077759763E-18  -2.55841389897859E-01  -2.51606711395138E-01   0.00000000000000E+00  -2.65782093090748E-17
     -9.86936231841083E-23  -1.34411661649958E-08  -1.34411661915741E-08  -2.88433474657912E-18
      4.69771906250000E-08
      0.00000000000000E+00  -1.34412936008471E-11   0.00000000000000E+00   3.47829621860549E-18   1.68008177699752E-22
      1.34412861270908E-08   1.34412861305693E-08  -7.79494978262230E-19  -2.55841978113590E-01  -2.55841978113590E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47491619638738E-15   0.00000000000000E+00  -2.47491619638738E-15
      3.66382582776524E-18  -2.55841978077564E-01  -2.51607262563787E-01   0.00000000000000E+00  -9.51771531660620E-18
     -9.86936569439218E-23  -1.34412836461353E-08  -1.34412836556531E-08  -2.88433084950301E-18
      4.89771906250000E-08
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00   5.47433058944129E-18   1.68007432037234E-22
      1.34413683789898E-08   1.34413683844643E-08  -7.79494234609351E-19  -2.55842393681363E-01  -2.55842393681363E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74835904888415E-15   0.00000000000000E+00  -1.74835904888415E-15
      3.66382233104714E-18  -2.55842393448667E-01  -2.51607651792893E-01   0.00000000000000E+00  -9.76520398052503E-18
     -9.86936935407166E-23  -1.34413666263400E-08  -1.34413666361053E-08  -2.88432809643779E-18
      5.09771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.59457031753553E-18   1.68006900585187E-22
      1.34414264823032E-08   1.34414264838979E-08  -7.79493709286747E-19  -2.55842687242041E-01  -2.55842687242041E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23516046264073E-15   0.00000000000000E+00  -1.23516046264073E-15
      3.66381986072622E-18  -2.55842686748565E-01  -2.51607926625925E-01   0.00000000000000E+00  -4.59368324411079E-18
     -9.86937219077688E-23  -1.34414252441437E-08  -1.34414252487375E-08  -2.88432615143947E-18
      5.29771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.87285881436690E-18   1.68006529478615E-22
      1.34414675214249E-08   1.34414675232979E-08  -7.79493338211151E-19  -2.55842894610246E-01  -2.55842894610246E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.72603562720352E-16   0.00000000000000E+00  -8.72603562720352E-16
      3.66381811551909E-18  -2.55842893830018E-01  -2.51608120663966E-01   0.00000000000000E+00  -3.99961096071626E-18
     -9.86937395624396E-23  -1.34414666466947E-08  -1.34414666506944E-08  -2.88432477730794E-18
      5.49771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.57208433007477E-19   1.68006256819495E-22
      1.34414964983842E-08   1.34414964991415E-08  -7.79493076174181E-19  -2.55843041053426E-01  -2.55843041053426E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16345211488649E-16   0.00000000000000E+00  -6.16345211488649E-16
      3.66381688282867E-18  -2.55843040033746E-01  -2.51608257657901E-01   0.00000000000000E+00  -2.25380122850609E-18
     -9.86937577977186E-23  -1.34414958805424E-08  -1.34414958827963E-08  -2.88432380665449E-18
      5.69771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.16337067534553E-19   1.68006069542884E-22
      1.34415169386795E-08   1.34415169393960E-08  -7.79492891291625E-19  -2.55843144393353E-01  -2.55843144393353E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.35051107890792E-16   0.00000000000000E+00  -4.35051107890792E-16
      3.66381601272645E-18  -2.55843143291215E-01  -2.51608354418633E-01   0.00000000000000E+00  -1.77988871127866E-18
     -9.86937676084886E-23  -1.34415165025649E-08  -1.34415165043449E-08  -2.88432312143483E-18
      5.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.67573446821890E-19   1.68005934202567E-22
      1.34415313296479E-08   1.34415313300156E-08  -7.79492761083114E-19  -2.55843217195296E-01  -2.55843217195296E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06592650931757E-16   0.00000000000000E+00  -3.06592650931757E-16
      3.66381539954115E-18  -2.55843216304449E-01  -2.51608422857587E-01   0.00000000000000E+00  -1.11796937596385E-18
     -9.86937761757234E-23  -1.34415310223049E-08  -1.34415310234230E-08  -2.88432263845803E-18
      6.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.05372086024521E-19   1.68005839374700E-22
      1.34415414280518E-08   1.34415414283574E-08  -7.79492669676258E-19  -2.55843268328630E-01  -2.55843268328630E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15391099585913E-16   0.00000000000000E+00  -2.15391099585913E-16
      3.66381496875895E-18  -2.55843268082024E-01  -2.51608471424974E-01   0.00000000000000E+00  -8.38678663798704E-19
     -9.86937815967298E-23  -1.34415412121275E-08  -1.34415412129663E-08  -2.88432229908269E-18
      6.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.78604648322905E-19   1.68005772894680E-22
      1.34415484819666E-08   1.34415484821454E-08  -7.79492605812568E-19  -2.55843304079114E-01  -2.55843304079114E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50546205929589E-16   0.00000000000000E+00  -1.50546205929589E-16
      3.66381466766654E-18  -2.55843305008642E-01  -2.51608506108861E-01   0.00000000000000E+00  -5.61811191263577E-19
     -9.86937850767585E-23  -1.34415483310373E-08  -1.34415483315992E-08  -2.88432206185397E-18
      6.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.34882089957002E-19   1.68005725177893E-22
      1.34415533889659E-08   1.34415533891009E-08  -7.79492561413461E-19  -2.55843328948383E-01  -2.55843328948383E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04524933172821E-16   0.00000000000000E+00  -1.04524933172821E-16
      3.66381445861667E-18  -2.55843331584731E-01  -2.51608531124527E-01   0.00000000000000E+00  -4.17420857656417E-19
     -9.86937879109502E-23  -1.34415532841585E-08  -1.34415532845760E-08  -2.88432189720321E-18
      6.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   8.55101827479877E-20   1.68005692417403E-22
      1.34415568094720E-08   1.34415568095576E-08  -7.79492530554631E-19  -2.55843346226281E-01  -2.55843346226281E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.22216783462666E-17   0.00000000000000E+00  -7.22216783462666E-17
      3.66381431417332E-18  -2.55843350928714E-01  -2.51608549380721E-01   0.00000000000000E+00  -2.94446475798315E-19
     -9.86937895920921E-23  -1.34415567370414E-08  -1.34415567373359E-08  -2.88432178361869E-18
      6.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   6.48184595977881E-20   1.68005669491777E-22
      1.34415592454243E-08   1.34415592454893E-08  -7.79492508745478E-19  -2.55843358394582E-01  -2.55843358394582E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.02631529102384E-17   0.00000000000000E+00  -5.02631529102384E-17
      3.66381421364701E-18  -2.55843365115705E-01  -2.51608562793360E-01   0.00000000000000E+00  -2.18947473227470E-19
     -9.86937911195722E-23  -1.34415591950071E-08  -1.34415591952261E-08  -2.88432170490153E-18
      7.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.56154285674632E-20   1.68005654744343E-22
      1.34415610909489E-08   1.34415610909947E-08  -7.79492492457032E-19  -2.55843367394865E-01  -2.55843367394865E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.64535923217617E-17   0.00000000000000E+00  -3.64535923217617E-17
      3.66381414073983E-18  -2.55843375409695E-01  -2.51608572501575E-01   0.00000000000000E+00  -1.54187537152822E-19
     -9.86937921431735E-23  -1.34415610543868E-08  -1.34415610545411E-08  -2.88432164828279E-18
      7.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.93863310732454E-20   1.68005646455505E-22
      1.34415626583673E-08   1.34415626584068E-08  -7.79492478866029E-19  -2.55843374779268E-01  -2.55843374779268E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92921374840669E-17   0.00000000000000E+00  -2.92921374840669E-17
      3.66381408215555E-18  -2.55843382439971E-01  -2.51608579035783E-01   0.00000000000000E+00  -1.01434067622372E-19
     -9.86937927244614E-23  -1.34415626290131E-08  -1.34415626291147E-08  -2.88432160328952E-18
      7.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.86346695729155E-20   1.68005643221397E-22
      1.34415641817771E-08   1.34415641818159E-08  -7.79492465798771E-19  -2.55843381753536E-01  -2.55843381753536E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75188545791211E-17   0.00000000000000E+00  -2.75188545791211E-17
      3.66381402711784E-18  -2.55843386366160E-01  -2.51608582481460E-01   0.00000000000000E+00  -5.18829321237416E-20
     -9.86937929612925E-23  -1.34415641542450E-08  -1.34415641542970E-08  -2.88432156131907E-18
      7.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.12261643319603E-20   1.68005643849772E-22
      1.34415658008797E-08   1.34415658009211E-08  -7.79492451854814E-19  -2.55843389122428E-01  -2.55843389122428E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.96826295726626E-17   0.00000000000000E+00  -2.96826295726626E-17
      3.66381396775258E-18  -2.55843387070800E-01  -2.51608582676675E-01   0.00000000000000E+00  -4.62701604825924E-22
     -9.86937927309115E-23  -1.34415657712379E-08  -1.34415657712385E-08  -2.88432151589777E-18
      7.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.33128937039223E-20   1.68005646458678E-22
      1.34415675301981E-08   1.34415675302416E-08  -7.79492436672652E-19  -2.55843397156100E-01  -2.55843397156100E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.37605479772103E-17   0.00000000000000E+00  -3.37605479772103E-17
      3.66381390023149E-18  -2.55843384407161E-01  -2.51608579469486E-01   0.00000000000000E+00   5.34191746061676E-20
     -9.86937920754005E-23  -1.34415674965344E-08  -1.34415674964810E-08  -2.88432146355883E-18
      8.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.13999060412823E-20   1.68005648658951E-22
      1.34415692230466E-08   1.34415692230882E-08  -7.79492421263628E-19  -2.55843405414103E-01  -2.55843405414103E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.69004470984001E-17   0.00000000000000E+00  -3.69004470984001E-17
      3.66381382643059E-18  -2.55843378511807E-01  -2.51608573041774E-01   0.00000000000000E+00   9.87364989776362E-20
     -9.86937910365247E-23  -1.34415691862863E-08  -1.34415691861877E-08  -2.88432140516696E-18
      8.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.16191622365035E-20   1.68005647320649E-22
      1.34415705449602E-08   1.34415705449920E-08  -7.79492408293039E-19  -2.55843412588293E-01  -2.55843412588293E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53941220205713E-17   0.00000000000000E+00  -3.53941220205713E-17
      3.66381375564235E-18  -2.55843370162431E-01  -2.51608564275442E-01   0.00000000000000E+00   1.32981904315049E-19
     -9.86937897964869E-23  -1.34415705097307E-08  -1.34415705095978E-08  -2.88432134734931E-18
      8.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.17723724516382E-20   1.68005638861003E-22
      1.34415709766100E-08   1.34415709766219E-08  -7.79492402137443E-19  -2.55843416452761E-01  -2.55843416452761E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.50086400949953E-17   0.00000000000000E+00  -2.50086400949953E-17
      3.66381370562507E-18  -2.55843361123511E-01  -2.51608555097253E-01   0.00000000000000E+00   1.29576566812338E-19
     -9.86937887003676E-23  -1.34415709517428E-08  -1.34415709516133E-08  -2.88432130348763E-18
      8.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -2.82979522983064E-20   1.68005619931495E-22
      1.34415698694748E-08   1.34415698694467E-08  -7.79492408511155E-19  -2.55843414029498E-01  -2.55843414029498E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79171370529744E-18   0.00000000000000E+00  -1.79171370529744E-18
      3.66381370204164E-18  -2.55843354378148E-01  -2.51608548693390E-01   0.00000000000000E+00   7.64189192002024E-20
     -9.86937882443763E-23  -1.34415698677313E-08  -1.34415698676550E-08  -2.88432129353048E-18
      8.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -7.90945415237610E-20   1.68005588444585E-22
      1.34415665760154E-08   1.34415665759364E-08  -7.79492433456049E-19  -2.55843402081034E-01  -2.55843402081034E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65941700667961E-17   0.00000000000000E+00   3.65941700667961E-17
      3.66381377522998E-18  -2.55843354104529E-01  -2.51608549445318E-01   0.00000000000000E+00  -4.83422589737693E-20
     -9.86937890726235E-23  -1.34415666124822E-08  -1.34415666125306E-08  -2.88432134177394E-18
      9.09771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.45136508527196E-19   1.68005545097809E-22
      1.34415606669986E-08   1.34415606668536E-08  -7.79492481553824E-19  -2.55843378011393E-01  -2.55843378011393E-01
      0.00000000000000E+00   0.00000000000000E+00   8.90781458587875E-17   0.00000000000000E+00   8.90781458587875E-17
      3.66381395338627E-18  -2.55843365233462E-01  -2.51608562419418E-01   0.00000000000000E+00  -2.40036059018963E-19
     -9.86937918462838E-23  -1.34415607556917E-08  -1.34415607559318E-08  -2.88432147183245E-18
      9.29771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.98755028884059E-19   1.68005495008203E-22
      1.34415522290783E-08   1.34415522288797E-08  -7.79492553372852E-19  -2.55843341181477E-01  -2.55843341181477E-01
      0.00000000000000E+00   0.00000000000000E+00   1.49186887970780E-16   0.00000000000000E+00   1.49186887970780E-16
      3.66381425176005E-18  -2.55843392439665E-01  -2.51608592265148E-01   0.00000000000000E+00  -5.07490388629034E-19
     -9.86937970693119E-23  -1.34415523775590E-08  -1.34415523780666E-08  -2.88432169838720E-18
      9.49771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -2.48439671169853E-19   1.68005449154433E-22
      1.34415422049849E-08   1.34415422047367E-08  -7.79492642419125E-19  -2.55843294514483E-01  -2.55843294514483E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03355049097796E-16   0.00000000000000E+00   2.03355049097796E-16
      3.66381465847015E-18  -2.55843438494923E-01  -2.51608641461553E-01   0.00000000000000E+00  -7.87810749029422E-19
     -9.86938048111527E-23  -1.34415424073038E-08  -1.34415424080917E-08  -2.88432201605102E-18
      9.69771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -2.32089661892605E-19   1.68005424967433E-22
      1.34415326983613E-08   1.34415326981294E-08  -7.79492732208693E-19  -2.55843246086765E-01  -2.55843246086765E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30295630653375E-16   0.00000000000000E+00   2.30295630653375E-16
      3.66381511906141E-18  -2.55843502062525E-01  -2.51608708015849E-01   0.00000000000000E+00  -1.02510351790120E-18
     -9.86938143817562E-23  -1.34415329273998E-08  -1.34415329284250E-08  -2.88432238685272E-18
      9.89771906250001E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -1.38656857199534E-19   1.68005445273031E-22
      1.34415271215102E-08   1.34415271213717E-08  -7.79492794479210E-19  -2.55843210187519E-01  -2.55843210187519E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02385223372599E-16   0.00000000000000E+00   2.02385223372599E-16
      3.66381552383186E-18  -2.55843575246564E-01  -2.51608782965750E-01   0.00000000000000E+00  -1.10005203358250E-18
     -9.86938240204183E-23  -1.34415273226568E-08  -1.34415273237570E-08  -2.88432272935264E-18
      1.00977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   9.27378378557823E-20   1.68005534797805E-22
      1.34415300286501E-08   1.34415300287430E-08  -7.79492789908316E-19  -2.55843207137745E-01  -2.55843207137745E-01
      0.00000000000000E+00   0.00000000000000E+00   9.00369220362838E-17   0.00000000000000E+00   9.00369220362838E-17
      3.66381570390570E-18  -2.55843641506545E-01  -2.51608848345220E-01   0.00000000000000E+00  -9.06066671834359E-19
     -9.86938307036352E-23  -1.34415301178738E-08  -1.34415301187800E-08  -2.88432291399738E-18
      1.02977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.34831605790579E-19   1.68005713594398E-22
      1.34415464670337E-08   1.34415464674687E-08  -7.79492672872133E-19  -2.55843261054061E-01  -2.55843261054061E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30226727880168E-16   0.00000000000000E+00  -1.30226727880168E-16
      3.66381544345225E-18  -2.55843674861765E-01  -2.51608876590757E-01   0.00000000000000E+00  -2.60588788801705E-19
     -9.86938302230645E-23  -1.34415463369812E-08  -1.34415463372419E-08  -2.88432277058011E-18
      1.04977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   1.11163420458394E-18   1.68005987351190E-22
      1.34415807137098E-08   1.34415807148216E-08  -7.79492401565230E-19  -2.55843394826416E-01  -2.55843394826416E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.63975836418492E-16   0.00000000000000E+00  -4.63975836418492E-16
      3.66381451550057E-18  -2.55843641546731E-01  -2.51608832591079E-01   0.00000000000000E+00   6.89913696836826E-19
     -9.86938176951583E-23  -1.34415802515356E-08  -1.34415802508458E-08  -2.88432211393534E-18
      1.06977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.40681405328160E-18   1.68006335465458E-22
      1.34416343698377E-08   1.34416343712447E-08  -7.79491954022995E-19  -2.55843621953146E-01  -2.55843621953146E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.84495217636078E-16   0.00000000000000E+00  -8.84495217636078E-16
      3.66381274651013E-18  -2.55843505313497E-01  -2.51608679585358E-01   0.00000000000000E+00   2.57909691643960E-18
     -9.86937886461821E-23  -1.34416334893285E-08  -1.34416334867495E-08  -2.88432079248714E-18
      1.08977190625000E-07
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00   2.24470996495831E-18   1.68006699119574E-22
      1.34417039667867E-08   1.34417039690316E-08  -7.79491349083646E-19  -2.55843935629207E-01  -2.55843935629207E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31859195668399E-15   0.00000000000000E+00  -1.31859195668399E-15
      3.66381010932622E-18  -2.55843237257510E-01  -2.51608389738793E-01   0.00000000000000E+00   4.19543981344332E-18
     -9.86937407250730E-23  -1.34417026546350E-08  -1.34417026504396E-08  -2.88431876024258E-18
      1.10977190625000E-07
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00   1.87019233634383E-18   1.68006973172061E-22
      1.34417785089141E-08   1.34417785107844E-08  -7.79490669074389E-19  -2.55844296637887E-01  -2.55844296637887E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63726731876492E-15   0.00000000000000E+00  -1.63726731876492E-15
      3.66380683479158E-18  -2.55842830206622E-01  -2.51607959302895E-01   0.00000000000000E+00   6.70382202532877E-18
     -9.86936759536957E-23  -1.34417768802208E-08  -1.34417768735171E-08  -2.88431616571720E-18
      1.12977190625000E-07
      0.00000000000000E+00  -1.34418446692704E-11   0.00000000000000E+00   1.49451338156705E-18   1.68007007120890E-22
      1.34418376857198E-08   1.34418376872144E-08  -7.79490078196473E-19  -2.55844623067961E-01  -2.55844623067961E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.65761234071885E-15   0.00000000000000E+00  -1.65761234071885E-15
      3.66380351956690E-18  -2.55842316302387E-01  -2.51607426760635E-01   0.00000000000000E+00   7.96128953413729E-18
     -9.86936031474518E-23  -1.34418360375633E-08  -1.34418360296021E-08  -2.88431344137043E-18
      1.14977190625000E-07
      0.00000000000000E+00  -1.34418446692704E-11   0.00000000000000E+00   5.71275542271380E-19   1.68006621237665E-22
      1.34418518037664E-08   1.34418518043379E-08  -7.79489827711798E-19  -2.55844786423499E-01  -2.55844786423499E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16327520308101E-15   0.00000000000000E+00  -1.16327520308101E-15
      3.66380119301649E-18  -2.55841784394478E-01  -2.51606890248788E-01   0.00000000000000E+00   7.39072907616428E-18
     -9.86935398941841E-23  -1.34418506484533E-08  -1.34418506410627E-08  -2.88431136530470E-18
      1.16977190625000E-07
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00   1.24418084019563E-18   1.68005643350020E-22
      1.34417846621729E-08   1.34417846634173E-08  -7.79490236992306E-19  -2.55844619865222E-01  -2.55844619865222E-01
      0.00000000000000E+00   0.00000000000000E+00   5.00251582163244E-17   0.00000000000000E+00   5.00251582163244E-17
      3.66380129306681E-18  -2.55841391577676E-01  -2.51606518203290E-01   0.00000000000000E+00   1.61966776466211E-18
     -9.86935130977714E-23  -1.34417847150620E-08  -1.34417847134424E-08  -2.88431105607451E-18
      1.18977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -2.32658803155142E-18   1.68003969086745E-22
      1.34416005298707E-08   1.34416005275443E-08  -7.79491639535520E-19  -2.55843944469737E-01  -2.55843944469737E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10084520379427E-15   0.00000000000000E+00   2.10084520379427E-15
      3.66380549475722E-18  -2.55841361058155E-01  -2.51606545050493E-01   0.00000000000000E+00  -4.43853555540645E-18
     -9.86935569567533E-23  -1.34416026239508E-08  -1.34416026283895E-08  -2.88431385522170E-18
      1.20977190625000E-07
      0.00000000000000E+00  -1.34412936008471E-11   0.00000000000000E+00   1.09978209383202E-17   1.68001642964455E-22
      1.34412758750497E-08   1.34412758860477E-08  -7.79494286403304E-19  -2.55842617861299E-01  -2.55842617861299E-01
      0.00000000000000E+00   0.00000000000000E+00   4.92379074938403E-15   0.00000000000000E+00   4.92379074938403E-15
      3.66381534233872E-18  -2.55841957430235E-01  -2.51607242819330E-01   0.00000000000000E+00  -3.21079232688676E-17
     -9.86937071781004E-23  -1.34412807777304E-08  -1.34412808098385E-08  -2.88432105593542E-18
      1.22977190625000E-07
      0.00000000000000E+00  -1.34408343771611E-11   0.00000000000000E+00  -7.26840211078091E-18   1.67998948602348E-22
      1.34408154795378E-08   1.34408154722696E-08  -7.79498208212344E-19  -2.55840605310333E-01  -2.55840605310333E-01
      0.00000000000000E+00   0.00000000000000E+00   8.16108534088499E-15   0.00000000000000E+00   8.16108534088499E-15
      3.66383166450940E-18  -2.55843431309320E-01  -2.51608860731456E-01   0.00000000000000E+00  -3.13260819191985E-17
     -9.86939906276014E-23  -1.34408236020287E-08  -1.34408236333549E-08  -2.88433345629706E-18
      1.24977190625000E-07
      0.00000000000000E+00  -1.34402833087378E-11   0.00000000000000E+00   1.13346384448719E-17   1.67996487084687E-22
      1.34402707708093E-08   1.34402707821441E-08  -7.79503050145116E-19  -2.55838066610761E-01  -2.55838066610761E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10710513582962E-14   0.00000000000000E+00   1.10710513582962E-14
      3.66385380661212E-18  -2.55845929588755E-01  -2.51611529711111E-01   0.00000000000000E+00  -6.80267593712471E-17
     -9.86944105766714E-23  -1.34402817851686E-08  -1.34402818531955E-08  -2.88435075646700E-18
      1.26977190625000E-07
      0.00000000000000E+00  -1.34397322403146E-11   0.00000000000000E+00  -1.27304756798446E-17   1.67995207440156E-22
      1.34397563077213E-08   1.34397562949910E-08  -7.79507914136071E-19  -2.55835441877867E-01  -2.55835441877867E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24945848343263E-14   0.00000000000000E+00   1.24945848343263E-14
      3.66387879578178E-18  -2.55849375511753E-01  -2.51615137273734E-01   0.00000000000000E+00  -5.54985867088770E-17
     -9.86949289879745E-23  -1.34397687340771E-08  -1.34397687895758E-08  -2.88437088164571E-18
      1.28977190625000E-07
      0.00000000000000E+00  -1.34394567061030E-11   0.00000000000000E+00  -6.02717122192356E-18   1.67996349949770E-22
      1.34394575109534E-08   1.34394575049264E-08  -7.79511263315826E-19  -2.55833508300529E-01  -2.55833508300529E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09319128705708E-14   0.00000000000000E+00   1.09319128705708E-14
      3.66390065960753E-18  -2.55853335972784E-01  -2.51619192367336E-01   0.00000000000000E+00  -6.12674917943234E-17
     -9.86954497055401E-23  -1.34394683755717E-08  -1.34394684368393E-08  -2.88438939629170E-18
      1.30977190625000E-07
      0.00000000000000E+00  -1.34396403955774E-11   0.00000000000000E+00   3.13945032331896E-17   1.68001253849222E-22
      1.34396214212381E-08   1.34396214526328E-08  -7.79510963319992E-19  -2.55833369114390E-01  -2.55833369114390E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78135954448398E-15   0.00000000000000E+00   4.78135954448398E-15
      3.66391022232662E-18  -2.55856909048216E-01  -2.51622715739875E-01   0.00000000000000E+00  -7.48244604431329E-17
     -9.86958081528369E-23  -1.34396261591678E-08  -1.34396262339923E-08  -2.88439925900663E-18
      1.32977190625000E-07
      0.00000000000000E+00  -1.34404669982123E-11   0.00000000000000E+00   3.26069972433251E-16   1.68011000517626E-22
      1.34405211863682E-08   1.34405215124383E-08  -7.79504542770808E-19  -2.55836331054100E-01  -2.55836331054100E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.22163540108369E-15   0.00000000000000E+00  -7.22163540108369E-15
      3.66389577905581E-18  -2.55858682043789E-01  -2.51624209036894E-01   0.00000000000000E+00  -3.16157740902857E-16
     -9.86957758127459E-23  -1.34405139746451E-08  -1.34405142908029E-08  -2.88439123628501E-18
      1.34977190625000E-07
      0.00000000000000E+00  -1.34423957376936E-11   0.00000000000000E+00   2.10196035661098E-16   1.68025883557676E-22
      1.34423874881594E-08   1.34423876983556E-08  -7.79489746994557E-19  -2.55843629484766E-01  -2.55843629484766E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.53617844359818E-14   0.00000000000000E+00  -2.53617844359818E-14
      3.66384505548694E-18  -2.55856822600114E-01  -2.51621767309673E-01   0.00000000000000E+00  -1.13455682614763E-16
     -9.86950881711218E-23  -1.34423622231154E-08  -1.34423623365712E-08  -2.88435530849238E-18
      1.36977190625000E-07
      0.00000000000000E+00  -1.34452429245470E-11   0.00000000000000E+00   1.36508919537808E-15   1.68044768942295E-22
      1.34453043124764E-08   1.34453056775658E-08  -7.79465406043575E-19  -2.55855985790972E-01  -2.55855985790972E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.81675896825348E-14   0.00000000000000E+00  -4.81675896825348E-14
      3.66374872030758E-18  -2.55849369258520E-01  -2.51613402174026E-01   0.00000000000000E+00  -1.16156347702532E-15
     -9.86935036658722E-23  -1.34452563484125E-08  -1.34452575099761E-08  -2.88428331426400E-18
      1.38977190625000E-07
      0.00000000000000E+00  -1.34491004035098E-11   0.00000000000000E+00   2.88455441023070E-16   1.68064432210612E-22
      1.34490810833595E-08   1.34490813718151E-08  -7.79432575958065E-19  -2.55873013304018E-01  -2.55873013304018E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.16451738738328E-14   0.00000000000000E+00  -7.16451738738328E-14
      3.66360542995983E-18  -2.55834763441652E-01  -2.51597613838550E-01   0.00000000000000E+00   5.40906387623345E-17
     -9.86908970387014E-23  -1.34490097807317E-08  -1.34490097266412E-08  -2.88417285400176E-18
      1.40977190625000E-07
      0.00000000000000E+00  -1.34531415719469E-11   0.00000000000000E+00   1.60636604453062E-16   1.65185873729433E-22
      1.34531160784298E-08   1.34531162390665E-08  -7.79395760620787E-19  -2.55892564753056E-01  -2.55892564753056E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.87733784583777E-14   0.00000000000000E+00  -8.87733784583777E-14
      3.66342788320292E-18  -2.55812635463911E-01  -2.51574219981668E-01   0.00000000000000E+00   3.02714726697902E-16
     -9.86922288418980E-23  -1.34530277684027E-08  -1.34530274656881E-08  -2.88403212258212E-18
      1.42977190625000E-07
      0.00000000000000E+00  -1.34562642930120E-11   0.00000000000000E+00   1.05151240402695E-16   1.68075893342251E-22
      1.34563034380164E-08   1.34563035431678E-08  -7.79363902377183E-19  -2.55910177403734E-01  -2.55910177403734E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.96210928993166E-14   0.00000000000000E+00  -8.96210928993166E-14
      3.66324864101711E-18  -2.55784755816319E-01  -2.51545336381217E-01   0.00000000000000E+00   4.04173696079370E-16
     -9.86828977138441E-23  -1.34562143262485E-08  -1.34562139220749E-08  -2.88388473863993E-18
      1.44977190625000E-07
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00   7.94142317554938E-17   1.66253176814595E-22
      1.34570284298558E-08   1.34570285092702E-08  -7.79350653942779E-19  -2.55918867451423E-01  -2.55918867451423E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.24633878349208E-14   0.00000000000000E+00  -6.24633878349208E-14
      3.66312371424144E-18  -2.55755978410953E-01  -2.51516321994965E-01   0.00000000000000E+00   3.47974559023326E-16
     -9.86808189896946E-23  -1.34569663938568E-08  -1.34569660458824E-08  -2.88377306029867E-18
      1.46977190625000E-07
      0.00000000000000E+00  -1.34533252614213E-11   0.00000000000000E+00   6.89257739585431E-17   1.65642870475570E-22
      1.34533267786276E-08   1.34533268475536E-08  -7.79373338392903E-19  -2.55909583465120E-01  -2.55909583465120E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73995830515968E-15   0.00000000000000E+00   3.73995830515968E-15
      3.66313119415805E-18  -2.55734859601045E-01  -2.51496348565888E-01   0.00000000000000E+00   8.00035051099908E-17
     -9.86826159526439E-23  -1.34533306675153E-08  -1.34533305875119E-08  -2.88375785576515E-18
      1.48977190625000E-07
      0.00000000000000E+00  -1.34432223403285E-11   0.00000000000000E+00   1.35573355364337E-15   1.66147393954432E-22
      1.34432673550855E-08   1.34432687108192E-08  -7.79450012607688E-19  -2.55872635265423E-01  -2.55872635265423E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15342483541783E-13   0.00000000000000E+00   1.15342483541783E-13
      3.66336187912514E-18  -2.55733527600033E-01  -2.51498150731466E-01   0.00000000000000E+00  -1.74226992776875E-15
     -9.86839162154311E-23  -1.34433823110327E-08  -1.34433840533028E-08  -2.88391186651745E-18
      1.50977190625000E-07
      0.00000000000000E+00  -1.34255881507846E-11   0.00000000000000E+00  -4.75383123749801E-16   1.67800091682208E-22
      1.34255963999334E-08   1.34255959245505E-08  -7.79594235461325E-19  -2.55800330503713E-01  -2.55800330503713E-01
      0.00000000000000E+00   0.00000000000000E+00   2.68676937154940E-13   0.00000000000000E+00   2.68676937154940E-13
      3.66389923299945E-18  -2.55766311321827E-01  -2.51536453578532E-01   0.00000000000000E+00  -6.69845024258275E-16
     -9.87619211158642E-23  -1.34258639316425E-08  -1.34258646014876E-08  -2.88430499753812E-18
      1.51477190625000E-07
      0.00000000000000E+00  -1.34207203797126E-11   0.00000000000000E+00  -4.87399360064644E-16   1.67683223059438E-22
      1.34206886625874E-08   1.34206881751882E-08  -7.79634703020124E-19  -2.55779933983520E-01  -2.55779933983521E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09517434296273E-13   0.00000000000000E+00   3.09517434296273E-13
      3.66405399171660E-18  -2.55776869321490E-01  -2.51548544951726E-01   0.00000000000000E+00  -8.74279082555979E-16
     -9.86916811680565E-23  -1.34209968183434E-08  -1.34209976926225E-08  -2.88441928869647E-18
      1.52152190625000E-07
      0.00000000000000E+00  -1.34130972665244E-11   0.00000000000000E+00  -5.55219593580450E-16   1.67832916973592E-22
      1.34131418706229E-08   1.34131413154035E-08  -7.79697733258146E-19  -2.55747951026252E-01  -2.55747951026253E-01
      0.00000000000000E+00   0.00000000000000E+00   3.68791795432341E-13   0.00000000000000E+00   3.68791795432341E-13
      3.66430292617851E-18  -2.55796008182982E-01  -2.51570042839093E-01   0.00000000000000E+00  -1.10763082982914E-15
     -9.88156432976274E-23  -1.34135089995680E-08  -1.34135101071989E-08  -2.88460519292037E-18
      1.53063440625000E-07
      0.00000000000000E+00  -1.34013411401619E-11   0.00000000000000E+00  -3.65775578586987E-16   1.67645241946863E-22
      1.34012780270972E-08   1.34012776613218E-08  -7.79798499430140E-19  -2.55696376765156E-01  -2.55696376765156E-01
      0.00000000000000E+00   0.00000000000000E+00   4.54612597758494E-13   0.00000000000000E+00   4.54612597758494E-13
      3.66471719190822E-18  -2.55832163406362E-01  -2.51609908865163E-01   0.00000000000000E+00  -1.76336550346353E-15
     -9.88023917154570E-23  -1.34017305105539E-08  -1.34017322739195E-08  -2.88491869247808E-18
      1.54293628125000E-07
      0.00000000000000E+00  -1.33825129690343E-11   0.00000000000000E+00   2.81343205276068E-17   1.67524273070907E-22
      1.33825295580027E-08   1.33825295861372E-08  -7.79961505547587E-19  -2.55611973546294E-01  -2.55611973546295E-01
      0.00000000000000E+00   0.00000000000000E+00   5.73798902899761E-13   0.00000000000000E+00   5.73798902899761E-13
      3.66542307214608E-18  -2.55902832520294E-01  -2.51686447354507E-01   0.00000000000000E+00  -2.84885377908435E-15
     -9.87561352918229E-23  -1.33831005361862E-08  -1.33831033850401E-08  -2.88546156659849E-18
      1.55954381250000E-07
      0.00000000000000E+00  -1.33545003241860E-11   0.00000000000000E+00  -7.76973383131811E-16   1.66917542269198E-22
      1.33545094310694E-08   1.33545086540962E-08  -7.80214391490564E-19  -2.55478680968937E-01  -2.55478680968937E-01
      0.00000000000000E+00   0.00000000000000E+00   7.11310856240338E-13   0.00000000000000E+00   7.11310856240338E-13
      3.66660438387343E-18  -2.56041832377945E-01  -2.51834231968164E-01   0.00000000000000E+00  -2.88692437516606E-15
     -9.87606990886260E-23  -1.33552170780279E-08  -1.33552199649524E-08  -2.88638999238286E-18
      1.57954381250000E-07
      0.00000000000000E+00  -1.33248344740680E-11   0.00000000000000E+00  -7.39159851625493E-16   1.69069184981276E-22
      1.33248229062097E-08   1.33248221670500E-08  -7.80502667561329E-19  -2.55321672693850E-01  -2.55321672693851E-01
      0.00000000000000E+00   0.00000000000000E+00   7.66199073063557E-13   0.00000000000000E+00   7.66199073063557E-13
      3.66813678201956E-18  -2.56263488965769E-01  -2.52065224381129E-01   0.00000000000000E+00  -3.52355370267455E-15
     -1.01769690015762E-22  -1.33255848425693E-08  -1.33255883661231E-08  -2.88763411445823E-18
      1.59954381250000E-07
      0.00000000000000E+00  -1.33114251424357E-11   0.00000000000000E+00  -3.32798131099906E-16   1.67437015444507E-22
      1.33114645073635E-08   1.33114641745655E-08  -7.80671010215965E-19  -2.55220868905920E-01  -2.55220868905920E-01
      0.00000000000000E+00   0.00000000000000E+00   6.15014329751488E-13   0.00000000000000E+00   6.15014329751488E-13
      3.66936681067906E-18  -2.56506933653622E-01  -2.52312925475036E-01   0.00000000000000E+00  -3.59775717732909E-15
     -9.88798571471714E-23  -1.33120755911380E-08  -1.33120791888953E-08  -2.88869580046310E-18
      1.61954381250000E-07
      0.00000000000000E+00  -1.33300696240888E-11   0.00000000000000E+00   5.64058968592692E-15   1.66979322275174E-22
      1.33301021962699E-08   1.33301078368598E-08  -7.80581457278288E-19  -2.55247936749491E-01  -2.55247936749492E-01
      0.00000000000000E+00   0.00000000000000E+00   1.61572963568718E-13   0.00000000000000E+00   1.61572963568718E-13
      3.66968995660620E-18  -2.56710050090672E-01  -2.52510312824013E-01   0.00000000000000E+00  -7.79208328446933E-15
     -9.85577987724413E-23  -1.33302616177400E-08  -1.33302694098234E-08  -2.88910849932791E-18
      1.63954381250000E-07
      0.00000000000000E+00  -1.33972999717247E-11   0.00000000000000E+00   6.71639119737682E-14   1.81654442702989E-22
      1.33973221316378E-08   1.33973892955499E-08  -7.80082292568856E-19  -2.55483667290454E-01  -2.55483667290454E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.60989341521927E-13   0.00000000000000E+00  -6.60989341521927E-13
      3.66836797792315E-18  -2.56779838291764E-01  -2.52559181798175E-01   0.00000000000000E+00  -6.60585780166518E-14
     -8.93535929595752E-23  -1.33966622476303E-08  -1.33967283062084E-08  -2.88828568535430E-18
      1.65954381250000E-07
      0.00000000000000E+00  -1.35262499827641E-11   0.00000000000000E+00   4.32887014072087E-14   1.69313902437959E-22
      1.35262298389647E-08   1.35262731276662E-08  -7.79047660146653E-19  -2.55998185882192E-01  -2.55998185882191E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.84859381584862E-12   0.00000000000000E+00  -1.84859381584862E-12
      3.66467079029145E-18  -2.56599675106478E-01  -2.52338778988325E-01   0.00000000000000E+00  -3.61703377626860E-14
     -9.82043281239038E-23  -1.35243883635125E-08  -1.35244245338504E-08  -2.88562313014480E-18
      1.67954381250000E-07
      0.00000000000000E+00  -1.37197668440603E-11   0.00000000000000E+00   3.12628713015902E-13   1.70486359629814E-22
      1.37197130116564E-08   1.37200256403695E-08  -7.77434024147678E-19  -2.56821798495392E-01  -2.56821798495388E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.27956517558882E-12   0.00000000000000E+00  -3.27956517558882E-12
      3.65811165994028E-18  -2.56049441183231E-01  -2.51728036527795E-01   0.00000000000000E+00  -3.01145113107682E-13
     -9.77854276365471E-23  -1.37164449300808E-08  -1.37167460751940E-08  -2.88067763579260E-18
      1.69954381250000E-07
      0.00000000000000E+00  -1.39626043292370E-11   0.00000000000000E+00   4.50578500534335E-14   1.71626646619845E-22
      1.39625862060120E-08   1.39626312638622E-08  -7.75350652357714E-19  -2.57908154215583E-01  -2.57908154215579E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.67184203701364E-12   0.00000000000000E+00  -4.67184203701364E-12
      3.64876797586625E-18  -2.55040444065708E-01  -2.50642958157282E-01   0.00000000000000E+00  -2.28314696456503E-14
     -9.81651946520403E-23  -1.39579365903554E-08  -1.39579594218252E-08  -2.87341732350854E-18
      1.71954381250000E-07
      0.00000000000000E+00  -1.42115035670694E-11   0.00000000000000E+00   1.86630339876051E-13   1.72278521068041E-22
      1.42115322988194E-08   1.42117189291594E-08  -7.73125498574180E-19  -2.59098129827484E-01  -2.59098129827478E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56145780235900E-12   0.00000000000000E+00  -5.56145780235900E-12
      3.63764506026153E-18  -2.53569164323212E-01  -2.49093524877242E-01   0.00000000000000E+00  -1.63674955927841E-13
     -9.76154489312772E-23  -1.42059937964010E-08  -1.42061574713571E-08  -2.86451956168735E-18
      1.73954381250000E-07
      0.00000000000000E+00  -1.43896823572520E-11   0.00000000000000E+00   2.26925005709414E-14   1.72153961563542E-22
      1.43896257847807E-08   1.43896484772814E-08  -7.71355678154519E-19  -2.60091366462717E-01  -2.60091366462711E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31448470082282E-12   0.00000000000000E+00  -5.31448470082282E-12
      3.62701609085989E-18  -2.51780616351280E-01  -2.47248788366762E-01   0.00000000000000E+00   7.25635775208434E-15
     -9.78855040754580E-23  -1.43843412489383E-08  -1.43843339925806E-08  -2.85566041270537E-18
      1.75954381250000E-07
      0.00000000000000E+00  -1.43856411888149E-11   0.00000000000000E+00  -8.86251027536965E-17   1.70709772236221E-22
      1.43855804944600E-08   1.43855804058350E-08  -7.70918880030333E-19  -2.60437088079406E-01  -2.60437088079403E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.20030866289305E-12   0.00000000000000E+00  -3.20030866289305E-12
      3.62061547353410E-18  -2.50032055078161E-01  -2.45500834918372E-01   0.00000000000000E+00   2.36631893248628E-14
     -9.78085358967864E-23  -1.43824037603614E-08  -1.43823800971721E-08  -2.84969659350377E-18
      1.77954381250000E-07
      0.00000000000000E+00  -1.40707974296675E-11   0.00000000000000E+00   7.79184019675607E-13   1.66502640187397E-22
      1.40707407642665E-08   1.40715199482863E-08  -7.72916173637048E-19  -2.59559409718430E-01  -2.59559409718431E-01
      0.00000000000000E+00   0.00000000000000E+00   1.45872604879954E-12   0.00000000000000E+00   1.45872604879954E-12
      3.62353292563170E-18  -2.48922611602399E-01  -2.44489116453681E-01   0.00000000000000E+00  -7.81674782115279E-13
     -9.88577861478931E-23  -1.40721969995529E-08  -1.40729786743351E-08  -2.85061675199465E-18
      1.79954381250000E-07
      0.00000000000000E+00  -1.33385193399119E-11   0.00000000000000E+00  -1.83138674150615E-14   1.61188321962148E-22
      1.33385731018530E-08   1.33385547879857E-08  -7.78517967911339E-19  -2.56832913451150E-01  -2.56832913451159E-01
      0.00000000000000E+00   0.00000000000000E+00   9.01867828653317E-12   0.00000000000000E+00   9.01867828653317E-12
      3.64157028220477E-18  -2.49245925076145E-01  -2.45040726456978E-01   0.00000000000000E+00  -1.34364304238202E-14
     -9.80048182971097E-23  -1.33475600298417E-08  -1.33475734662723E-08  -2.86305231429343E-18
      1.81954381250000E-07
      0.00000000000000E+00  -1.21631822378672E-11   0.00000000000000E+00  -2.92223580275432E-14   1.52809917507864E-22
      1.21632663040369E-08   1.21632370816791E-08  -7.88630122795592E-19  -2.51748329977600E-01  -2.51748329977619E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91078016303732E-11   0.00000000000000E+00   1.91078016303732E-11
      3.67978588546551E-18  -2.51830283345533E-01  -2.47992199735939E-01   0.00000000000000E+00  -5.38520952012933E-14
     -9.85542537616738E-23  -1.21822910312141E-08  -1.21823448833094E-08  -2.89115576266993E-18
      1.83954381250000E-07
      0.00000000000000E+00  -1.06610615608381E-11   0.00000000000000E+00  -3.74645413666513E-14   1.42235391267057E-22
      1.06611274189612E-08   1.06610899544200E-08  -8.03358545793953E-19  -2.44187429327847E-01  -2.44187429327877E-01
      0.00000000000000E+00   0.00000000000000E+00   3.01673651222114E-11   0.00000000000000E+00   3.01673651222114E-11
      3.74012061570994E-18  -2.57263332764351E-01  -2.53895029475193E-01   0.00000000000000E+00  -1.08464210916485E-13
     -9.96237284146236E-23  -1.06911488553312E-08  -1.06912573195422E-08  -2.93676206991598E-18
      1.85954381250000E-07
      0.00000000000000E+00  -9.10374219674726E-12   0.00000000000000E+00  -3.87836911015163E-14   1.32395425825063E-22
      9.10372210990195E-09   9.10368332621098E-09  -8.21245057134628E-19  -2.34819609986036E-01  -2.34819609986075E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91568993463673E-11   0.00000000000000E+00   3.91568993463673E-11
      3.81843441440267E-18  -2.65597614091954E-01  -2.62717153599543E-01   0.00000000000000E+00  -1.69014841766299E-13
     -1.01110306087587E-22  -9.14267121071550E-09  -9.14284022555736E-09  -2.99718935726804E-18
      1.87954381250000E-07
      0.00000000000000E+00  -7.85961338653410E-12   0.00000000000000E+00  -3.10367382209432E-14   1.25940106066374E-22
      7.85960300644606E-09   7.85957196970796E-09  -8.38480938240663E-19  -2.25514095775069E-01  -2.25514095775110E-01
      0.00000000000000E+00   0.00000000000000E+00   4.17741215527584E-11   0.00000000000000E+00   4.17741215527584E-11
      3.90198265750819E-18  -2.76175623745910E-01  -2.73686307977975E-01   0.00000000000000E+00  -2.14112987949266E-13
     -1.02776225656059E-22  -7.90113197827266E-09  -7.90134609126072E-09  -3.06350171926752E-18
      1.89954381250000E-07
      0.00000000000000E+00  -7.30817758434011E-12   0.00000000000000E+00  -1.37912093949176E-14   1.29020746909984E-22
      7.30817126260626E-09   7.30815747139699E-09  -8.48758535249918E-19  -2.19435583732443E-01  -2.19435583732477E-01
      0.00000000000000E+00   0.00000000000000E+00   3.34943312237008E-11   0.00000000000000E+00   3.34943312237008E-11
      3.96897131995559E-18  -2.87624391414014E-01  -2.85311416375403E-01   0.00000000000000E+00  -2.12656903915721E-13
     -1.04250501747413E-22  -7.34143914571667E-09  -7.34165180262069E-09  -3.12021278470567E-18
      1.91954381250000E-07
      0.00000000000000E+00  -7.83536637591131E-12   0.00000000000000E+00   1.55242399516468E-14   1.47808141842952E-22
      7.83538321565273E-09   7.83539873989283E-09  -8.44981373074996E-19  -2.20259336446744E-01  -2.20259336446755E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14772914208402E-11   0.00000000000000E+00   1.14772914208402E-11
      3.99192590279727E-18  -2.97854854568902E-01  -2.95382715939502E-01   0.00000000000000E+00  -1.43502759337161E-13
     -1.05106799675120E-22  -7.84673252855423E-09  -7.84687603131367E-09  -3.14694452972227E-18
      1.93954381250000E-07
      0.00000000000000E+00  -9.92483414738255E-12   0.00000000000000E+00   5.16969556128633E-14   1.83614010264655E-22
      9.92475585581042E-09   9.92480755276621E-09  -8.23297774897185E-19  -2.30289443478886E-01  -2.30289443478863E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29774916832202E-11   0.00000000000000E+00  -2.29774916832202E-11
      3.94597091943083E-18  -3.03879884373292E-01  -3.00760334496404E-01   0.00000000000000E+00  -1.01544728234324E-14
     -1.04947199016093E-22  -9.90181990661007E-09  -9.90183006108300E-09  -3.12267314453364E-18
      1.95954381250000E-07
      0.00000000000000E+00  -1.40952281297647E-11   0.00000000000000E+00   1.03601533694944E-13   2.25327961625526E-22
      1.40951002351767E-08   1.40952038367106E-08  -7.86515337986667E-19  -2.48655236078158E-01  -2.48655236078096E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.24895700451330E-11   0.00000000000000E+00  -6.24895700451330E-11
      3.82099177934056E-18  -3.01752067793951E-01  -2.97331073179775E-01   0.00000000000000E+00   1.40078784202834E-13
     -1.03508195740509E-22  -1.40328543454496E-08  -1.40327142666655E-08  -3.03447644135390E-18
      1.97954381250000E-07
      0.00000000000000E+00  -2.05235331316567E-11   0.00000000000000E+00   1.59698138405327E-13   2.53435897360967E-22
      2.05233738221340E-08   2.05235335202727E-08  -7.41884309062943E-19  -2.71876355171661E-01  -2.71876355171564E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.62707925114941E-11   0.00000000000000E+00  -9.62707925114941E-11
      3.62845019431757E-18  -2.87235148386317E-01  -2.80799506351978E-01   0.00000000000000E+00   2.81327747285989E-13
     -1.00773205323552E-22  -2.04275440555083E-08  -2.04272627277612E-08  -2.88656588525463E-18
      1.99954381250000E-07
      0.00000000000000E+00  -2.88844350938695E-11   0.00000000000000E+00   2.07362092272974E-13   2.56867177499722E-22
      2.88842571291255E-08   2.88844644912180E-08  -6.95099634320989E-19  -2.96671415954625E-01  -2.96671415954506E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19545650187169E-10   0.00000000000000E+00  -1.19545650187169E-10
      3.38935889394324E-18  -2.56786378883116E-01  -2.47723844892394E-01   0.00000000000000E+00   3.98545875878709E-13
     -9.72122399338120E-23  -2.87653173869066E-08  -2.87649188410309E-08  -2.69425925962225E-18
      2.01954381250000E-07
      0.00000000000000E+00  -3.83905490843229E-11   0.00000000000000E+00   2.35886326040515E-13   2.32707783598664E-22
      3.83903237203302E-08   3.83905596066565E-08  -6.48341464701074E-19  -3.21494401864059E-01  -3.21494401863921E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37602715343585E-10   0.00000000000000E+00  -1.37602715343585E-10
      3.11415346325607E-18  -2.08450235120018E-01  -1.96398293502581E-01   0.00000000000000E+00   4.41880035366678E-13
     -8.98082725452647E-23  -3.82533987713482E-08  -3.82529568913129E-08  -2.46581199855499E-18
      2.03954381250000E-07
      0.00000000000000E+00  -4.75078843021769E-11   0.00000000000000E+00   2.26514168945628E-13   1.72238796309249E-22
      4.75076586886262E-08   4.75078852027953E-08  -6.02161571842712E-19  -3.45939478355489E-01  -3.45939478355333E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.56828190969793E-10   0.00000000000000E+00  -1.56828190969793E-10
      2.80049708131648E-18  -1.43294316079933E-01  -1.28375761372561E-01   0.00000000000000E+00   3.86630550376326E-13
     -8.28324746628917E-23  -4.73514436423759E-08  -4.73510570118256E-08  -2.19833550947377E-18
      2.05954381250000E-07
      0.00000000000000E+00  -5.05593338511598E-11   0.00000000000000E+00   1.20798836676074E-12   8.24382387813757E-23
      5.05592287779024E-08   5.05604367662692E-08  -5.55907512850110E-19  -3.69916872757389E-01  -3.69916872757219E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69823649680889E-10   0.00000000000000E+00  -1.69823649680889E-10
      2.46084978195470E-18  -7.34546545083062E-02  -5.75786756811186E-02   0.00000000000000E+00  -7.79149578510913E-13
     -5.99145987587277E-23  -5.03898339670098E-08  -5.03906131165884E-08  -1.90494226910460E-18
      2.07954381250000E-07
      0.00000000000000E+00  -3.64239695712354E-11   0.00000000000000E+00  -3.49674071067051E-13   2.74045354409965E-23
      3.64242851826594E-08   3.64239355085884E-08  -5.02666049570451E-19  -3.93468384423677E-01  -3.93468384423538E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.38797041089940E-10   0.00000000000000E+00  -1.38797041089940E-10
      2.18325569977482E-18  -3.25121030023280E-02  -2.10798562896594E-02   0.00000000000000E+00   5.48536050533809E-13
     -2.36923444372167E-23  -3.62856870035489E-08  -3.62851384674984E-08  -1.68058965020437E-18
      2.09954381250000E-07
      0.00000000000000E+00  -2.37950426709888E-11   0.00000000000000E+00  -3.11727610031314E-13   1.09909223440950E-23
      2.37953452117295E-08   2.37950334841194E-08  -4.45433767377123E-19  -4.16533329497352E-01  -4.16533329497246E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06057926701360E-10   0.00000000000000E+00  -1.06057926701360E-10
      1.97113984637210E-18  -1.69608181884769E-02  -9.49719069554489E-03   0.00000000000000E+00   3.99814918510092E-13
     -1.10820589658718E-23  -2.36893753723366E-08  -2.36889755574181E-08  -1.52570607899498E-18
      2.11954381250000E-07
      0.00000000000000E+00  -1.86614729295113E-11   0.00000000000000E+00  -1.26310010090387E-13   6.35518720874627E-24
      1.86615650748342E-08   1.86614387648241E-08  -3.89823710083603E-19  -4.38868922382193E-01  -4.38868922382098E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.55184089711892E-11   0.00000000000000E+00  -9.55184089711892E-11
      1.78010302842972E-18  -1.17049511780277E-02  -5.85542485040209E-03   0.00000000000000E+00   1.81408610655124E-13
     -6.96283865897175E-24  -1.85661017644636E-08  -1.85659203558529E-08  -1.39027931834612E-18
      2.13954381250000E-07
      0.00000000000000E+00  -1.69838369596786E-11   0.00000000000000E+00  -4.23011416950399E-14   4.70986739199525E-24
      1.69838682952776E-08   1.69838259941359E-08  -3.38120231037628E-19  -4.59987278858578E-01  -4.59987278858486E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.20547442292112E-11   0.00000000000000E+00  -9.20547442292112E-11
      1.59599353997130E-18  -9.80801287993937E-03  -4.48595199768627E-03   0.00000000000000E+00   8.38791920569008E-14
     -5.27716293424600E-24  -1.68918551290987E-08  -1.68917712499067E-08  -1.25787330893368E-18
      2.15954381250000E-07
      0.00000000000000E+00  -1.64403916496217E-11   0.00000000000000E+00  -1.30863518014889E-14   3.94267772297149E-24
      1.64404367754403E-08   1.64404236890886E-08  -2.92452926499201E-19  -4.79043751472137E-01  -4.79043751472050E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.65726906643432E-11   0.00000000000000E+00  -8.65726906643432E-11
      1.42284815864262E-18  -8.98808795456595E-03  -3.83550547821059E-03   0.00000000000000E+00   4.56313035266722E-14
     -4.42019770055463E-24  -1.63538966297277E-08  -1.63538509984242E-08  -1.13039523214341E-18
      2.17954381250000E-07
      0.00000000000000E+00  -1.62276792382491E-11   0.00000000000000E+00  -5.00789586051727E-15   3.52155773088903E-24
      1.62276698349295E-08   1.62276648270337E-08  -2.55662824041125E-19  -4.94725867598038E-01  -4.94725867597963E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.40661801532918E-11   0.00000000000000E+00  -7.40661801532918E-11
      1.27471579833603E-18  -8.56744392104531E-03  -3.47795205699908E-03   0.00000000000000E+00   2.90755754260518E-14
     -3.92868118460935E-24  -1.61536277224558E-08  -1.61535986468804E-08  -1.01905297429491E-18
      2.19954381250000E-07
      0.00000000000000E+00  -1.61051583588142E-11   0.00000000000000E+00  -2.87033714627435E-15   3.29123993453285E-24
      1.61051307314167E-08   1.61051278610796E-08  -2.31423954514658E-19  -5.05235697203942E-01  -5.05235697203891E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.10729121216875E-11   0.00000000000000E+00  -5.10729121216875E-11
      1.17256997409266E-18  -8.34363865341993E-03  -3.28550829565468E-03   0.00000000000000E+00   1.76008224785895E-14
     -3.66510383277861E-24  -1.60540725497804E-08  -1.60540549489579E-08  -9.41146019578000E-19
      2.21954381250000E-07
      0.00000000000000E+00  -1.59994450662884E-11   0.00000000000000E+00  -2.56145111589019E-15   3.20536210203866E-24
      1.59994893909615E-08   1.59994868295104E-08  -2.24134927249927E-19  -5.08421883676863E-01  -5.08421883676847E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57420887937886E-11   0.00000000000000E+00  -1.57420887937886E-11
      1.14108579650508E-18  -8.25700584764392E-03  -3.22102756224456E-03   0.00000000000000E+00   6.19702606036558E-15
     -3.59685673833558E-24  -1.59837509377427E-08  -1.59837447407166E-08  -9.16950869255153E-19
      2.23954381250000E-07
      0.00000000000000E+00  -1.58792203052837E-11   0.00000000000000E+00  -3.06022616133574E-15   3.26996527004675E-24
      1.58792531874455E-08   1.58792501272194E-08  -2.39123070807897E-19  -5.01868267414378E-01  -5.01868267414410E-01
      0.00000000000000E+00   0.00000000000000E+00   3.20846024625884E-11   0.00000000000000E+00   3.20846024625884E-11
      1.20525500143026E-18  -8.30984623553795E-03  -3.29668300239491E-03   0.00000000000000E+00  -7.37317706687614E-15
     -3.76238544337879E-24  -1.59113273565049E-08  -1.59113347296820E-08  -9.66131930622360E-19
      2.25954381250000E-07
      0.00000000000000E+00  -1.57080217151289E-11   0.00000000000000E+00  -1.61163479222489E-14   3.55515857072868E-24
      1.57080186540085E-08   1.57080025376606E-08  -2.83417743925630E-19  -4.82834556644549E-01  -4.82834556644640E-01
      0.00000000000000E+00   0.00000000000000E+00   9.07407907327328E-11   0.00000000000000E+00   9.07407907327328E-11
      1.38673658289572E-18  -8.57853438973898E-03  -3.60084443268850E-03   0.00000000000000E+00  -1.39447286016660E-14
     -4.34236523617513E-24  -1.57987293836647E-08  -1.57987433283933E-08  -1.10331883897009E-18
      2.27954381250000E-07
      0.00000000000000E+00  -1.53782072638167E-11   0.00000000000000E+00  -8.73480456476987E-15   4.28039686408199E-24
      1.53782261828208E-08   1.53782174480162E-08  -3.66635159625208E-19  -4.48194080325346E-01  -4.48194080325500E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54886116490507E-10   0.00000000000000E+00   1.54886116490507E-10
      1.69650881587674E-18  -9.35836592719698E-03  -4.46438053163548E-03   0.00000000000000E+00  -5.28622886503665E-14
     -6.05947316083872E-24  -1.55330507022181E-08  -1.55331035645067E-08  -1.32987365625153E-18
      2.29954381250000E-07
      0.00000000000000E+00  -1.43668130176874E-11   0.00000000000000E+00  -2.63717843372145E-14   5.96821759422255E-24
      1.43668517733952E-08   1.43668254016108E-08  -4.99130657223928E-19  -3.94635592452451E-01  -3.94635592452665E-01
      0.00000000000000E+00   0.00000000000000E+00   2.13388449570171E-10   0.00000000000000E+00   2.13388449570171E-10
      2.12328571501708E-18  -1.19823959471897E-02  -7.38864788062359E-03   0.00000000000000E+00  -9.69776940129852E-14
     -1.28280850125561E-23  -1.45801168734870E-08  -1.45802138511810E-08  -1.62415505779315E-18
      2.31954381250000E-07
      0.00000000000000E+00  -9.89608674463659E-12   0.00000000000000E+00  -1.13383420220892E-13   5.51540092259895E-24
      9.89624588695556E-09   9.89613250353534E-09  -6.77072087059204E-19  -3.19574301219001E-01  -3.19574301219269E-01
      0.00000000000000E+00   0.00000000000000E+00   2.67679188756843E-10   0.00000000000000E+00   2.67679188756843E-10
      2.65864409253077E-18  -2.31812642156389E-02  -1.99789984949032E-02   0.00000000000000E+00  -1.60674617165722E-13
     -4.47468401445194E-23  -1.01636510176750E-08  -1.01638116922922E-08  -1.98157200547156E-18
      2.33954381250000E-07
      0.00000000000000E+00  -2.14099266904466E-12   0.00000000000000E+00  -1.95015062849335E-13  -2.39001929993630E-23
      2.14115307315312E-09   2.14095805809025E-09  -8.77733578368842E-19  -2.24516590254646E-01  -2.24516590254970E-01
      0.00000000000000E+00   0.00000000000000E+00   3.24793175011181E-10   0.00000000000000E+00   3.24793175011181E-10
      3.30823044255313E-18  -4.91930425009877E-02  -4.84161780549509E-02   0.00000000000000E+00  -3.90119296926940E-13
     -8.23466202701611E-23  -2.46536111380442E-09  -2.46575123310143E-09  -2.43049686418428E-18
      2.35954381250000E-07
      0.00000000000000E+00  -7.86190950496429E-14   0.00000000000000E+00  -5.68707346474587E-14  -4.31878227399619E-23
      7.86316784227056E-11   7.85748076880149E-11  -1.09183034806373E-18  -1.19778057706022E-01  -1.19778057706345E-01
      0.00000000000000E+00   0.00000000000000E+00   3.22772530099868E-10   0.00000000000000E+00   3.22772530099868E-10
      3.95377550275286E-18  -7.87127571467323E-02  -7.85863089112848E-02   0.00000000000000E+00  -9.76445338293377E-13
     -9.37147047475166E-23  -4.00370892449495E-10  -4.01347337787882E-10  -2.86194515468913E-18
      2.37954381250000E-07
      0.00000000000000E+00   5.87806318128171E-14   0.00000000000000E+00  -8.67561264567938E-15  -4.58811414592032E-23
     -5.87802529828907E-11  -5.87889285955823E-11  -1.23690016676472E-18  -4.75722086263194E-02  -4.75722086265480E-02
      0.00000000000000E+00   0.00000000000000E+00   2.28546670562986E-10   0.00000000000000E+00   2.28546670562986E-10
      4.41086884387884E-18  -1.08087662016426E-01  -1.08034178290402E-01   0.00000000000000E+00  -1.11665414049699E-12
     -1.02762610474011E-22  -1.68641087826804E-10  -1.69757741967404E-10  -3.17396867711411E-18
      2.39954381250000E-07
      0.00000000000000E+00   2.12161342949387E-14   0.00000000000000E+00  -6.50460925251527E-16  -4.62882963106176E-23
     -2.12328273342196E-11  -2.12334777951911E-11  -1.29339162260098E-18  -2.07095459699304E-02  -2.07095459700568E-02
      0.00000000000000E+00   0.00000000000000E+00   1.26387641683552E-10   0.00000000000000E+00   1.26387641683552E-10
      4.66364412724594E-18  -1.36989230971426E-01  -1.36956101519170E-01   0.00000000000000E+00  -6.91920013748985E-13
     -1.07178476876048E-22  -1.04462243874506E-10  -1.05154163888362E-10  -3.37025250464496E-18
      2.41954381250000E-07
      0.00000000000000E+00  -5.69437370686666E-15   0.00000000000000E+00   5.40844611346608E-16  -4.60832004379508E-23
      5.73065397462974E-12   5.73119481919500E-12  -1.31216786443219E-18  -1.24547467876757E-02  -1.24547467877539E-02
      0.00000000000000E+00   0.00000000000000E+00   7.81701849095521E-11   0.00000000000000E+00   7.81701849095521E-11
      4.81998449706505E-18  -1.65336360682458E-01  -1.65309927277974E-01   0.00000000000000E+00  -4.74385586299791E-13
     -1.09918276843611E-22  -8.34269941423370E-11  -8.39013797287467E-11  -3.50781663263285E-18
      2.43954381250000E-07
      0.00000000000000E+00  -2.27774948274666E-14   0.00000000000000E+00   8.14890469711962E-16  -4.53310226208448E-23
      2.27439777484843E-11   2.27447926389087E-11  -1.31738523272388E-18  -9.85982235519274E-03  -9.85982235524904E-03
      0.00000000000000E+00   0.00000000000000E+00   5.62995763270711E-11   0.00000000000000E+00   5.62995763270711E-11
      4.93258364971919E-18  -1.93106037154927E-01  -1.93081134241643E-01   0.00000000000000E+00  -4.27521759247571E-13
     -1.12266380286415E-22  -7.86168472066201E-11  -7.90443689659800E-11  -3.61519841699531E-18
      2.45954381250000E-07
      0.00000000000000E+00  -3.52683790876903E-14   0.00000000000000E+00   6.62235977558300E-16  -4.36532606199966E-23
      3.52981900712385E-11   3.52988523071724E-11  -1.31753779993038E-18  -8.87460371197182E-03  -8.87460371201657E-03
      0.00000000000000E+00   0.00000000000000E+00   4.47451201928673E-11   0.00000000000000E+00   4.47451201928673E-11
      5.02207389010492E-18  -2.20301539375990E-01  -2.20276321735782E-01   0.00000000000000E+00  -4.34369423545672E-13
     -1.14568013607010E-22  -7.96096030763794E-11  -8.00439725000397E-11  -3.70453609017454E-18
      2.47954381250000E-07
      0.00000000000000E+00  -4.56468343921408E-14   0.00000000000000E+00   5.24009612701070E-16  -4.04543822292668E-23
      4.56819562315533E-11   4.56824802411256E-11  -1.31566340178347E-18  -8.38169834710955E-03  -8.38169834714721E-03
      0.00000000000000E+00   0.00000000000000E+00   3.76576640532344E-11   0.00000000000000E+00   3.76576640532344E-11
      5.09738921821139E-18  -2.46935673433361E-01  -2.46909417557711E-01   0.00000000000000E+00  -4.52072481071854E-13
     -1.16892444020611E-22  -8.28880718131708E-11  -8.33401442943596E-11  -3.78172581642792E-18
      2.49954381250000E-07
      0.00000000000000E+00  -5.48313081128935E-14   0.00000000000000E+00   4.25152363906989E-16  -3.52274048291897E-23
      5.48218558433186E-11   5.48222809956472E-11  -1.31298481704451E-18  -8.07418831122840E-03  -8.07418831126129E-03
      0.00000000000000E+00   0.00000000000000E+00   3.28899844723081E-11   0.00000000000000E+00   3.28899844723081E-11
      5.16316918715601E-18  -2.73021686022731E-01  -2.72994052970498E-01   0.00000000000000E+00  -4.70120490049989E-13
     -1.19244519417350E-22  -8.72421449777864E-11  -8.77122654679556E-11  -3.85018437011149E-18
      2.51954381250000E-07
      0.00000000000000E+00  -6.31891791987784E-14   0.00000000000000E+00   3.58988459121029E-16  -2.72012978606785E-23
      6.31632055564039E-11   6.31635645448358E-11  -1.31005049444053E-18  -7.85725721950395E-03  -7.85725721953345E-03
      0.00000000000000E+00   0.00000000000000E+00   2.94972581277525E-11   0.00000000000000E+00   2.94972581277525E-11
      5.22216370341151E-18  -2.98568505207792E-01  -2.98539313411219E-01   0.00000000000000E+00  -4.87373270893268E-13
     -1.21622040391616E-22  -9.21734494015731E-11  -9.26608226725880E-11  -3.91211320897098E-18
      2.53954381250000E-07
      0.00000000000000E+00  -7.09959818614182E-14   0.00000000000000E+00   3.15312440851073E-16  -1.63793687285410E-23
      7.09723068453476E-11   7.09726221577721E-11  -1.30711560392980E-18  -7.69404139158469E-03  -7.69404139161166E-03
      0.00000000000000E+00   0.00000000000000E+00   2.69716507132443E-11   0.00000000000000E+00   2.69716507132443E-11
      5.27610700483800E-18  -3.23583012026381E-01  -3.23552156014840E-01   0.00000000000000E+00  -5.04859814350815E-13
     -1.24025123291225E-22  -9.74394130565425E-11  -9.79442728710173E-11  -3.96899140090820E-18
      2.55954381250000E-07
      0.00000000000000E+00  -7.84354055752278E-14   0.00000000000000E+00   2.86395700411048E-16  -2.30778633786122E-24
      7.84280299644952E-11   7.84283163601933E-11  -1.30429271966367E-18  -7.56668947297296E-03  -7.56668947299796E-03
      0.00000000000000E+00   0.00000000000000E+00   2.50045943874185E-11   0.00000000000000E+00   2.50045943874185E-11
      5.32611619361284E-18  -3.48072796050618E-01  -3.48040211217215E-01   0.00000000000000E+00  -5.23853481665381E-13
     -1.26460090951688E-22  -1.02909057265819E-10  -1.03432910747611E-10  -4.02182347394916E-18
      2.57954381250000E-07
      0.00000000000000E+00  -8.55992950774149E-14   0.00000000000000E+00   2.66677694967949E-16   1.39689777152197E-23
      8.56422748340770E-11   8.56425415117859E-11  -1.30162486392876E-18  -7.46521856324555E-03  -7.46521856326893E-03
      0.00000000000000E+00   0.00000000000000E+00   2.33836780645275E-11   0.00000000000000E+00   2.33836780645275E-11
      5.37288354974189E-18  -3.72026436030738E-01  -3.71992089437898E-01   0.00000000000000E+00  -5.44788603849316E-13
     -1.28932692856240E-22  -1.08481430972335E-10  -1.09026219576313E-10  -4.07125868581313E-18
      2.59954381250000E-07
      0.00000000000000E+00  -9.27631845796020E-14   0.00000000000000E+00   2.56193988906733E-16   3.09585133809303E-23
      9.27611291733343E-11   9.27613853673542E-11  -1.29908131409722E-18  -7.40055049637235E-03  -7.40055049639434E-03
      0.00000000000000E+00   0.00000000000000E+00   2.19933670045822E-11   0.00000000000000E+00   2.19933670045822E-11
      5.41687028375106E-18  -3.95490847622105E-01  -3.95454696710230E-01   0.00000000000000E+00  -5.69573454120768E-13
     -1.31455393678425E-22  -1.14185178917685E-10  -1.14754752371937E-10  -4.11778896965384E-18
      2.61954381250000E-07
      0.00000000000000E+00  -9.98352293445816E-14   0.00000000000000E+00   2.49197074905116E-16   4.77199940359960E-23
      9.98295665850651E-11   9.98298157821877E-11  -1.29665793927475E-18  -7.36180490997998E-03  -7.36180491000084E-03
      0.00000000000000E+00   0.00000000000000E+00   2.08614754803213E-11   0.00000000000000E+00   2.08614754803213E-11
      5.45859323471170E-18  -4.18605811679489E-01  -4.18567790964294E-01   0.00000000000000E+00  -6.02625151023426E-13
     -1.34056472936079E-22  -1.20088666111351E-10  -1.20691291262508E-10  -4.16193529543695E-18
      2.63954381250000E-07
      0.00000000000000E+00  -1.06815429372354E-13   0.00000000000000E+00   2.41882022173800E-16   6.33738608662360E-23
      1.06821668761539E-10   1.06821910643624E-10  -1.29436608458326E-18  -7.33668048135930E-03  -7.33668048137911E-03
      0.00000000000000E+00   0.00000000000000E+00   1.98017285952765E-11   0.00000000000000E+00   1.98017285952765E-11
      5.49819669190225E-18  -4.41315869314941E-01  -4.41275980170480E-01   0.00000000000000E+00  -6.37809264108924E-13
     -1.36732728188069E-22  -1.25985829974655E-10  -1.26623639238901E-10  -4.20383060731899E-18
      2.65954381250000E-07
      0.00000000000000E+00  -1.13795629400126E-13   0.00000000000000E+00   2.36016476448760E-16   7.73117329871273E-23
      1.13751214739522E-10   1.13751450756076E-10  -1.29219331962096E-18  -7.32526710618909E-03  -7.32526710620786E-03
      0.00000000000000E+00   0.00000000000000E+00   1.87738732509965E-11   0.00000000000000E+00   1.87738732509965E-11
      5.53574443840425E-18  -4.63580190647955E-01  -4.63538442791630E-01   0.00000000000000E+00  -6.74771877250171E-13
     -1.39476067069952E-22  -1.31850552129682E-10  -1.32525324007072E-10  -4.24355111878328E-18
      2.67954381250000E-07
      0.00000000000000E+00  -1.20592139953483E-13   0.00000000000000E+00   2.31773734683404E-16   8.92530448159010E-23
      1.20637776716080E-10   1.20638008489904E-10  -1.29011839698611E-18  -7.33119523079272E-03  -7.33119523081051E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77840148547268E-11   0.00000000000000E+00   1.77840148547268E-11
      5.57131246811370E-18  -4.85394188237861E-01  -4.85350583301462E-01   0.00000000000000E+00  -7.13874725963294E-13
     -1.42276774593329E-22  -1.37708148618525E-10  -1.38422023344630E-10  -4.28119407112758E-18
      2.69954381250000E-07
      0.00000000000000E+00  -1.27480495244047E-13   0.00000000000000E+00   2.29627527137618E-16   9.92080860140215E-23
      1.27515971463884E-10   1.27516201091511E-10  -1.28811248757074E-18  -7.36156037331973E-03  -7.36156037333656E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68310663552746E-11   0.00000000000000E+00   1.68310663552746E-11
      5.60497460082425E-18  -5.06764148984967E-01  -5.06718678042129E-01   0.00000000000000E+00  -7.54256895369787E-13
     -1.45119466090591E-22  -1.43593010551272E-10  -1.44347267446787E-10  -4.31686211325351E-18
      2.71954381250000E-07
      0.00000000000000E+00  -1.34736229483442E-13   0.00000000000000E+00   2.39326645101330E-16   1.07549296542087E-22
      1.34695976674738E-10   1.34696216001491E-10  -1.28602788612126E-18  -7.47901489799399E-03  -7.47901489800981E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58208960718187E-11   0.00000000000000E+00   1.58208960718187E-11
      5.63661639296789E-18  -5.27698652980416E-01  -5.27651239051540E-01   0.00000000000000E+00  -7.92165346104131E-13
     -1.47975167390146E-22  -1.49724946727057E-10  -1.50517112073309E-10  -4.35058850684663E-18
      2.73954381249999E-07
      0.00000000000000E+00  -1.42726721620497E-13   0.00000000000000E+00   2.78300829006467E-16   1.14870167167159E-22
      1.42739815240032E-10   1.42740093540976E-10  -1.28359887151479E-18  -7.79691498683508E-03  -7.79691498684975E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46627683857487E-11   0.00000000000000E+00   1.46627683857487E-11
      5.66594192973938E-18  -5.48205846596362E-01  -5.48156264249833E-01   0.00000000000000E+00  -8.23371444189218E-13
     -1.50804840370251E-22  -1.56579490482384E-10  -1.57402861926724E-10  -4.38234305822459E-18
      2.75954381249999E-07
      0.00000000000000E+00  -1.54391003245852E-13   0.00000000000000E+00   4.26542038869301E-16   1.23012457970204E-22
      1.54374015025139E-10   1.54374441567301E-10  -1.27970407855787E-18  -8.82044446224038E-03  -8.82044446225304E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26544947455494E-11   0.00000000000000E+00   1.26544947455494E-11
      5.69125091923048E-18  -5.68289853476767E-01  -5.68237239616177E-01   0.00000000000000E+00  -8.26577181293525E-13
     -1.53509985858002E-22  -1.66202359131403E-10  -1.67028936312850E-10  -4.41154684067261E-18
      2.77954381249999E-07
      0.00000000000000E+00  -1.93884240245089E-13   0.00000000000000E+00   1.52645039068718E-15   1.45516861805311E-22
      1.93888852485942E-10   1.93890378936478E-10  -1.26561246372105E-18  -1.45235430258956E-02  -1.45235430258991E-02
      0.00000000000000E+00   0.00000000000000E+00   3.50754074502854E-12   0.00000000000000E+00   3.50754074502854E-12
      5.69826600072054E-18  -5.87919708648147E-01  -5.87857529631653E-01   0.00000000000000E+00  -6.23848510079213E-13
     -1.55466211000427E-22  -1.96774071171272E-10  -1.97397919681507E-10  -4.43265353699949E-18
      2.79954381249999E-07
      0.00000000000000E+00  -4.07698788464211E-13   0.00000000000000E+00   7.30837922184647E-15   2.33773035142728E-22
      4.07741239045612E-10   4.07748547425068E-10  -1.20901792517610E-18  -3.87982934196195E-02  -3.87982934195868E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.26674970971465E-11   0.00000000000000E+00  -3.26674970971465E-11
      5.63293100652625E-18  -6.06819513281286E-01  -6.06701366564782E-01   0.00000000000000E+00   2.82833853637633E-13
     -1.54581243256003E-22  -3.75363884181404E-10  -3.75081050327921E-10  -4.42391308135015E-18
      2.81954381249999E-07
      0.00000000000000E+00  -8.82627924564332E-13   0.00000000000000E+00   1.37832164526159E-14   3.14288073191956E-22
      8.82655651176836E-10   8.82669434393602E-10  -1.13552890800191E-18  -6.84911502806738E-02  -6.84911502806231E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.06245640438809E-11   0.00000000000000E+00  -5.06245640438809E-11
      5.53168187843849E-18  -6.24463064110492E-01  -6.24200976320848E-01   0.00000000000000E+00   4.96762346969125E-13
     -1.52991811449318E-22  -8.32541632696537E-10  -8.32044870349721E-10  -4.39615297043657E-18
      2.83954381249999E-07
      0.00000000000000E+00  -1.79951393610707E-12   0.00000000000000E+00   2.43510348239385E-14   3.63427082504651E-22
      1.79950327429613E-09   1.79952762533132E-09  -1.06204538293950E-18  -9.80660772475420E-02  -9.80660772474816E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.04000602916424E-11   0.00000000000000E+00  -6.04000602916424E-11
      5.41088175785520E-18  -6.40003200950127E-01  -6.39455384623582E-01   0.00000000000000E+00   4.29667398608774E-13
     -1.51559499414475E-22  -1.73955723243813E-09  -1.73912756503968E-09  -4.34883637491570E-18
      2.85954381249999E-07
      0.00000000000000E+00  -3.42700267942445E-12   0.00000000000000E+00   4.16281873219410E-14   3.99729916704861E-22
      3.42698563437301E-09   3.42702726256074E-09  -9.94101210276766E-19  -1.27170812546210E-01  -1.27170812546138E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19120165267981E-11   0.00000000000000E+00  -7.19120165267981E-11
      5.26705772480160E-18  -6.52107782391319E-01  -6.51050931619469E-01   0.00000000000000E+00   3.37272172467136E-13
     -1.50373608037288E-22  -3.35545251820625E-09  -3.35511524603394E-09  -4.27295651452484E-18
      2.86454381249999E-07
      0.00000000000000E+00  -3.99910354749013E-12   0.00000000000000E+00   5.78198086097745E-14   4.14023827359172E-22
      3.99907151321605E-09   3.99912933302508E-09  -9.77657408977872E-19  -1.34414529683661E-01  -1.34414529683585E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.61968016480877E-11   0.00000000000000E+00  -7.61968016480877E-11
      5.22895932397756E-18  -6.54839650804178E-01  -6.53603937632528E-01   0.00000000000000E+00   2.89565324275167E-13
     -1.50106849079661E-22  -3.92322209670111E-09  -3.92293253137699E-09  -4.25130191499968E-18
      2.87129381249999E-07
      0.00000000000000E+00  -4.87769030361733E-12   0.00000000000000E+00   6.55210513286559E-14   4.30430202651813E-22
      4.87757131211477E-09   4.87763683316653E-09  -9.56521647135437E-19  -1.44129901657026E-01  -1.44129901656945E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.17421349522079E-11   0.00000000000000E+00  -8.17421349522079E-11
      5.17378338288482E-18  -6.57924684242393E-01  -6.56413987785744E-01   0.00000000000000E+00   2.43701172489150E-13
     -1.49793709925733E-22  -4.79613839938665E-09  -4.79589469821431E-09  -4.21726173574938E-18
      2.88040631249999E-07
      0.00000000000000E+00  -6.26390292229053E-12   0.00000000000000E+00   7.62863434665121E-14   4.45821137712267E-22
      6.26383032580453E-09   6.26390661214844E-09  -9.29660983483722E-19  -1.57124809099204E-01  -1.57124809099115E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.95048840203881E-11   0.00000000000000E+00  -8.95048840203881E-11
      5.09222205732124E-18  -6.60821929652503E-01  -6.58877002519419E-01   0.00000000000000E+00   1.96729939978876E-13
     -1.49434861836736E-22  -6.17459845806789E-09  -6.17440172812807E-09  -4.16256107383752E-18
      2.89270818749999E-07
      0.00000000000000E+00  -8.51345607071448E-12   0.00000000000000E+00   9.10840414822753E-14   4.57569115417419E-22
      8.51336634432941E-09   8.51345742837134E-09  -8.95866805758733E-19  -1.74444692539690E-01  -1.74444692539590E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.98367734444496E-11   0.00000000000000E+00  -9.98367734444496E-11
      4.96940410658955E-18  -6.61996728437382E-01  -6.59346443522869E-01   0.00000000000000E+00   1.79268668901425E-13
     -1.48972036653741E-22  -8.41379992359565E-09  -8.41362065492689E-09  -4.07353730083081E-18
      2.90931571874999E-07
      0.00000000000000E+00  -1.22808353462300E-11   0.00000000000000E+00   1.12973493137605E-13   4.62679376273125E-22
      1.22807645177429E-08   1.22808774912365E-08  -8.53516268394995E-19  -1.97423231647153E-01  -1.97423231647041E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12352809119923E-10   0.00000000000000E+00  -1.12352809119923E-10
      4.78281382774111E-18  -6.57494200515818E-01  -6.53661103743108E-01   0.00000000000000E+00   2.78929136190684E-13
     -1.48025983085850E-22  -1.21688036112526E-08  -1.21685246821166E-08  -3.92929755934611E-18
      2.92931571874999E-07
      0.00000000000000E+00  -1.80967196404222E-11   0.00000000000000E+00   1.44485201298909E-13   4.58788579602204E-22
      1.80965433827330E-08   1.80966878679347E-08  -8.05542743285919E-19  -2.24524016335637E-01  -2.24524016335513E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24483789816521E-10   0.00000000000000E+00  -1.24483789816521E-10
      4.53384624810807E-18  -6.40927370117526E-01  -6.35266041301061E-01   0.00000000000000E+00   6.24578275063256E-13
     -1.45566818837563E-22  -1.79728286563931E-08  -1.79722040781182E-08  -3.72830350482215E-18
      2.94931571874999E-07
      0.00000000000000E+00  -2.56282636256511E-11   0.00000000000000E+00   1.86894326637536E-13   4.45901991229684E-22
      2.56280957223217E-08   2.56282826166488E-08  -7.59179933812660E-19  -2.51067840598767E-01  -2.51067840598634E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33662165477846E-10   0.00000000000000E+00  -1.33662165477846E-10
      4.26652191715237E-18  -6.10094161970864E-01  -6.02063065085242E-01   0.00000000000000E+00   1.18271417513041E-12
     -1.40753105097019E-22  -2.54958031653460E-08  -2.54946204511710E-08  -3.50734198333971E-18
      2.96931571874999E-07
      0.00000000000000E+00  -3.51778201768036E-11   0.00000000000000E+00   2.36940182465268E-13   4.22462603368626E-22
      3.51776148644235E-08   3.51778518046063E-08  -7.13489915203544E-19  -2.77067341581018E-01  -2.77067341580877E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41229648133199E-10   0.00000000000000E+00  -1.41229648133199E-10
      3.98406262088597E-18  -5.61337508079343E-01  -5.50300217656236E-01   0.00000000000000E+00   1.78115731601143E-12
     -1.32797930580865E-22  -3.50384033137890E-08  -3.50366221564731E-08  -3.27057270568243E-18
      2.98931571874999E-07
      0.00000000000000E+00  -4.67144376174411E-11   0.00000000000000E+00   2.86456992505697E-13   3.80931839262845E-22
      4.67141187018502E-08   4.67144051588431E-08  -6.68163786314253E-19  -3.02529163516286E-01  -3.02529163516135E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50398107372513E-10   0.00000000000000E+00  -1.50398107372513E-10
      3.68326640614095E-18  -4.91103465543175E-01  -4.76434233738064E-01   0.00000000000000E+00   2.09796728201820E-12
     -1.22150155086332E-22  -4.65661050187524E-08  -4.65640070514705E-08  -3.01510261982669E-18
      3.00931571874999E-07
      0.00000000000000E+00  -5.94257492469628E-11   0.00000000000000E+00   3.16100665763761E-13   3.10021923970226E-22
      5.94254596671071E-08   5.94257757677731E-08  -6.23324351933366E-19  -3.27456883538692E-01  -3.27456883538529E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62838774978320E-10   0.00000000000000E+00  -1.62838774978320E-10
      3.35758885618431E-18  -3.97422329857963E-01  -3.78751802838337E-01   0.00000000000000E+00   1.99357956581203E-12
     -1.10463768903441E-22  -5.92649305723605E-08  -5.92629369927948E-08  -2.73426450425094E-18
      3.02931571874999E-07
      0.00000000000000E+00  -7.14938721818202E-11   0.00000000000000E+00   3.00702223017587E-13   2.42196260522582E-22
      7.14935659638139E-08   7.14938666660372E-08  -5.78994383008493E-19  -3.51859019468077E-01  -3.51859019467901E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.76097642893464E-10   0.00000000000000E+00  -1.76097642893464E-10
      3.00539357039738E-18  -2.81956681153976E-01  -2.59487574185043E-01   0.00000000000000E+00   1.66322030716027E-12
     -9.70344887463857E-23  -7.13194322434508E-08  -7.13177690231437E-08  -2.42639918738889E-18
      3.04931571874999E-07
      0.00000000000000E+00  -7.79987756945433E-11   0.00000000000000E+00   1.62561979160717E-13   1.59304914294059E-22
      7.79986487560017E-08   7.79988113179810E-08  -5.35825659847319E-19  -3.75725118854819E-01  -3.75725118854619E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99830073912468E-10   0.00000000000000E+00  -1.99830073912468E-10
      2.60573342257244E-18  -1.56020009910118E-01  -1.31508396892585E-01   0.00000000000000E+00   1.05015762552051E-12
     -8.29184476576210E-23  -7.78000314016940E-08  -7.77989812440686E-08  -2.06990776272512E-18
      3.06931571874999E-07
      0.00000000000000E+00  -6.37922317432830E-11   0.00000000000000E+00  -3.53169575198575E-13   5.11266458421549E-23
      6.37925577768882E-08   6.37922046073131E-08  -4.89438521724461E-19  -3.99114863604665E-01  -3.99114863604467E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.98339388678385E-10   0.00000000000000E+00  -1.98339388678385E-10
      2.20905464521567E-18  -6.02029251863970E-02  -4.01666230139188E-02   0.00000000000000E+00   8.46504292653247E-13
     -4.53973866085524E-23  -6.35947117229274E-08  -6.35938652186347E-08  -1.71961612349121E-18
      3.08931571874999E-07
      0.00000000000000E+00  -3.41909484755088E-11   0.00000000000000E+00  -7.33582734577595E-13   1.51451870905557E-23
      3.41917567075736E-08   3.41910231248390E-08  -4.32364230114452E-19  -4.22162489709839E-01  -4.22162489709706E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32976191930077E-10   0.00000000000000E+00  -1.32976191930077E-10
      1.94310226135552E-18  -2.39140973947567E-02  -1.31835117322610E-02   0.00000000000000E+00   8.69753714442242E-13
     -1.54790182733573E-23  -3.40589166866234E-08  -3.40580469329089E-08  -1.51073803124107E-18
      3.09931571874999E-07
      0.00000000000000E+00  -2.42719923913075E-11   0.00000000000000E+00  -4.89966059050693E-13   8.80426345010892E-24
      2.42725171317441E-08   2.42720271656850E-08  -4.03352162771957E-19  -4.33591372114380E-01  -4.33591372114270E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10664427633618E-10   0.00000000000000E+00  -1.10664427633618E-10
      1.83243783372190E-18  -1.57034135611779E-02  -8.09094558605730E-03   0.00000000000000E+00   5.62349811082286E-13
     -9.77940585385656E-24  -2.41619250878625E-08  -2.41613627380514E-08  -1.42908567094994E-18
      3.11281571874999E-07
      0.00000000000000E+00  -1.91557813051622E-11   0.00000000000000E+00  -1.86756625970577E-13   5.87125662988986E-24
      1.91559227594902E-08   1.91557360028643E-08  -3.65479007889115E-19  -4.48822532317682E-01  -4.48822532317581E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00890489442149E-10   0.00000000000000E+00  -1.00890489442149E-10
      1.69623567297500E-18  -1.15291921973280E-02  -5.52561869745473E-03   0.00000000000000E+00   2.38540947230714E-13
     -6.59418522767893E-24  -1.90550840543693E-08  -1.90548455134221E-08  -1.33075666508589E-18
      3.13104071874999E-07
      0.00000000000000E+00  -1.71143483312505E-11   0.00000000000000E+00  -5.49074037391353E-14   4.42576177334687E-24
      1.71143430206896E-08   1.71142881132859E-08  -3.16420251836944E-19  -4.69010015984616E-01  -4.69010015984517E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.91721129585262E-11   0.00000000000000E+00  -9.91721129585262E-11
      1.51549449710809E-18  -9.61107597201354E-03  -4.25015169987014E-03   0.00000000000000E+00   9.63751067800948E-14
     -4.93969225107617E-24  -1.70152123754341E-08  -1.70151160003273E-08  -1.19907424527114E-18
      3.15104071874999E-07
      0.00000000000000E+00  -1.64830994524232E-11   0.00000000000000E+00  -1.52302695756824E-14   3.68322538835617E-24
      1.64831335200481E-08   1.64831182897785E-08  -2.65027389645140E-19  -4.90713983825814E-01  -4.90713983825713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01074850257629E-10   0.00000000000000E+00  -1.01074850257629E-10
      1.31334479659283E-18  -8.76542757697372E-03  -3.60396059959282E-03   0.00000000000000E+00   5.04773512397335E-14
     -4.06016080606839E-24  -1.63820939168722E-08  -1.63820434395209E-08  -1.04831740694769E-18
      3.17104071874999E-07
      0.00000000000000E+00  -1.62828779253108E-11   0.00000000000000E+00  -4.63333680822157E-15   3.23923021967771E-24
      1.62828639647721E-08   1.62828593314353E-08  -2.16087346399819E-19  -5.11975867736046E-01  -5.11975867735943E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03590944350863E-10   0.00000000000000E+00  -1.03590944350863E-10
      1.10616290789110E-18  -8.31911721875534E-03  -3.22153507857729E-03   0.00000000000000E+00   3.54716791371959E-14
     -3.51061589797766E-24  -1.61793038587636E-08  -1.61792683870845E-08  -8.90075561491283E-19
      3.19104071874999E-07
      0.00000000000000E+00  -1.62031566934147E-11   0.00000000000000E+00  -1.68824296259959E-15   2.93247424285121E-24
      1.62031953595938E-08   1.62031936713509E-08  -1.69507469715304E-19  -5.32804746998013E-01  -5.32804746997907E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05713512369296E-10   0.00000000000000E+00  -1.05713512369296E-10
      8.94735883152510E-19  -8.03181124019609E-03  -2.95999528457891E-03   0.00000000000000E+00   2.91455729614071E-14
     -3.11856793602436E-24  -1.60975093045545E-08  -1.60974801589816E-08  -7.25228413437208E-19
      3.21104071874999E-07
      0.00000000000000E+00  -1.61623776300945E-11   0.00000000000000E+00  -7.54105667605980E-16   2.70369261472774E-24
      1.61624124299018E-08   1.61624116757961E-08  -1.25148842689093E-19  -5.53208786325487E-01  -5.53208786325380E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07280682238006E-10   0.00000000000000E+00  -1.07280682238006E-10
      6.80174518676498E-19  -7.82598326100436E-03  -2.76750834039706E-03   0.00000000000000E+00   2.55003091440851E-14
     -2.82181754751759E-24  -1.60551564938672E-08  -1.60551309935581E-08  -5.55025675987405E-19
      3.23104071874999E-07
      0.00000000000000E+00  -1.61374877063113E-11   0.00000000000000E+00  -3.83695366154280E-16   2.52530622497404E-24
      1.61374985867808E-08   1.61374982030854E-08  -8.28549044756319E-20  -5.73192188774595E-01  -5.73192188774487E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08282787769612E-10   0.00000000000000E+00  -1.08282787769612E-10
      4.63608943137274E-19  -7.66969060563763E-03  -2.61937903802487E-03   0.00000000000000E+00   2.29158369097129E-14
     -2.58927983397730E-24  -1.60292383311527E-08  -1.60292154153158E-08  -3.80754038661642E-19
      3.25104071874999E-07
      0.00000000000000E+00  -1.61204964299279E-11   0.00000000000000E+00  -2.06377761665691E-16   2.38202573770283E-24
      1.61205084462704E-08   1.61205082398926E-08  -4.25343441240389E-20  -5.92723967692895E-01  -5.92723967692786E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08580682737813E-10   0.00000000000000E+00  -1.08580682737813E-10
      2.46447577661648E-19  -7.54626775816422E-03  -2.50140141297970E-03   0.00000000000000E+00   2.08677032343152E-14
     -2.40255550452362E-24  -1.60119484248580E-08  -1.60119275571548E-08  -2.03913233537608E-19
      3.27104071874999E-07
      0.00000000000000E+00  -1.61065360298723E-11   0.00000000000000E+00  -3.57631532892104E-15   2.26534304317397E-24
      1.61065243299495E-08   1.61065207536341E-08  -4.59797593738222E-21  -6.11521890045771E-01  -6.11521890045664E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06789141935140E-10   0.00000000000000E+00  -1.06789141935140E-10
      3.28692937913669E-20  -7.44587426104400E-03  -2.40484807583111E-03   0.00000000000000E+00   2.23315523508822E-14
     -2.25124692020425E-24  -1.59997539432513E-08  -1.59997316116990E-08  -2.82713178539855E-20
      3.29104071874999E-07
      0.00000000000000E+00  -1.60789826087101E-11   0.00000000000000E+00  -5.05600687842023E-16   2.18265383354006E-24
      1.60789830585994E-08   1.60789825529987E-08   3.01070167485674E-20  -6.29056017890423E-01  -6.29056017890321E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01338671295146E-10   0.00000000000000E+00  -1.01338671295146E-10
     -1.69808048798926E-19  -7.38786285370045E-03  -2.35379582798223E-03   0.00000000000000E+00   1.70400422852600E-14
     -2.14624511773651E-24  -1.59776609217459E-08  -1.59776438817036E-08   1.39701032050358E-19
      3.31104071874999E-07
      0.00000000000000E+00  -1.60582256981012E-11   0.00000000000000E+00  -3.64378152072589E-16   2.11879359534090E-24
      1.60582418136180E-08   1.60582414492398E-08   6.01145612474349E-20  -6.44473579396990E-01  -6.44473579396900E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.04011486325736E-11   0.00000000000000E+00  -9.04011486325736E-11
     -3.50610346064073E-19  -7.34786713370740E-03  -2.31688800086984E-03   0.00000000000000E+00   1.41881722111084E-14
     -2.06605016645735E-24  -1.59678544887795E-08  -1.59678403006073E-08   2.90495784816639E-19
      3.33104071874999E-07
      0.00000000000000E+00  -1.60327847058947E-11   0.00000000000000E+00  -5.17736548067024E-16   2.07173442103282E-24
      1.60327481084292E-08   1.60327475906927E-08   8.30951036612752E-20  -6.56435653643885E-01  -6.56435653643814E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.09140958075406E-11   0.00000000000000E+00  -7.09140958075406E-11
     -4.92438537679154E-19  -7.31841339133731E-03  -2.28932613219535E-03   0.00000000000000E+00   1.06508587685794E-14
     -2.00857002714495E-24  -1.59618441457439E-08  -1.59618334948852E-08   4.09343434017877E-19
      3.35104071874999E-07
      0.00000000000000E+00  -1.59955875873257E-11   0.00000000000000E+00  -8.56230947415859E-16   2.04394158252826E-24
      1.59955963585737E-08   1.59955955023428E-08   9.58397030754269E-20  -6.63124564261283E-01  -6.63124564261243E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99380899908312E-11   0.00000000000000E+00  -3.99380899908312E-11
     -5.72314717660816E-19  -7.29965374676514E-03  -2.27251200362155E-03   0.00000000000000E+00   5.91554003026015E-15
     -1.97750524032021E-24  -1.59556633278920E-08  -1.59556574123519E-08   4.76475014585389E-19
      3.36104071874999E-07
      0.00000000000000E+00  -1.59710650424912E-11   0.00000000000000E+00  -1.17972664563675E-15   2.03562040016563E-24
      1.59710599279888E-08   1.59710587482621E-08   9.88262424684069E-20  -6.64696822201857E-01  -6.64696822201838E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.88451714603353E-11   0.00000000000000E+00  -1.88451714603353E-11
     -5.91159889121152E-19  -7.29323188166823E-03  -2.26717509683014E-03   0.00000000000000E+00   2.85654542148562E-15
     -1.96995750548912E-24  -1.59522164333472E-08  -1.59522135768018E-08   4.92333646652745E-19
      3.37454071874999E-07
      0.00000000000000E+00  -1.59316636502292E-11   0.00000000000000E+00  -1.30753838440072E-15   2.03648210554705E-24
      1.59317076602790E-08   1.59317063527406E-08   9.56116578088221E-20  -6.63000889019882E-01  -6.63000889019898E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50098214123619E-11   0.00000000000000E+00   1.50098214123619E-11
     -5.70896630214463E-19  -7.29111320202864E-03  -2.26678861730104E-03   0.00000000000000E+00  -2.09390254532744E-15
     -1.97635383553208E-24  -1.59467140802505E-08  -1.59467161741530E-08   4.75284972405642E-19
      3.39276571874999E-07
      0.00000000000000E+00  -1.58667294210235E-11   0.00000000000000E+00  -1.41482781464081E-15   2.06569083696332E-24
      1.58667063846539E-08   1.58667049698260E-08   7.50070773372895E-20  -6.52200683546349E-01  -6.52200683546420E-01
      0.00000000000000E+00   0.00000000000000E+00   7.05888449683250E-11   0.00000000000000E+00   7.05888449683250E-11
     -4.42248460259691E-19  -7.30364504534571E-03  -2.28228984964093E-03   0.00000000000000E+00  -1.04434211660271E-14
     -2.02403812274421E-24  -1.59372833713732E-08  -1.59372938147944E-08   3.67241382922402E-19
      3.41276571874999E-07
      0.00000000000000E+00  -1.57765378890857E-11   0.00000000000000E+00  -9.36220339212472E-16   2.14761228684363E-24
      1.57765332860687E-08   1.57765323498483E-08   2.68330820790458E-20  -6.27371044772187E-01  -6.27371044772333E-01
      0.00000000000000E+00   0.00000000000000E+00   1.45882061649003E-10   0.00000000000000E+00   1.45882061649003E-10
     -1.50484336961684E-19  -7.34452667918775E-03  -2.32786130840709E-03   0.00000000000000E+00  -2.34592964079796E-14
     -2.14868877841306E-24  -1.59223909522009E-08  -1.59224144114974E-08   1.23651254882638E-19
      3.43276571874999E-07
      0.00000000000000E+00  -1.56352806832605E-11   0.00000000000000E+00  -1.97659038748754E-16   2.34568526201617E-24
      1.56353500105928E-08   1.56353498129338E-08  -5.60600784748144E-20  -5.86092926448670E-01  -5.86092926448905E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35375754636671E-10   0.00000000000000E+00   2.35375754636671E-10
      3.20267172311657E-19  -7.48402798958948E-03  -2.48365168464682E-03   0.00000000000000E+00  -4.27580154195288E-14
     -2.45224936048757E-24  -1.58706828095550E-08  -1.58707255675705E-08  -2.64207093836843E-19
      3.45276571874999E-07
      0.00000000000000E+00  -1.54041074797092E-11   0.00000000000000E+00  -6.46794804954392E-15   2.83148558029259E-24
      1.54040716848345E-08   1.54040652168865E-08  -1.87568232932378E-19  -5.24614323223487E-01  -5.24614323223816E-01
      0.00000000000000E+00   0.00000000000000E+00   3.28858535082194E-10   0.00000000000000E+00   3.28858535082194E-10
      9.77984242476044E-19  -7.88857463574164E-03  -2.93161992147965E-03   0.00000000000000E+00  -6.72123765267879E-14
     -3.27129770591994E-24  -1.57328565395922E-08  -1.57329237519687E-08  -7.90416009543666E-19
      3.47276571874999E-07
      0.00000000000000E+00  -1.47706543271889E-11   0.00000000000000E+00  -1.71354662010325E-14   4.19401665865083E-24
      1.47707350038356E-08   1.47707178683694E-08  -3.86327398996106E-19  -4.40139890858054E-01  -4.40139890858447E-01
      0.00000000000000E+00   0.00000000000000E+00   3.92984586190185E-10   0.00000000000000E+00   3.92984586190185E-10
      1.76395341485641E-18  -9.39605333800329E-03  -4.61845589999658E-03   0.00000000000000E+00  -1.19731793554785E-13
     -6.75310192109103E-24  -1.51635827227660E-08  -1.51637024545596E-08  -1.37762601586031E-18
      3.49276571874999E-07
      0.00000000000000E+00  -1.04377870046866E-11   0.00000000000000E+00  -2.37336222518209E-13   4.49000214080699E-24
      1.04378771781938E-08   1.04376398419713E-08  -6.48373257506907E-19  -3.32421572974954E-01  -3.32421572975354E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00135769355365E-10   0.00000000000000E+00   4.00135769355365E-10
      2.56422495356714E-18  -1.93246081562046E-02  -1.59099552717260E-02   0.00000000000000E+00  -8.08978740323521E-14
     -3.78447672958741E-23  -1.08376947134526E-08  -1.08377756113267E-08  -1.91585169606024E-18
      3.51276571874999E-07
      0.00000000000000E+00  -1.27287621295911E-12   0.00000000000000E+00  -2.32360663227564E-13  -3.27585446456821E-23
      1.27310863220540E-09   1.27287627154214E-09  -9.14384066252745E-19  -2.08251762304715E-01  -2.08251762305122E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06327969946226E-10   0.00000000000000E+00   4.06327969946226E-10
      3.37688089345960E-18  -4.69459217544898E-02  -4.64168684221935E-02   0.00000000000000E+00  -5.05985355565313E-13
     -8.39982899063754E-23  -1.67869825613271E-09  -1.67920424148836E-09  -2.46249682720685E-18
      3.53276571874999E-07
      0.00000000000000E+00   6.19033528778730E-14   0.00000000000000E+00  -4.03974894340114E-14  -4.49390191883313E-23
     -6.18516498919047E-11  -6.18920473813837E-11  -1.15376778997602E-18  -9.06356765618452E-02  -9.06356765621916E-02
      0.00000000000000E+00   0.00000000000000E+00   3.46424596835817E-10   0.00000000000000E+00   3.46424596835817E-10
      4.06973008713123E-18  -7.67349417025584E-02  -7.66452967745552E-02   0.00000000000000E+00  -1.19930334254679E-12
     -9.64181745917725E-23  -2.83333246111790E-10  -2.84532549454433E-10  -2.91596229715522E-18
      3.55276571874999E-07
      0.00000000000000E+00   5.74029607547042E-14   0.00000000000000E+00  -4.05463677255891E-15  -4.62327762409680E-23
     -5.73748306293884E-11  -5.73788852662072E-11  -1.26779781615148E-18  -3.38598832521399E-02  -3.38598832523386E-02
      0.00000000000000E+00   0.00000000000000E+00   1.98652247895821E-10   0.00000000000000E+00   1.98652247895821E-10
      4.46703458292287E-18  -1.06201327826150E-01  -1.06156818384490E-01   0.00000000000000E+00  -9.77130386425456E-13
     -1.03820189560867E-22  -1.40296232243085E-10  -1.41273362629614E-10  -3.19923676677139E-18
      3.57276571874999E-07
      0.00000000000000E+00   1.54299158508645E-14   0.00000000000000E+00   3.60126164510364E-16  -4.63884352492795E-23
     -1.54400862100134E-11  -1.54397260838953E-11  -1.30640590540173E-18  -1.60104945782290E-02  -1.60104945783383E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09340109186074E-10   0.00000000000000E+00   1.09340109186074E-10
      4.68571480129502E-18  -1.35158558913276E-01  -1.35128975094649E-01   0.00000000000000E+00  -5.64791506072406E-13
     -1.07350271859042E-22  -9.33355915959983E-11  -9.39003831021781E-11  -3.37930889589330E-18
      3.59276571874999E-07
      0.00000000000000E+00  -8.35787108588493E-15   0.00000000000000E+00   9.42654229994018E-16  -4.61154638567245E-23
      8.35127104640218E-12   8.35221370058606E-12  -1.31814727948921E-18  -1.08468297718175E-02  -1.08468297718890E-02
      0.00000000000000E+00   0.00000000000000E+00   7.15282701218666E-11   0.00000000000000E+00   7.15282701218666E-11
      4.82877134153875E-18  -1.63545665280679E-01  -1.63520498751410E-01   0.00000000000000E+00  -4.28936743465185E-13
     -1.09825056600846E-22  -7.94515470788779E-11  -7.98804838224529E-11  -3.51062406204954E-18
      3.61276571874999E-07
      0.00000000000000E+00  -2.38796316739570E-14   0.00000000000000E+00   8.27246459300313E-16  -4.53441782802530E-23
      2.38395118223585E-11   2.38403390687724E-11  -1.32053208589922E-18  -9.20473218576733E-03  -9.20473218582098E-03
      0.00000000000000E+00   0.00000000000000E+00   5.36499267478634E-11   0.00000000000000E+00   5.36499267478634E-11
      4.93607119503448E-18  -1.91349664469031E-01  -1.91325251170354E-01   0.00000000000000E+00  -4.14986851187449E-13
     -1.12110486487574E-22  -7.70752789653361E-11  -7.74902658166356E-11  -3.61553910913527E-18
      3.63276571874999E-07
      0.00000000000000E+00  -3.57276027737279E-14   0.00000000000000E+00   6.55478910000059E-16  -4.36658048771699E-23
      3.57303480568098E-11   3.57310035356761E-11  -1.31938265152760E-18  -8.53283783562761E-03  -8.53283783567112E-03
      0.00000000000000E+00   0.00000000000000E+00   4.35146831994642E-11   0.00000000000000E+00   4.35146831994642E-11
      5.02310056143341E-18  -2.18577974034281E-01  -2.18553007883385E-01   0.00000000000000E+00  -4.31369745881458E-13
     -1.14402313560471E-22  -7.88143169891444E-11  -7.92456867351402E-11  -3.70371790990581E-18
      3.65276571874999E-07
      0.00000000000000E+00  -4.57386791293483E-14   0.00000000000000E+00   5.07864566211118E-16  -4.05225885083408E-23
      4.57691765757476E-11   4.57696844402733E-11  -1.31682980127050E-18  -8.16539826005159E-03  -8.16539826008859E-03
      0.00000000000000E+00   0.00000000000000E+00   3.69920440186400E-11   0.00000000000000E+00   3.69920440186400E-11
      5.09708464947069E-18  -2.45245043654419E-01  -2.45218969991471E-01   0.00000000000000E+00  -4.51369221842099E-13
     -1.16727950125401E-22  -8.23103592369543E-11  -8.27617284589131E-11  -3.78025484820019E-18
      3.67276571874999E-07
      0.00000000000000E+00  -5.47394633756859E-14   0.00000000000000E+00   4.17012278794393E-16  -3.52987243627334E-23
      5.47035277546044E-11   5.47039447668479E-11  -1.31377005692873E-18  -7.92140708296957E-03  -7.92140708300207E-03
      0.00000000000000E+00   0.00000000000000E+00   3.24964348900681E-11   0.00000000000000E+00   3.24964348900681E-11
      5.16207751925083E-18  -2.71364765112516E-01  -2.71337293311082E-01   0.00000000000000E+00  -4.69836770461308E-13
     -1.19082996476060E-22  -8.67305428863351E-11  -8.72003796569155E-11  -3.84830746232209E-18
      3.69276571874999E-07
      0.00000000000000E+00  -6.29136449871558E-14   0.00000000000000E+00   3.52227940639518E-16  -2.74076502552913E-23
      6.29141928756745E-11   6.29145451035877E-11  -1.31061328765085E-18  -7.74254415328778E-03  -7.74254415331703E-03
      0.00000000000000E+00   0.00000000000000E+00   2.92571396627812E-11   0.00000000000000E+00   2.92571396627812E-11
      5.22059179857639E-18  -2.96945615342293E-01  -2.96916577626543E-01   0.00000000000000E+00  -4.87013292311072E-13
     -1.21462526121770E-22  -9.16846714739369E-11  -9.21716847663694E-11  -3.90997851092554E-18
      3.71276571874999E-07
      0.00000000000000E+00  -7.06286029125881E-14   0.00000000000000E+00   3.11150639089959E-16  -1.64417253273291E-23
      7.06361580038451E-11   7.06364691544677E-11  -1.30754595852371E-18  -7.60420769181405E-03  -7.60420769184088E-03
      0.00000000000000E+00   0.00000000000000E+00   2.68242383568580E-11   0.00000000000000E+00   2.68242383568580E-11
      5.27424027529010E-18  -3.21990888031542E-01  -3.21960184342735E-01   0.00000000000000E+00  -5.04204813244182E-13
     -1.23866511203287E-22  -9.69565026979575E-11  -9.74607075113255E-11  -3.96669431676640E-18
      3.73276571874999E-07
      0.00000000000000E+00  -7.80680266263977E-14   0.00000000000000E+00   2.83785291938067E-16  -2.37353496457321E-24
      7.80304726417464E-11   7.80307564270359E-11  -1.30464375860757E-18  -7.49331640857716E-03  -7.49331640860207E-03
      0.00000000000000E+00   0.00000000000000E+00   2.49185886969879E-11   0.00000000000000E+00   2.49185886969879E-11
      5.32407745268408E-18  -3.46509037317870E-01  -3.46476604804614E-01   0.00000000000000E+00  -5.22885729023642E-13
     -1.26300668860488E-22  -1.02426459394874E-10  -1.02949345124024E-10  -4.01943369407651E-18
      3.75276571874999E-07
      0.00000000000000E+00  -8.52319161285848E-14   0.00000000000000E+00   2.66927733520060E-16   1.39192796260134E-23
      8.52386168587499E-11   8.52388837864974E-11  -1.30190535326382E-18  -7.41326822963985E-03  -7.41326822966317E-03
      0.00000000000000E+00   0.00000000000000E+00   2.33239604052663E-11   0.00000000000000E+00   2.33239604052663E-11
      5.37072537349461E-18  -3.70494799273655E-01  -3.70460598637781E-01   0.00000000000000E+00  -5.43366419295550E-13
     -1.28770543773968E-22  -1.08019477772340E-10  -1.08562844191764E-10  -4.06882002023080E-18
      3.77276571874999E-07
      0.00000000000000E+00  -9.23039608935644E-14   0.00000000000000E+00   2.56735699625312E-16   3.09253782494341E-23
      9.23494477548806E-11   9.23497044906112E-11  -1.29930952433311E-18  -7.36612724860249E-03  -7.36612724862444E-03
      0.00000000000000E+00   0.00000000000000E+00   2.19479624358063E-11   0.00000000000000E+00   2.19479624358063E-11
      5.41462129836623E-18  -3.93971942021545E-01  -3.93935935082489E-01   0.00000000000000E+00  -5.67248679866319E-13
     -1.31286898635176E-22  -1.13730418246420E-10  -1.14297666926418E-10  -4.11531177403311E-18
      3.79276571874999E-07
      0.00000000000000E+00  -9.93760056585439E-14   0.00000000000000E+00   2.47919851392281E-16   4.76769341246007E-23
      9.93778829499344E-11   9.93781308698335E-11  -1.29686707219295E-18  -7.33144304242766E-03  -7.33144304244852E-03
      0.00000000000000E+00   0.00000000000000E+00   2.08552073833863E-11   0.00000000000000E+00   2.08552073833863E-11
      5.45633171313299E-18  -4.17098286281478E-01  -4.17060409808339E-01   0.00000000000000E+00  -6.00260851129673E-13
     -1.33882224905526E-22  -1.19633077401956E-10  -1.20233338253219E-10  -4.15946464094004E-18
      3.81276571874999E-07
      0.00000000000000E+00  -1.06356205686316E-13   0.00000000000000E+00   2.40950584225903E-16   6.33163772005424E-23
      1.06343100902765E-10   1.06343341853413E-10  -1.29456656994645E-18  -7.30691493202317E-03  -7.30691493204300E-03
      0.00000000000000E+00   0.00000000000000E+00   1.98243912124743E-11   0.00000000000000E+00   1.98243912124743E-11
      5.49598049555794E-18  -4.39833562614311E-01  -4.39793817062738E-01   0.00000000000000E+00  -6.35672930147298E-13
     -1.36554628931897E-22  -1.25532060135602E-10  -1.26167733065886E-10  -4.20141392561150E-18
      3.82276571874999E-07
      0.00000000000000E+00  -1.09846305700202E-13   0.00000000000000E+00   2.38971977991660E-16   7.09319168244016E-23
      1.09839157935720E-10   1.09839396907769E-10  -1.29345187295503E-18  -7.29735576279228E-03  -7.29735576281155E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92627985940434E-11   0.00000000000000E+00   1.92627985940434E-11
      5.51524329415199E-18  -4.51091741397631E-01  -4.51051071635759E-01   0.00000000000000E+00  -6.62960201023376E-13
     -1.37915967111900E-22  -1.28439235300652E-10  -1.29102195501814E-10  -4.22179142119696E-18
      3.83626571874999E-07
      0.00000000000000E+00  -1.14530387297786E-13   0.00000000000000E+00   2.34597018485462E-16   8.01698890018198E-23
      1.14512622985911E-10   1.14512857583009E-10  -1.29200253677578E-18  -7.29013633607035E-03  -7.29013633608893E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85808849267721E-11   0.00000000000000E+00   1.85808849267721E-11
      5.54032748880313E-18  -4.66085304789288E-01  -4.66043377917773E-01   0.00000000000000E+00  -6.86138382672309E-13
     -1.39781727378441E-22  -1.32407604126970E-10  -1.33093742509782E-10  -4.24832495202735E-18
      3.85449071874999E-07
      0.00000000000000E+00  -1.20775829427898E-13   0.00000000000000E+00   2.30097439137685E-16   9.07649927535911E-23
      1.20756909817948E-10   1.20757139915478E-10  -1.29012884533647E-18  -7.29322760742545E-03  -7.29322760744316E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77095763649187E-11   0.00000000000000E+00   1.77095763649187E-11
      5.57260319172819E-18  -4.85952883806771E-01  -4.85909264801377E-01   0.00000000000000E+00  -7.17935007905850E-13
     -1.42342233753981E-22  -1.37748781272348E-10  -1.38466716280396E-10  -4.28247434639172E-18
      3.87449071874999E-07
      0.00000000000000E+00  -1.27572339981255E-13   0.00000000000000E+00   2.27500213431203E-16   1.00381366682059E-22
      1.27584681081275E-10   1.27584908581589E-10  -1.28814577584823E-18  -7.31814587588747E-03  -7.31814587590425E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67837349717316E-11   0.00000000000000E+00   1.67837349717316E-11
      5.60617066167166E-18  -5.07311810687051E-01  -5.07266333022910E-01   0.00000000000000E+00  -7.56578046628963E-13
     -1.45190921090919E-22  -1.43612065506547E-10  -1.44368643553321E-10  -4.31802488582343E-18
      3.89449071874999E-07
      0.00000000000000E+00  -1.34460695271819E-13   0.00000000000000E+00   2.29302289044490E-16   1.08282836310785E-22
      1.34486154566286E-10   1.34486383868684E-10  -1.28618498714328E-18  -7.38227204660160E-03  -7.38227204661747E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58716629631978E-11   0.00000000000000E+00   1.58716629631978E-11
      5.63791398759805E-18  -5.28235799765621E-01  -5.28188435956018E-01   0.00000000000000E+00  -7.96350509652328E-13
     -1.48058146773041E-22  -1.49561696322080E-10  -1.50358046831880E-10  -4.35172900045478E-18
      3.91449071874999E-07
      0.00000000000000E+00  -1.42175653197251E-13   0.00000000000000E+00   2.60716458438954E-16   1.15167871957367E-22
      1.42143831070724E-10   1.42144091787298E-10  -1.28394608725410E-18  -7.61898627960731E-03  -7.61898627962209E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47784191341762E-11   0.00000000000000E+00   1.47784191341762E-11
      5.66747082586641E-18  -5.48733321253060E-01  -5.48683890230892E-01   0.00000000000000E+00  -8.28753725260820E-13
     -1.50901920090022E-22  -1.56093757196063E-10  -1.56922510921475E-10  -4.38352473861230E-18
      3.93449071874999E-07
      0.00000000000000E+00  -1.52094884815664E-13   0.00000000000000E+00   4.91595104383294E-16   1.22173256730844E-22
      1.52072324499485E-10   1.52072816094711E-10  -1.28077102392755E-18  -8.31852986110842E-03  -8.31852986112164E-03
      0.00000000000000E+00   0.00000000000000E+00   1.32165541652609E-11   0.00000000000000E+00   1.32165541652609E-11
      5.69390393419693E-18  -5.68810312027676E-01  -5.68758246175428E-01   0.00000000000000E+00  -8.43871805987503E-13
     -1.53657278450280E-22  -1.64445498453831E-10  -1.65289370259972E-10  -4.41313291026938E-18
      3.95449071874999E-07
      0.00000000000000E+00  -1.77627721759357E-13   0.00000000000000E+00   9.58808056885951E-16   1.37024927253732E-22
      1.77613184033881E-10   1.77614142842075E-10  -1.27166710649340E-18  -1.17587533704425E-02  -1.17587533704501E-02
      0.00000000000000E+00   0.00000000000000E+00   7.60785571855377E-12   0.00000000000000E+00   7.60785571855377E-12
      5.70911964563404E-18  -5.88453551760023E-01  -5.88395208022474E-01   0.00000000000000E+00  -7.38169806809072E-13
     -1.55959462038729E-22  -1.84483828753663E-10  -1.85221998560628E-10  -4.43745253914064E-18
      3.97449071874999E-07
      0.00000000000000E+00  -3.37896788186491E-13   0.00000000000000E+00   4.64297617651146E-15   2.10698789188021E-22
      3.37902017864205E-10   3.37906660840592E-10  -1.22519478068394E-18  -3.18321053031680E-02  -3.18321053031439E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.40788535104971E-11   0.00000000000000E+00  -2.40788535104971E-11
      5.66096193861305E-18  -6.07461657079255E-01  -6.07362804535652E-01   0.00000000000000E+00   8.36225650300571E-14
     -1.55701545452407E-22  -3.13911429894971E-10  -3.13827807330096E-10  -4.43576715792910E-18
      3.99449071874999E-07
      0.00000000000000E+00  -7.43391302957722E-13   0.00000000000000E+00   1.21513879266555E-14   2.99732710260009E-22
      7.43386882523612E-10   7.43399033911838E-10  -1.15319673772633E-18  -6.12989345138164E-02  -6.12989345137683E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.81239107170320E-11   0.00000000000000E+00  -4.81239107170320E-11
      5.56471411717898E-18  -6.25357802954209E-01  -6.25138797887371E-01   0.00000000000000E+00   5.07323521372327E-13
     -1.54112936172283E-22  -6.95782446716023E-10  -6.95275123194805E-10  -4.41151737945264E-18
      4.01449071874999E-07
      0.00000000000000E+00  -1.53656245348192E-12   0.00000000000000E+00   2.13704736925731E-14   3.54482282232227E-22
      1.53651485101032E-09   1.53653622148437E-09  -1.07905850059443E-18  -9.09675843880971E-02  -9.09675843880389E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.81729082668650E-11   0.00000000000000E+00  -5.81729082668650E-11
      5.44836830064525E-18  -6.41385933081508E-01  -6.40920258667407E-01   0.00000000000000E+00   4.55572681889566E-13
     -1.52631734434946E-22  -1.47881888589924E-09  -1.47836331321751E-09  -4.36930980005082E-18
      4.03449071874999E-07
      0.00000000000000E+00  -2.97604501973549E-12   0.00000000000000E+00   3.70449165218005E-14   3.92830260671551E-22
      2.97599476515760E-09   2.97603181007452E-09  -1.00952123801096E-18  -1.20199817490339E-01  -1.20199817490270E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.90642822503896E-11   0.00000000000000E+00  -6.90642822503896E-11
      5.31023973614447E-18  -6.54332167170449E-01  -6.53416486035383E-01   0.00000000000000E+00   3.65272189381922E-13
     -1.51383967825953E-22  -2.90733280001336E-09  -2.90696752782413E-09  -4.30071849813351E-18
      4.05449071874999E-07
      0.00000000000000E+00  -5.33305651069225E-12   0.00000000000000E+00   5.94633486727556E-14   4.23563087610152E-22
      5.33297350403349E-09   5.33303296738259E-09  -9.47195088461134E-19  -1.48886052481806E-01  -1.48886052481723E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.29398418534654E-11   0.00000000000000E+00  -8.29398418534654E-11
      5.14436005243754E-18  -6.62485029032146E-01  -6.60831265496394E-01   0.00000000000000E+00   2.70678400109601E-13
     -1.50392818219714E-22  -5.25036380392908E-09  -5.25009312552912E-09  -4.19716496397640E-18
      4.07449071874999E-07
      0.00000000000000E+00  -8.81819690876906E-12   0.00000000000000E+00   8.71223273393542E-14   4.45322586649125E-22
      8.81811035462469E-09   8.81819747695247E-09  -8.91677669488241E-19  -1.76992506541702E-01  -1.76992506541603E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.88547874021363E-11   0.00000000000000E+00  -9.88547874021363E-11
      4.94665047763326E-18  -6.63755971782463E-01  -6.61009390544073E-01   0.00000000000000E+00   2.41153126318828E-13
     -1.49444897158283E-22  -8.71958384267650E-09  -8.71934268955034E-09  -4.05497280814502E-18
      4.09449071874999E-07
      0.00000000000000E+00  -1.35917352803931E-11   0.00000000000000E+00   1.18797806579289E-13   4.55543371435857E-22
      1.35916171471809E-08   1.35917359449880E-08  -8.41094523414343E-19  -2.04517991423739E-01  -2.04517991423624E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14042275480011E-10   0.00000000000000E+00  -1.14042275480011E-10
      4.71856592667324E-18  -6.55780120670085E-01  -6.51534631597915E-01   0.00000000000000E+00   3.84997661836881E-13
     -1.47931885409886E-22  -1.34780786671696E-08  -1.34776936695080E-08  -3.87747140325890E-18
      4.11449071874999E-07
      0.00000000000000E+00  -1.98599549053323E-11   0.00000000000000E+00   1.55656911019822E-13   4.53563925987512E-22
      1.98598254092916E-08   1.98599810662031E-08  -7.93453052984834E-19  -2.31474437616788E-01  -2.31474437616662E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26248944636563E-10   0.00000000000000E+00  -1.26248944636563E-10
      4.46606803740012E-18  -6.35831566406700E-01  -6.29615328065064E-01   0.00000000000000E+00   7.75772391583638E-13
     -1.44892789747083E-22  -1.97345078939580E-08  -1.97337321215666E-08  -3.67261498441529E-18
      4.13449071874999E-07
      0.00000000000000E+00  -2.79242902111020E-11   0.00000000000000E+00   2.00086083311232E-13   4.40005663423159E-22
      2.79240654012133E-08   2.79242654872970E-08  -7.47248685246245E-19  -2.57876742010757E-01  -2.57876742010622E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35273493474401E-10   0.00000000000000E+00  -1.35273493474401E-10
      4.19552105045132E-18  -6.00646426664605E-01  -5.91892521105197E-01   0.00000000000000E+00   1.36395253722826E-12
     -1.39264573187327E-22  -2.77903559463597E-08  -2.77889919938226E-08  -3.44827236520507E-18
      4.15449071874999E-07
      0.00000000000000E+00  -3.80474171461156E-11   0.00000000000000E+00   2.51200915324411E-13   4.13928021724149E-22
      3.80471870268899E-08   3.80474382278057E-08  -7.01622631776396E-19  -2.83736663937705E-01  -2.83736663937562E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43135098148711E-10   0.00000000000000E+00  -1.43135098148711E-10
      3.90925085415389E-18  -5.46502022806617E-01  -5.34561243598609E-01   0.00000000000000E+00   1.92283573353713E-12
     -1.30432997328170E-22  -3.79062259653904E-08  -3.79043031296570E-08  -3.20762822237750E-18
      4.17449071874999E-07
      0.00000000000000E+00  -5.00246137911376E-11   0.00000000000000E+00   2.97497255068770E-13   3.65629433451929E-22
      5.00243582848270E-08   5.00246557820824E-08  -6.56399869790676E-19  -3.09059402956217E-01  -3.09059402956063E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53354463887754E-10   0.00000000000000E+00  -1.53354463887754E-10
      3.60254192637839E-18  -4.70109543879599E-01  -4.54398250862792E-01   0.00000000000000E+00   2.12183757020049E-12
     -1.19312979803920E-22  -4.98734231557648E-08  -4.98713013181947E-08  -2.94614205658771E-18
      4.19449071874999E-07
      0.00000000000000E+00  -6.28357606500038E-11   0.00000000000000E+00   3.18736412375230E-13   2.90413490126950E-22
      6.28354271290935E-08   6.28357458655061E-08  -6.11688860283802E-19  -3.33849873804815E-01  -3.33849873804649E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66186603632038E-10   0.00000000000000E+00  -1.66186603632038E-10
      3.27016871911431E-18  -3.70163929884110E-01  -3.50419982742774E-01   0.00000000000000E+00   1.94048266458544E-12
     -1.07333232125292E-22  -6.26714997445386E-08  -6.26695592618741E-08  -2.65847985883051E-18
      4.21449071874999E-07
      0.00000000000000E+00  -7.40587283130776E-11   0.00000000000000E+00   2.79508869248929E-13   2.26746267331321E-22
      7.40584922287020E-08   7.40587717375715E-08  -5.67583695292719E-19  -3.58114558544423E-01  -3.58114558544242E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.80879825955719E-10   0.00000000000000E+00  -1.80879825955719E-10
      2.90840906720287E-18  -2.50220955484543E-01  -2.26945098138502E-01   0.00000000000000E+00   1.53090289879569E-12
     -9.31929467572120E-23  -7.38794228145145E-08  -7.38778919116158E-08  -2.34082537191015E-18
      4.23449071874999E-07
      0.00000000000000E+00  -7.78510893571136E-11   0.00000000000000E+00   9.49751346168027E-14   1.28370182542486E-22
      7.78510071414748E-08   7.78511021166096E-08  -5.24718889969470E-19  -3.81841566350040E-01  -3.81841566349833E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.06783685095414E-10   0.00000000000000E+00  -2.06783685095414E-10
      2.49484169701204E-18  -1.25182099998119E-01  -1.00719124694734E-01   0.00000000000000E+00   9.16674074273566E-13
     -7.85896539362383E-23  -7.76452351055885E-08  -7.76443184315143E-08  -1.97012280704257E-18
      4.25449071874999E-07
      0.00000000000000E+00  -5.52192602828581E-11   0.00000000000000E+00  -5.62455618049504E-13   3.65017180380144E-23
      5.52197754713249E-08   5.52192130157069E-08  -4.75092275472442E-19  -4.05139454772838E-01  -4.05139454772656E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82523621965674E-10   0.00000000000000E+00  -1.82523621965674E-10
      2.12979445308070E-18  -4.66688925797216E-02  -2.93286511432513E-02   0.00000000000000E+00   9.17412085849774E-13
     -3.38588172625235E-23  -5.50376068058271E-08  -5.50366893937413E-08  -1.65470217760825E-18
      4.26449071874999E-07
      0.00000000000000E+00  -3.62846411048916E-11   0.00000000000000E+00  -9.38070694795815E-13   1.72619845222424E-23
      3.62855637794726E-08   3.62846257087778E-08  -4.45934426253637E-19  -4.16714127374163E-01  -4.16714127374025E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.38070046528125E-10   0.00000000000000E+00  -1.38070046528125E-10
      1.99172440655257E-18  -2.64225895194154E-02  -1.50339869638103E-02   0.00000000000000E+00   1.07478360151910E-12
     -1.80304797109208E-23  -3.61476304458512E-08  -3.61465556622497E-08  -1.54578998029893E-18
      4.27799071874999E-07
      0.00000000000000E+00  -2.40342063666772E-11   0.00000000000000E+00  -4.48267155283580E-13   8.88055780619221E-24
      2.40347074278106E-08   2.40342591606554E-08  -4.06845124286321E-19  -4.32164526030967E-01  -4.32164526030857E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09465031421595E-10   0.00000000000000E+00  -1.09465031421595E-10
      1.84394661413342E-18  -1.56580283177374E-02  -8.12009597286492E-03   0.00000000000000E+00   5.22682445065449E-13
     -9.78557025030929E-24  -2.39253168116788E-08  -2.39247941292338E-08  -1.43710148984709E-18
      4.29621571874999E-07
      0.00000000000000E+00  -1.86020493845381E-11   0.00000000000000E+00  -1.46778256229554E-13   5.74503336935012E-24
      1.86022440496317E-08   1.86020972713755E-08  -3.56073139675834E-19  -4.52657149892173E-01  -4.52657149892074E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96449861838153E-11   0.00000000000000E+00  -9.96449861838153E-11
      1.66234362681341E-18  -1.10302673295150E-02  -5.20073430980685E-03   0.00000000000000E+00   1.96825723630516E-13
     -5.69293028723441E-24  -1.85026491109153E-08  -1.85024522851916E-08  -1.30627048713758E-18
      4.31621571874999E-07
      0.00000000000000E+00  -1.69045749514685E-11   0.00000000000000E+00  -4.15202237404921E-14   4.19664428007739E-24
      1.69046215160529E-08   1.69045799958292E-08  -3.02828874947912E-19  -4.74693564847642E-01  -4.74693564847543E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94252286880482E-11   0.00000000000000E+00  -9.94252286880482E-11
      1.46349316943732E-18  -9.34355458798297E-03  -4.04878136635130E-03   0.00000000000000E+00   8.13075506203291E-14
     -4.66553071006701E-24  -1.68052360746917E-08  -1.68051547671411E-08  -1.16066429448940E-18
      4.33621571874999E-07
      0.00000000000000E+00  -1.64169712416338E-11   0.00000000000000E+00  -1.16985475619972E-14   3.55041825680474E-24
      1.64169768714767E-08   1.64169651729292E-08  -2.52076267487767E-19  -4.96281781442369E-01  -4.96281781442267E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01759594646945E-10   0.00000000000000E+00  -1.01759594646945E-10
      1.25997398014343E-18  -8.62986492217836E-03  -3.48945556511507E-03   0.00000000000000E+00   4.56807722848255E-14
     -3.89799626575357E-24  -1.63152512590545E-08  -1.63152055782822E-08  -1.00789771265566E-18
      4.35621571874999E-07
      0.00000000000000E+00  -1.62573450883671E-11   0.00000000000000E+00  -3.63893520972098E-15   3.14993289874677E-24
      1.62573545466888E-08   1.62573509077536E-08  -2.03760030199044E-19  -5.17430306054130E-01  -5.17430306054026E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04195661782327E-10   0.00000000000000E+00  -1.04195661782327E-10
      1.05158265657877E-18  -8.23448886654866E-03  -3.14513339067004E-03   0.00000000000000E+00   3.35207706383411E-14
     -3.39733222543328E-24  -1.61531887667419E-08  -1.61531552459712E-08  -8.47822626379727E-19
      4.37621571874999E-07
      0.00000000000000E+00  -1.61905739644172E-11   0.00000000000000E+00  -1.37640732287399E-15   2.86701223386907E-24
      1.61906102020723E-08   1.61906088256650E-08  -1.57771888919756E-19  -5.38148089428752E-01  -5.38148089428646E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06176457644656E-10   0.00000000000000E+00  -1.06176457644656E-10
      8.39229741289458E-19  -7.97236770781202E-03  -2.90466218278791E-03   0.00000000000000E+00   2.80730727545821E-14
     -3.03392066210932E-24  -1.60844604410931E-08  -1.60844323680203E-08  -6.81457852369702E-19
      4.39621571874999E-07
      0.00000000000000E+00  -1.61549382063807E-11   0.00000000000000E+00  -6.33870086043526E-16   2.65326163019264E-24
      1.61549378553232E-08   1.61549372214531E-08  -1.13964530209813E-19  -5.58442831332906E-01  -5.58442831332799E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07595936005862E-10   0.00000000000000E+00  -1.07595936005862E-10
      6.24037869277733E-19  -7.78147777862536E-03  -2.72545665830034E-03   0.00000000000000E+00   2.47627222419931E-14
     -2.75612386321582E-24  -1.60473660481695E-08  -1.60473412854473E-08  -5.10073339067920E-19
      4.41621571874999E-07
      0.00000000000000E+00  -1.61325280905021E-11   0.00000000000000E+00  -3.26400151177647E-16   2.48514111076767E-24
      1.61325475012585E-08   1.61325471748583E-08  -7.21840685803559E-20  -5.78315835957656E-01  -5.78315835957547E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08447824144216E-10   0.00000000000000E+00  -1.08447824144216E-10
      4.07142220989301E-19  -7.63494947968597E-03  -2.58624938010691E-03   0.00000000000000E+00   2.23489545271490E-14
     -2.53689749382044E-24  -1.60241216996686E-08  -1.60240993507141E-08  -3.34958152408944E-19
      4.43621571874999E-07
      0.00000000000000E+00  -1.61168226404396E-11   0.00000000000000E+00  -1.80389941315773E-16   2.34936886316797E-24
      1.61167940949920E-08   1.61167939146021E-08  -3.24076523765146E-20  -5.97702347076189E-01  -5.97702347076081E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08420787393525E-10   0.00000000000000E+00  -1.08420787393525E-10
      1.90300646202252E-19  -7.51827550132554E-03  -2.47452870760151E-03   0.00000000000000E+00   2.03715553335985E-14
     -2.36009602272302E-24  -1.60083934987639E-08  -1.60083731272085E-08  -1.57892993825737E-19
      4.45621571874999E-07
      0.00000000000000E+00  -1.61011171903771E-11   0.00000000000000E+00  -1.96080597148424E-16   2.24054481629603E-24
      1.61011576101515E-08   1.61011574140709E-08   4.81573530070745E-21  -6.16247034115683E-01  -6.16247034115577E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05870374464275E-10   0.00000000000000E+00  -1.05870374464275E-10
     -2.14401027262986E-20  -7.42638431262399E-03  -2.38675924936471E-03   0.00000000000000E+00   1.84287210088385E-14
     -2.21939642411187E-24  -1.59953054683276E-08  -1.59952870396066E-08   1.66243674255911E-20
      4.47621571874999E-07
      0.00000000000000E+00  -1.60729208560544E-11   0.00000000000000E+00  -5.28229210413340E-16   2.16423899721464E-24
      1.60729386891093E-08   1.60729381608801E-08   3.85310415140585E-20  -6.33360477438789E-01  -6.33360477438690E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93055528153163E-11   0.00000000000000E+00  -9.93055528153163E-11
     -2.20051208356931E-19  -7.37595931324431E-03  -2.34315585830111E-03   0.00000000000000E+00   1.64501266808180E-14
     -2.12298954103914E-24  -1.59736490581914E-08  -1.59736326080647E-08   1.81520166842874E-19
      4.49621571874999E-07
      0.00000000000000E+00  -1.60527150138687E-11   0.00000000000000E+00  -3.58984927770779E-16   2.10454034230268E-24
      1.60527383951708E-08   1.60527380361859E-08   6.70760910079819E-20  -6.48083411289745E-01  -6.48083411289659E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.66103508683698E-11   0.00000000000000E+00  -8.66103508683698E-11
     -3.93271910093670E-19  -7.33903248247930E-03  -2.30859273272685E-03   0.00000000000000E+00   1.33861504034449E-14
     -2.04832084973856E-24  -1.59661410714679E-08  -1.59661276853175E-08   3.26195819085689E-19
      4.50621571874999E-07
      0.00000000000000E+00  -1.60399485953969E-11   0.00000000000000E+00  -5.11645107043532E-16   2.07922077298723E-24
      1.60399337556169E-08   1.60399332439718E-08   7.95200198108403E-20  -6.54566250653744E-01  -6.54566250653667E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.69148301552189E-11   0.00000000000000E+00  -7.69148301552189E-11
     -4.70186740248890E-19  -7.32327489942954E-03  -2.29381441503237E-03   0.00000000000000E+00   1.15157508407923E-14
     -2.01745714139487E-24  -1.59630299295675E-08  -1.59630184138166E-08   3.90666720438049E-19
      4.51971571874999E-07
      0.00000000000000E+00  -1.60181813926787E-11   0.00000000000000E+00  -7.05181719560541E-16   2.05311787384136E-24
      1.60181620312626E-08   1.60181613260809E-08   9.22753756657953E-20  -6.61250563984418E-01  -6.61250563984358E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.90366449253081E-11   0.00000000000000E+00  -5.90366449253081E-11
     -5.49886210898056E-19  -7.30654207412961E-03  -2.27830800763652E-03   0.00000000000000E+00   8.70421197096820E-15
     -1.98644217826776E-24  -1.59591333853675E-08  -1.59591246811556E-08   4.57610835232261E-19
      4.53794071874999E-07
      0.00000000000000E+00  -1.59793310688399E-11   0.00000000000000E+00  -7.93506547261306E-16   2.03487120233515E-24
      1.59793513066750E-08   1.59793505131685E-08   9.98295991049809E-20  -6.65226450802635E-01  -6.65226450802609E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61237292006862E-11   0.00000000000000E+00  -2.61237292006862E-11
     -5.97496707366307E-19  -7.29329537763432E-03  -2.26691940182996E-03   0.00000000000000E+00   3.67623429385486E-15
     -1.96784193811113E-24  -1.59532304602021E-08  -1.59532267839678E-08   4.97667108261326E-19
      4.55794071874999E-07
      0.00000000000000E+00  -1.59222954870340E-11   0.00000000000000E+00  -3.29003282973496E-16   2.04074534151429E-24
      1.59223135916238E-08   1.59223132626205E-08   9.25617330029220E-20  -6.61395704671090E-01  -6.61395704671114E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28918976638035E-11   0.00000000000000E+00   2.28918976638035E-11
     -5.51712912038700E-19  -7.29288249208432E-03  -2.26903437191244E-03   0.00000000000000E+00  -4.18575493848489E-15
     -1.98321940327407E-24  -1.59452009745294E-08  -1.59452051602843E-08   4.59151179035778E-19
      4.57794071874999E-07
      0.00000000000000E+00  -1.58477175604215E-11   0.00000000000000E+00  -1.98100674628540E-15   2.08260958389166E-24
      1.58476719900908E-08   1.58476700090840E-08   6.46664306373058E-20  -6.46820858407670E-01  -6.46820858407756E-01
      0.00000000000000E+00   0.00000000000000E+00   8.65883335403259E-11   0.00000000000000E+00   8.65883335403259E-11
     -3.78536244958048E-19  -7.31210100942204E-03  -2.29170235925542E-03   0.00000000000000E+00  -1.24157157385436E-14
     -2.04940100944992E-24  -1.59342459269086E-08  -1.59342583426243E-08   3.13869814320742E-19
      4.59794071874999E-07
      0.00000000000000E+00  -1.57523827232001E-11   0.00000000000000E+00  -2.79351315650873E-15   2.18059286505829E-24
      1.57523402299292E-08   1.57523374364160E-08   9.27888951575021E-21  -6.18475458640484E-01  -6.18475458640649E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65540484001175E-10   0.00000000000000E+00   1.65540484001175E-10
     -4.74552769556967E-20  -7.36128103247754E-03  -2.34604497300375E-03   0.00000000000000E+00  -2.53045666995111E-14
     -2.19847219471335E-24  -1.59178526158505E-08  -1.59178779204172E-08   3.81763874399463E-20
      4.61794071874999E-07
      0.00000000000000E+00  -1.55879806435986E-11   0.00000000000000E+00  -4.54429862266637E-15   2.42943366925972E-24
      1.55879905054530E-08   1.55879859611544E-08  -8.36646100435611E-20  -5.72774643861295E-01  -5.72774643861552E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57555015390429E-10   0.00000000000000E+00   2.57555015390429E-10
      4.67654753825161E-19  -7.54928362272598E-03  -2.55684215983258E-03   0.00000000000000E+00  -4.43004621982772E-14
     -2.58419171882658E-24  -1.58454966760827E-08  -1.58455409765449E-08  -3.83990143781599E-19
      4.63794071874999E-07
      0.00000000000000E+00  -1.53180489609457E-11   0.00000000000000E+00  -7.50017393507707E-15   3.04318842231273E-24
      1.53181012948382E-08   1.53180937946642E-08  -2.29453707750409E-19  -5.06056773889657E-01  -5.06056773890005E-01
      0.00000000000000E+00   0.00000000000000E+00   3.48009783166315E-10   0.00000000000000E+00   3.48009783166315E-10
      1.16367432015779E-18  -8.08276493246650E-03  -3.14686565793833E-03   0.00000000000000E+00  -7.69734200261603E-14
     -3.67634704307497E-24  -1.56660266044105E-08  -1.56661035778306E-08  -9.34220612407384E-19
      4.65794071874999E-07
      0.00000000000000E+00  -1.43703031177013E-11   0.00000000000000E+00  -3.14420715258853E-14   4.83765512541213E-24
      1.43703266350048E-08   1.43702951929333E-08  -4.46057932345714E-19  -4.16000427851284E-01  -4.16000427851682E-01
      0.00000000000000E+00   0.00000000000000E+00   3.97808583978233E-10   0.00000000000000E+00   3.97808583978233E-10
      1.95929148811426E-18  -1.03590681607845E-02  -5.70611449906625E-03   0.00000000000000E+00  -1.32115255456286E-13
     -9.28523589438786E-24  -1.47679716616561E-08  -1.47681037769115E-08  -1.51323355576855E-18
      4.67794071874999E-07
      0.00000000000000E+00  -7.80230227051661E-12   0.00000000000000E+00  -1.65241152511517E-13  -3.33282535182332E-25
      7.80243662380689E-09   7.80227138265438E-09  -7.13311230666126E-19  -3.03371371601412E-01  -3.03371371601815E-01
      0.00000000000000E+00   0.00000000000000E+00   4.02892006159647E-10   0.00000000000000E+00   4.02892006159647E-10
      2.76507550043355E-18  -2.54119082493824E-02  -2.28267489208405E-02   0.00000000000000E+00  -2.35961460268709E-13
     -5.44005472910806E-23  -8.20492742735370E-09  -8.20516338881403E-09  -2.05176426976743E-18
      4.69794071874999E-07
      0.00000000000000E+00  -5.65304357512327E-13   0.00000000000000E+00  -1.84210537730439E-13  -3.85751602382505E-23
      5.65489023095307E-10   5.65304812557538E-10  -9.77715043951584E-19  -1.77582243532653E-01  -1.77582243533052E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98962905256855E-10   0.00000000000000E+00   3.98962905256855E-10
      3.56300131094726E-18  -5.43072300131230E-02  -5.40034270504773E-02   0.00000000000000E+00  -6.78154609586483E-13
     -8.71085873272642E-23  -9.63589563204720E-10  -9.64267717814394E-10  -2.58528626699568E-18
      4.71794071874999E-07
      0.00000000000000E+00   8.16499713774913E-14   0.00000000000000E+00  -2.32366495811844E-14  -4.54630889462754E-23
     -8.16061091040269E-11  -8.16293457536535E-11  -1.19202133686440E-18  -7.12934915325870E-02  -7.12934915329010E-02
      0.00000000000000E+00   0.00000000000000E+00   3.13988044665872E-10   0.00000000000000E+00   3.13988044665872E-10
      4.19097740027901E-18  -8.40496577836834E-02  -8.39764507654170E-02   0.00000000000000E+00  -1.24557463567296E-12
     -9.88122431877140E-23  -2.31113124276446E-10  -2.32358698912218E-10  -2.99895606341460E-18
      4.73794071874999E-07
      0.00000000000000E+00   4.52794554433107E-14   0.00000000000000E+00  -2.16799709743951E-15  -4.63430855047390E-23
     -4.52798741954345E-11  -4.52820421925783E-11  -1.28120438310457E-18  -2.74173922142376E-02  -2.74173922144076E-02
      0.00000000000000E+00   0.00000000000000E+00   1.70019603394309E-10   0.00000000000000E+00   1.70019603394309E-10
      4.53101660706763E-18  -1.13399630458717E-01  -1.13360330870736E-01   0.00000000000000E+00  -8.53780477598252E-13
     -1.04890808315563E-22  -1.23883780724028E-10  -1.24737561201731E-10  -3.24981222396305E-18
      4.75794071874999E-07
      0.00000000000000E+00   8.44971582309246E-15   0.00000000000000E+00   6.32836711754084E-16  -4.63557726607025E-23
     -8.47305180791760E-12  -8.47241897125220E-12  -1.31058344021406E-18  -1.41507791504519E-02  -1.41507791505491E-02
      0.00000000000000E+00   0.00000000000000E+00   9.71543942249347E-11   0.00000000000000E+00   9.71543942249347E-11
      4.72532539551749E-18  -1.42219007930288E-01  -1.42191068269687E-01   0.00000000000000E+00  -5.12562090467109E-13
     -1.08003236435666E-22  -8.81694131631070E-11  -8.86819752536822E-11  -3.41474195530343E-18
      4.75919071874999E-07
      0.00000000000000E+00   6.06175265569677E-15   0.00000000000000E+00   8.60167340314229E-16  -4.63504954793852E-23
     -6.07944126247446E-12  -6.07858109518049E-12  -1.31218374364772E-18  -1.34441150290037E-02  -1.34441150290962E-02
      0.00000000000000E+00   0.00000000000000E+00   9.24765681595080E-11   0.00000000000000E+00   9.24765681595080E-11
      4.73688496653743E-18  -1.44018054804102E-01  -1.43990834738767E-01   0.00000000000000E+00  -5.06235738623058E-13
     -1.08188613336885E-22  -8.58917513255934E-11  -8.63979870643247E-11  -3.42470122288971E-18
      4.76087821874999E-07
      0.00000000000000E+00   3.21456580226344E-15   0.00000000000000E+00   9.65382108440647E-16  -4.63367508788117E-23
     -3.17447445305833E-12  -3.17350907099623E-12  -1.31398795334000E-18  -1.26697225550025E-02  -1.26697225550898E-02
      0.00000000000000E+00   0.00000000000000E+00   8.73174471111113E-11   0.00000000000000E+00   8.73174471111113E-11
      4.75161978573744E-18  -1.46442801620884E-01  -1.46416291739851E-01   0.00000000000000E+00  -4.73411882747124E-13
     -1.08421092427869E-22  -8.36705261572729E-11  -8.41439380401284E-11  -3.43763183239743E-18
      4.76315634374999E-07
      0.00000000000000E+00  -2.75534211622580E-16   0.00000000000000E+00   1.04989253695309E-15  -4.63084976292157E-23
      2.60948008442786E-13   2.61997900933431E-13  -1.31591674689885E-18  -1.18702941063412E-02  -1.18702941064227E-02
      0.00000000000000E+00   0.00000000000000E+00   8.15583707279443E-11   0.00000000000000E+00   8.15583707279443E-11
      4.77019980206890E-18  -1.49708821785798E-01  -1.49683043994281E-01   0.00000000000000E+00  -4.42765013774257E-13
     -1.08712431586037E-22  -8.13776036149950E-11  -8.18203686288780E-11  -3.45428305517005E-18
      4.76623181249999E-07
      0.00000000000000E+00  -4.22485791154623E-15   0.00000000000000E+00   1.10048203782723E-15  -4.62557673939120E-23
      4.24497874463524E-12   4.24607922662681E-12  -1.31784420993480E-18  -1.11002232899553E-02  -1.11002232900307E-02
      0.00000000000000E+00   0.00000000000000E+00   7.53875775661359E-11   0.00000000000000E+00   7.53875775661359E-11
      4.79338501596318E-18  -1.54104216707138E-01  -1.54079127889417E-01   0.00000000000000E+00  -4.17877098033052E-13
     -1.09080662553987E-22  -7.92157796946202E-11  -7.96336567927623E-11  -3.47554080602839E-18
      4.77038369531249E-07
      0.00000000000000E+00  -8.81709477192257E-15   0.00000000000000E+00   1.10252869423028E-15  -4.61615225042297E-23
      8.81081391307614E-12   8.81191644172421E-12  -1.31960359097261E-18  -1.04103720983895E-02  -1.04103720984585E-02
      0.00000000000000E+00   0.00000000000000E+00   6.90123890780922E-11   0.00000000000000E+00   6.90123890780922E-11
      4.82203815116947E-18  -1.60012591899140E-01  -1.59988073168723E-01   0.00000000000000E+00  -4.01821876144598E-13
     -1.09554491909606E-22  -7.74224836435585E-11  -7.78243055198127E-11  -3.50243456019686E-18
      4.77598873710936E-07
      0.00000000000000E+00  -1.40522447927516E-14   0.00000000000000E+00   1.04860824508624E-15  -4.59936400518557E-23
      1.40324726973529E-11   1.40335213055520E-11  -1.32099527478241E-18  -9.82908752284224E-03  -9.82908752290482E-03
      0.00000000000000E+00   0.00000000000000E+00   6.25822990587778E-11   0.00000000000000E+00   6.25822990587778E-11
      4.85711579136637E-18  -1.67942204074613E-01  -1.67918066132063E-01   0.00000000000000E+00  -3.96176491377510E-13
     -1.10178670281811E-22  -7.62196438728425E-11  -7.66158203643302E-11  -3.53612051658396E-18
      4.78355554353514E-07
      0.00000000000000E+00  -2.00221527112408E-14   0.00000000000000E+00   9.42945261161096E-16  -4.56845744614325E-23
      2.00299203068602E-11   2.00308632520756E-11  -1.32178666258585E-18  -9.35171553475028E-03  -9.35171553480644E-03
      0.00000000000000E+00   0.00000000000000E+00   5.61510673029194E-11   0.00000000000000E+00   5.61510673029194E-11
      4.89960421705459E-18  -1.78562070090546E-01  -1.78538068909618E-01   0.00000000000000E+00  -4.00441281324465E-13
     -1.11019258134481E-22  -7.57814892735587E-11  -7.61819305549942E-11  -3.57781755446874E-18
      4.79377073220995E-07
      0.00000000000000E+00  -2.69105080018053E-14   0.00000000000000E+00   8.01656488822514E-16  -4.50808573448447E-23
      2.69402011533430E-11   2.69410028097867E-11  -1.32170861365102E-18  -8.94860391039722E-03  -8.94860391044696E-03
      0.00000000000000E+00   0.00000000000000E+00   4.97306826324004E-11   0.00000000000000E+00   4.97306826324004E-11
      4.95040504765627E-18  -1.92745147605855E-01  -1.92720992213905E-01   0.00000000000000E+00  -4.12393072548657E-13
     -1.12168180783662E-22  -7.62592923695253E-11  -7.66716854421862E-11  -3.62869643400525E-18
      4.80756123692094E-07
      0.00000000000000E+00  -3.49010001388602E-14   0.00000000000000E+00   6.49157263390630E-16  -4.38208469463098E-23
      3.48972061063501E-11   3.48978552635697E-11  -1.32048086608227E-18  -8.58703930571886E-03  -8.58703930576227E-03
      0.00000000000000E+00   0.00000000000000E+00   4.34108509610828E-11   0.00000000000000E+00   4.34108509610828E-11
      5.01027080212494E-18  -2.11617119985526E-01  -2.11592448976474E-01   0.00000000000000E+00  -4.29122934862867E-13
     -1.13747690907403E-22  -7.78795832896755E-11  -7.83087062246521E-11  -3.68978993604267E-18
      4.82617841828077E-07
      0.00000000000000E+00  -4.40854738596128E-14   0.00000000000000E+00   5.06938739798953E-16  -4.10455969162460E-23
      4.40801727302779E-11   4.40806796689766E-11  -1.31789418188311E-18  -8.24971183772767E-03  -8.24971183776510E-03
      0.00000000000000E+00   0.00000000000000E+00   3.74306468509856E-11   0.00000000000000E+00   3.74306468509856E-11
      5.07995611620900E-18  -2.36605806226180E-01  -2.36580126426658E-01   0.00000000000000E+00  -4.48072903381975E-13
     -1.15916282587579E-22  -8.10632536164636E-11  -8.15113265199615E-11  -3.76206193432589E-18
      4.84617841828077E-07
      0.00000000000000E+00  -5.29025686315354E-14   0.00000000000000E+00   4.11558775270893E-16  -3.61555236518675E-23
      5.28882323939888E-11   5.28886439527279E-11  -1.31471713123828E-18  -7.98954124560312E-03  -7.98954124563601E-03
      0.00000000000000E+00   0.00000000000000E+00   3.28878951728039E-11   0.00000000000000E+00   3.28878951728039E-11
      5.14573190655461E-18  -2.62900926445987E-01  -2.62873903136788E-01   0.00000000000000E+00  -4.66563252658596E-13
     -1.18275865500673E-22  -8.53099758727549E-11  -8.57765391255317E-11  -3.83101477531633E-18
      4.86617841828077E-07
      0.00000000000000E+00  -6.09849055057978E-14   0.00000000000000E+00   3.50446135147121E-16  -2.86855679611852E-23
      6.10147997011301E-11   6.10151501472366E-11  -1.31148545872362E-18  -7.79580574947609E-03  -7.79580574950569E-03
      0.00000000000000E+00   0.00000000000000E+00   2.95963448750190E-11   0.00000000000000E+00   2.95963448750190E-11
      5.20492459630465E-18  -2.88656282301093E-01  -2.88627736023337E-01   0.00000000000000E+00  -4.83569527495460E-13
     -1.20658262830411E-22  -9.01279254946393E-11  -9.06114950222554E-11  -3.89343913758102E-18
      4.88617841828077E-07
      0.00000000000000E+00  -6.86998634312300E-14   0.00000000000000E+00   3.10226828360238E-16  -1.81912323783486E-23
      6.86752534547551E-11   6.86755636815652E-11  -1.30836373098874E-18  -7.64647637850774E-03  -7.64647637853487E-03
      0.00000000000000E+00   0.00000000000000E+00   2.71295606530940E-11   0.00000000000000E+00   2.71295606530940E-11
      5.25918371761084E-18  -3.13875325944339E-01  -3.13845143735534E-01   0.00000000000000E+00  -5.00070488510519E-13
     -1.23061501476494E-22  -9.53050538460249E-11  -9.58051243346585E-11  -3.95081998662210E-18
      4.90617841828077E-07
      0.00000000000000E+00  -7.60474424078321E-14   0.00000000000000E+00   2.83359831268540E-16  -4.57887597954045E-24
      7.60212251156173E-11   7.60215084754440E-11  -1.30541855563123E-18  -7.52763257592260E-03  -7.52763257594781E-03
      0.00000000000000E+00   0.00000000000000E+00   2.52039508760287E-11   0.00000000000000E+00   2.52039508760287E-11
      5.30959161936289E-18  -3.38563700143190E-01  -3.38531810616632E-01   0.00000000000000E+00  -5.17688295305391E-13
     -1.25490218746620E-22  -1.00707771056042E-10  -1.01225459351473E-10  -4.00417306373167E-18
      4.92617841828077E-07
      0.00000000000000E+00  -8.31194871728117E-14   0.00000000000000E+00   2.65089185764250E-16   1.14538117201002E-23
      8.31578594083073E-11   8.31581244975045E-11  -1.30266539613425E-18  -7.43114504958814E-03  -7.43114504961176E-03
      0.00000000000000E+00   0.00000000000000E+00   2.36266550031738E-11   0.00000000000000E+00   2.36266550031738E-11
      5.35684492936924E-18  -3.62724956601295E-01  -3.62691316007678E-01   0.00000000000000E+00  -5.37476419187700E-13
     -1.27952321766354E-22  -1.06247303081363E-10  -1.06784779500679E-10  -4.05417953323499E-18
      4.94617841828077E-07
      0.00000000000000E+00  -9.02833766749988E-14   0.00000000000000E+00   2.57074176636660E-16   2.83776354423150E-23
      9.02450306110014E-11   9.02452876852064E-11  -1.30003951072093E-18  -7.37950958170446E-03  -7.37950958172668E-03
      0.00000000000000E+00   0.00000000000000E+00   2.22136150437399E-11   0.00000000000000E+00   2.22136150437399E-11
      5.40127215945672E-18  -3.86352002470713E-01  -3.86316574683415E-01   0.00000000000000E+00  -5.59036297689364E-13
     -1.30452047822395E-22  -1.11899866431127E-10  -1.12458902728947E-10  -4.10123264873579E-18
      4.96617841828077E-07
      0.00000000000000E+00  -9.72635767027708E-14   0.00000000000000E+00   2.47940588594038E-16   4.51735898858961E-23
      9.72402003122155E-11   9.72404482528493E-11  -1.29757030769224E-18  -7.34166824768784E-03  -7.34166824770893E-03
      0.00000000000000E+00   0.00000000000000E+00   2.10913654871004E-11   0.00000000000000E+00   2.10913654871004E-11
      5.44345489043092E-18  -4.09584873293593E-01  -4.09547595728676E-01   0.00000000000000E+00  -5.89216868598950E-13
     -1.33021327762777E-22  -1.17742596871217E-10  -1.18331813739949E-10  -4.14588458273868E-18
      4.98617841828077E-07
      0.00000000000000E+00  -1.04151931993335E-13   0.00000000000000E+00   2.41341996806952E-16   6.09725852509013E-23
      1.04187215416561E-10   1.04187456758619E-10  -1.29524383520943E-18  -7.31372847865071E-03  -7.31372847867080E-03
      0.00000000000000E+00   0.00000000000000E+00   2.00868651025106E-11   0.00000000000000E+00   2.00868651025106E-11
      5.48362862063594E-18  -4.32455869788167E-01  -4.32416720570563E-01   0.00000000000000E+00  -6.24332875616787E-13
     -1.35670807701706E-22  -1.23649988985378E-10  -1.24274321861130E-10  -4.18838478542651E-18
      5.00617841828077E-07
      0.00000000000000E+00  -1.11040287283900E-13   0.00000000000000E+00   2.35644619911604E-16   7.51263745774243E-23
      1.11081815547516E-10   1.11082051192211E-10  -1.29304530626316E-18  -7.29654582801777E-03  -7.29654582803685E-03
      0.00000000000000E+00   0.00000000000000E+00   1.90877211678935E-11   0.00000000000000E+00   1.90877211678935E-11
      5.52180406297173E-18  -4.54895427341521E-01  -4.54854421352576E-01   0.00000000000000E+00  -6.60516922630873E-13
     -1.38390562918650E-22  -1.29509255437335E-10  -1.30169772360104E-10  -4.22875875670857E-18
      5.02617841828077E-07
      0.00000000000000E+00  -1.17928642574464E-13   0.00000000000000E+00   2.31052892733384E-16   8.73076578098546E-23
      1.17930699989507E-10   1.17930931042487E-10  -1.29095551497043E-18  -7.29271193075801E-03  -7.29271193077612E-03
      0.00000000000000E+00   0.00000000000000E+00   1.81121934036795E-11   0.00000000000000E+00   1.81121934036795E-11
      5.55802844977909E-18  -4.76885515341269E-01  -4.76842659602182E-01   0.00000000000000E+00  -6.98822729746443E-13
     -1.41172008625284E-22  -1.35344301716278E-10  -1.36043124446165E-10  -4.26707293480866E-18
      5.04617841828077E-07
      0.00000000000000E+00  -1.24725153127821E-13   0.00000000000000E+00   2.27919185147935E-16   9.74862149816752E-23
      1.24752687426081E-10   1.24752915345364E-10  -1.28895063671255E-18  -7.30709161886979E-03  -7.30709161888696E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71680051373682E-11   0.00000000000000E+00   1.71680051373682E-11
      5.59236446005383E-18  -4.98428872803795E-01  -4.98384165978352E-01   0.00000000000000E+00  -7.38897547767925E-13
     -1.44002345526966E-22  -1.41182022934821E-10  -1.41920920482733E-10  -4.30341382334128E-18
      5.06617841828077E-07
      0.00000000000000E+00  -1.31613508418386E-13   0.00000000000000E+00   2.27271998523764E-16   1.05847312430257E-22
      1.31591200061993E-10   1.31591427334098E-10  -1.28699774140418E-18  -7.34897764676989E-03  -7.34897764678614E-03
      0.00000000000000E+00   0.00000000000000E+00   1.62546964766326E-11   0.00000000000000E+00   1.62546964766326E-11
      5.62487385300709E-18  -5.19533629548760E-01  -5.19487056771171E-01   0.00000000000000E+00  -7.79459186545459E-13
     -1.46862745037181E-22  -1.47066664624038E-10  -1.47846123810730E-10  -4.33787611160291E-18
      5.08617841828077E-07
      0.00000000000000E+00  -1.38869242657780E-13   0.00000000000000E+00   2.43538158337537E-16   1.12898220915967E-22
      1.38840009385899E-10   1.38840252924170E-10  -1.28491663919339E-18  -7.49636525811704E-03  -7.49636525813229E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52570065566057E-11   0.00000000000000E+00   1.52570065566057E-11
      5.65538786612030E-18  -5.40208565351004E-01  -5.40160024025563E-01   0.00000000000000E+00  -8.15905876651600E-13
     -1.49720005275427E-22  -1.53281353603974E-10  -1.54097259480775E-10  -4.37047122692691E-18
      5.10617841828077E-07
      0.00000000000000E+00  -1.47318958480873E-13   0.00000000000000E+00   2.96648200378407E-16   1.19423026005546E-22
      1.47362815851000E-10   1.47363112499319E-10  -1.28231967298554E-18  -7.91847333904210E-03  -7.91847333905611E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40112636942422E-11   0.00000000000000E+00   1.40112636942422E-11
      5.68341039350879E-18  -5.60461174734262E-01  -5.60410341760049E-01   0.00000000000000E+00  -8.41861402372208E-13
     -1.52526557524150E-22  -1.60532514791038E-10  -1.61374376193563E-10  -4.40109072052325E-18
      5.12617841828077E-07
      0.00000000000000E+00  -1.62197805908492E-13   0.00000000000000E+00   5.55210822767482E-16   1.28547802534770E-22
      1.62189717433351E-10   1.62190272644303E-10  -1.27721494887948E-18  -9.51947414561453E-03  -9.51947414562573E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11969108544796E-11   0.00000000000000E+00   1.11969108544796E-11
      5.70580421521774E-18  -5.80291562816954E-01  -5.80236946594427E-01   0.00000000000000E+00  -8.18282209397805E-13
     -1.55124978083278E-22  -1.72568901289229E-10  -1.73387183498782E-10  -4.42858926633826E-18
      5.14617841828077E-07
      0.00000000000000E+00  -2.36592043046589E-13   0.00000000000000E+00   2.80583143118340E-15   1.67728901739084E-22
      2.36544310658577E-10   2.36547116490176E-10  -1.25229516781935E-18  -2.01237670451109E-02  -2.01237670451051E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.85826666920565E-12   0.00000000000000E+00  -5.85826666920565E-12
      5.69408768187933E-18  -5.99621071824530E-01  -5.99548407113775E-01   0.00000000000000E+00  -3.88205604362408E-13
     -1.56312446838645E-22  -2.30300644216451E-10  -2.30688849820970E-10  -4.44179251405998E-18
      5.16617841828077E-07
      0.00000000000000E+00  -5.28015394206071E-13   0.00000000000000E+00   9.40402806589759E-15   2.64905215144276E-22
      5.28044266796654E-10   5.28053670824985E-10  -1.18627062209271E-18  -4.79797148205859E-02  -4.79797148205445E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.13810542317948E-11   0.00000000000000E+00  -4.13810542317948E-11
      5.61132557341574E-18  -6.18075138406145E-01  -6.17921841845317E-01   0.00000000000000E+00   4.54376433400330E-13
     -1.54907324905829E-22  -4.87126993026435E-10  -4.86672616593190E-10  -4.42505495132303E-18
      5.18617841828078E-07
      0.00000000000000E+00  -1.12032210445741E-12   0.00000000000000E+00   1.65646152624668E-14   3.33545309038810E-22
      1.12026731989143E-09   1.12028388450702E-09  -1.11184786863379E-18  -7.77648704316921E-02  -7.77648704316382E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.39458728109162E-11   0.00000000000000E+00  -5.39458728109162E-11
      5.50343382779391E-18  -6.35044326695483E-01  -6.34708438786288E-01   0.00000000000000E+00   4.89366151180831E-13
     -1.53347419262806E-22  -1.06682737784713E-09  -1.06633801169611E-09  -4.39158595916012E-18
      5.20617841828078E-07
      0.00000000000000E+00  -2.23742964311256E-12   0.00000000000000E+00   2.92051164539975E-14   3.77016511989298E-22
      2.23743684774718E-09   2.23746605286401E-09  -1.03970869291414E-18  -1.07215284035671E-01  -1.07215284035607E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.39118415040576E-11   0.00000000000000E+00  -6.39118415040576E-11
      5.37561014478580E-18  -6.49535788317168E-01  -6.48851131088520E-01   0.00000000000000E+00   4.08742990897982E-13
     -1.51986122857188E-22  -2.17396295435070E-09  -2.17355421135995E-09  -4.33590145187165E-18
      5.22617841828078E-07
      0.00000000000000E+00  -4.15523960074293E-12   0.00000000000000E+00   4.87194088185418E-14   4.10922202435735E-22
      4.15520773214024E-09   4.15525645154947E-09  -9.74064822635136E-19  -1.36153231675979E-01  -1.36153231675902E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.64040275307980E-11   0.00000000000000E+00  -7.64040275307980E-11
      5.22280208972420E-18  -6.60051947870587E-01  -6.58767125035303E-01   0.00000000000000E+00   3.10735284312930E-13
     -1.50888045644765E-22  -4.07916315930284E-09  -4.07885242401868E-09  -4.24873726708907E-18
      5.24617841828078E-07
      0.00000000000000E+00  -7.11714053094846E-12   0.00000000000000E+00   7.42842797407955E-14   4.37039352431737E-22
      7.11708839290089E-09   7.11716267718107E-09  -9.15695391518352E-19  -1.64520075923556E-01  -1.64520075923464E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.16898029164405E-11   0.00000000000000E+00  -9.16898029164405E-11
      5.03942248389132E-18  -6.64652886453288E-01  -6.62439878251707E-01   0.00000000000000E+00   2.39832297396861E-13
     -1.49971226708128E-22  -7.02571270656187E-09  -7.02547287426462E-09  -4.12372709237297E-18
      5.26617841828078E-07
      0.00000000000000E+00  -1.12968108317886E-11   0.00000000000000E+00   1.04186355410103E-13   4.52592186999124E-22
      1.12967466108870E-08   1.12968507972429E-08  -8.63175009322364E-19  -1.92303852841045E-01  -1.92303852840938E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07563261074358E-10   0.00000000000000E+00  -1.07563261074358E-10
      4.82429596174260E-18  -6.61094919988847E-01  -6.57570297195566E-01   0.00000000000000E+00   2.93212711157654E-13
     -1.48811864747034E-22  -1.11895807488795E-08  -1.11892875361685E-08  -3.96112095242024E-18
      5.28617841828078E-07
      0.00000000000000E+00  -1.68677452118483E-11   0.00000000000000E+00   1.38447181436165E-13   4.56001152153914E-22
      1.68676391369996E-08   1.68677775841815E-08  -8.14444222755759E-19  -2.19512395192556E-01  -2.19512395192435E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21256851518190E-10   0.00000000000000E+00  -1.21256851518190E-10
      4.58178225870623E-18  -6.46834606791632E-01  -6.41559398566750E-01   0.00000000000000E+00   5.71627119114193E-13
     -1.46585275391397E-22  -1.67470923597823E-08  -1.67465207326633E-08  -3.76733803595047E-18
      5.30617841828078E-07
      0.00000000000000E+00  -2.40919767063808E-11   0.00000000000000E+00   1.79286212395541E-13   4.47519699281169E-22
      2.40917713307093E-08   2.40919506169222E-08  -7.67745869191363E-19  -2.46160237898257E-01  -2.46160237898125E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31571508551532E-10   0.00000000000000E+00  -1.31571508551532E-10
      4.31863924160316E-18  -6.18863349662514E-01  -6.11315603593760E-01   0.00000000000000E+00   1.08989531185919E-12
     -1.42229819124159E-22  -2.39614690036824E-08  -2.39603791083707E-08  -3.55089337241180E-18
      5.32617841828078E-07
      0.00000000000000E+00  -3.32833387824240E-11   0.00000000000000E+00   2.28041292994961E-13   4.27496933651242E-22
      3.32831091499844E-08   3.32833371912779E-08  -7.21923807831493E-19  -2.72261153617344E-01  -2.72261153617205E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39563982544916E-10   0.00000000000000E+00  -1.39563982544916E-10
      4.03951127651333E-18  -5.73613894968248E-01  -5.63172974008576E-01   0.00000000000000E+00   1.70277409969579E-12
     -1.34824505037711E-22  -3.31454759828325E-08  -3.31437732087329E-08  -3.31758746868183E-18
      5.34617841828078E-07
      0.00000000000000E+00  -4.45165930560650E-11   0.00000000000000E+00   2.78869360721364E-13   3.91181174179146E-22
      4.45162779631526E-08   4.45165568325137E-08  -6.76504726747565E-19  -2.97823372732615E-01  -2.97823372732466E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48305133534562E-10   0.00000000000000E+00  -1.48305133534562E-10
      3.74290100944420E-18  -5.07420792222682E-01  -4.93443409477066E-01   0.00000000000000E+00   2.09764064358118E-12
     -1.24471701693387E-22  -4.43703493396226E-08  -4.43682516989791E-08  -3.06639628269663E-18
      5.36617841828078E-07
      0.00000000000000E+00  -5.71287123694025E-11   0.00000000000000E+00   3.13534446538923E-13   3.25433069090066E-22
      5.71283739528010E-08   5.71286874872479E-08  -6.31571188193693E-19  -3.22850154920936E-01  -3.22850154920775E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60458379490459E-10   0.00000000000000E+00  -1.60458379490459E-10
      3.42198425046328E-18  -4.17919899336426E-01  -3.99972438822003E-01   0.00000000000000E+00   2.05203142734422E-12
     -1.12846329583721E-22  -5.69702811391848E-08  -5.69682291077576E-08  -2.79041306226959E-18
      5.38617841828078E-07
      0.00000000000000E+00  -6.95919513637267E-11   0.00000000000000E+00   3.10427966912769E-13   2.53377359359186E-22
      6.95915939714651E-08   6.95919043994322E-08  -5.87135340200719E-19  -3.47350071570412E-01  -3.47350071570238E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73398114026201E-10   0.00000000000000E+00  -1.73398114026201E-10
      3.07518802241088E-18  -3.05771830753602E-01  -2.83901228803579E-01   0.00000000000000E+00   1.75816470447655E-12
     -9.98764734837199E-23  -6.94202644501105E-08  -6.94185062854062E-08  -2.48805268221016E-18
      5.40617841828078E-07
      0.00000000000000E+00  -7.76032004113904E-11   0.00000000000000E+00   2.00043197540489E-13   1.79998374417129E-22
      7.76030331326480E-08   7.76032331758457E-08  -5.43711527230615E-19  -3.71317019741624E-01  -3.71317019741429E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.94595729458126E-10   0.00000000000000E+00  -1.94595729458126E-10
      2.68599656349463E-18  -1.80150570101656E-01  -1.55762020142392E-01   0.00000000000000E+00   1.17427104463767E-12
     -8.53282035694961E-23  -7.74098117174321E-08  -7.74086374463875E-08  -2.14228503626401E-18
      5.41617841828078E-07
      0.00000000000000E+00  -7.74003153868990E-11   0.00000000000000E+00  -9.64122650548031E-15   1.21408335908431E-22
      7.74003005790482E-08   7.74002909378218E-08  -5.22360485788653E-19  -3.83157330297332E-01  -3.83157330297116E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16537052207844E-10   0.00000000000000E+00  -2.16537052207844E-10
      2.46945951128678E-18  -1.18147211105316E-01  -9.38293246328877E-02   0.00000000000000E+00   8.06182234872076E-13
     -7.69591974235122E-23  -7.71845600678487E-08  -7.71837538856139E-08  -1.94709902549813E-18
      5.42967841828078E-07
      0.00000000000000E+00  -6.11562877854270E-11   0.00000000000000E+00  -5.98398961455118E-13   4.83708678738284E-23
      6.11569250759453E-08   6.11563266769839E-08  -4.89850600363617E-19  -3.98948682441126E-01  -3.98948682440929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.97669974329030E-10   0.00000000000000E+00  -1.97669974329030E-10
      2.20260504594259E-18  -5.70530942928923E-02  -3.78470552711467E-02   0.00000000000000E+00   1.00281932523774E-12
     -4.29673604677450E-23  -6.09596595219800E-08  -6.09586567026549E-08  -1.71275444557898E-18
      5.44790341828078E-07
      0.00000000000000E+00  -3.40854188724573E-11   0.00000000000000E+00  -7.36056867711792E-13   1.55472532013563E-23
      3.40861641835663E-08   3.40854281266986E-08  -4.37699917081294E-19  -4.19992037880460E-01  -4.19992037880328E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32659009214567E-10   0.00000000000000E+00  -1.32659009214567E-10
      1.96083400164905E-18  -2.41737637264628E-02  -1.34763490057419E-02   0.00000000000000E+00   8.71396888494537E-13
     -1.58775802787590E-23  -3.39536405143725E-08  -3.39527691174840E-08  -1.52313408456775E-18
      5.46790341828078E-07
      0.00000000000000E+00  -2.15003019118588E-11   0.00000000000000E+00  -3.10609153103194E-13   7.08604144114210E-24
      2.15006324340328E-08   2.15003218248797E-08  -3.80753944213186E-19  -4.42675863711205E-01  -4.42675863711100E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04403015086890E-10   0.00000000000000E+00  -1.04403015086890E-10
      1.75202797147527E-18  -1.32979717832182E-02  -6.55680294544172E-03   0.00000000000000E+00   3.73653109364538E-13
     -7.78483866993012E-24  -2.13962924629022E-08  -2.13959188097929E-08  -1.37127402726208E-18
      5.48790341828078E-07
      0.00000000000000E+00  -1.76832346335140E-11   0.00000000000000E+00  -9.38356052700148E-14   4.72746999670488E-24
      1.76833239264588E-08   1.76832300908535E-08  -3.26315127823872E-19  -4.64913022906908E-01  -4.64913022906808E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94780471318196E-11   0.00000000000000E+00  -9.94780471318196E-11
      1.55307187721163E-18  -1.00562510601579E-02  -4.51616846538199E-03   0.00000000000000E+00   1.37975136565501E-13
     -5.26859918345175E-24  -1.75838900188583E-08  -1.75837520437217E-08  -1.22675674938775E-18
      5.50790341828078E-07
      0.00000000000000E+00  -1.66281222924739E-11   0.00000000000000E+00  -2.56866879895541E-14   3.80889793100770E-24
      1.66281185095717E-08   1.66280928228837E-08  -2.74432522315299E-19  -4.86700101250307E-01  -4.86700101250206E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00771539994435E-10   0.00000000000000E+00  -1.00771539994435E-10
      1.35152879722276E-18  -8.92183610235558E-03  -3.71459731918746E-03   0.00000000000000E+00   6.20619038175348E-14
     -4.20993284667289E-24  -1.65273833447931E-08  -1.65273212828893E-08  -1.07709627490746E-18
      5.52790341828078E-07
      0.00000000000000E+00  -1.63232896096821E-11   0.00000000000000E+00  -7.24192145835605E-15   3.31232045001132E-24
      1.63233742365189E-08   1.63233669945974E-08  -2.25033809995165E-19  -5.08043702810587E-01  -5.08043702810484E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03177354994580E-10   0.00000000000000E+00  -1.03177354994580E-10
      1.14517408723360E-18  -8.39519702848024E-03  -3.28472243483365E-03   0.00000000000000E+00   3.88298573736010E-14
     -3.60213631955335E-24  -1.62202284694602E-08  -1.62201896396028E-08  -9.20140277238431E-19
      5.54790341828078E-07
      0.00000000000000E+00  -1.62174844724190E-11   0.00000000000000E+00  -2.32903502807411E-15   2.98328505291884E-24
      1.62175234480985E-08   1.62175211190635E-08  -1.78021634363372E-19  -5.28952734708769E-01  -5.28952734708664E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05366186545895E-10   0.00000000000000E+00  -1.05366186545895E-10
      9.34441714141805E-19  -8.07963025943782E-03  -3.00319118606608E-03   0.00000000000000E+00   3.03625316982035E-14
     -3.18392194068321E-24  -1.61121852950493E-08  -1.61121549325176E-08  -7.56420079778434E-19
      5.56790341828078E-07
      0.00000000000000E+00  -1.61692659853851E-11   0.00000000000000E+00  -9.33988332509756E-16   2.74207339270035E-24
      1.61692733346590E-08   1.61692724006707E-08  -1.33260071817336E-19  -5.49435577068885E-01  -5.49435577068778E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07033569933902E-10   0.00000000000000E+00  -1.07033569933902E-10
      7.20374574274002E-19  -7.86034998497771E-03  -2.79963595192111E-03   0.00000000000000E+00   2.61442510278737E-14
     -2.87172903220190E-24  -1.60622649749878E-08  -1.60622388307368E-08  -5.87114502456665E-19
      5.58790341828078E-07
      0.00000000000000E+00  -1.61416207194856E-11   0.00000000000000E+00  -4.47549815305745E-16   2.55559301006427E-24
      1.61416233418880E-08   1.61416228943382E-08  -9.05916628862032E-20  -5.69497939875578E-01  -5.69497939875470E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08141233020263E-10   0.00000000000000E+00  -1.08141233020263E-10
      5.04092108233475E-19  -7.69607255101804E-03  -2.64441714718710E-03   0.00000000000000E+00   2.33613796553060E-14
     -2.62877141178040E-24  -1.60335050226976E-08  -1.60334816613179E-08  -4.13500445347271E-19
      5.60790341828078E-07
      0.00000000000000E+00  -1.61234354615185E-11   0.00000000000000E+00  -2.33277987516543E-16   2.40655047341630E-24
      1.61234105505803E-08   1.61234103173024E-08  -4.98930247531333E-20  -5.89124621606964E-01  -5.89124621606856E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08622724935458E-10   0.00000000000000E+00  -1.08622724935458E-10
      2.86846658362559E-19  -7.56734012284172E-03  -2.52157295698000E-03   0.00000000000000E+00   2.12321493450001E-14
     -2.43447058412334E-24  -1.60148088245162E-08  -1.60147875923669E-08  -2.36953633609426E-19
      5.62790341828078E-07
      0.00000000000000E+00  -1.61091995272514E-11   0.00000000000000E+00  -1.52878733541059E-16   2.28530542428662E-24
      1.61091798875208E-08   1.61091797346421E-08  -1.14390450903879E-20  -6.08102348422448E-01  -6.08102348422341E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07406557076685E-10   0.00000000000000E+00  -1.07406557076685E-10
      7.20335442091891E-20  -7.46320210498146E-03  -2.42153399449146E-03   0.00000000000000E+00   1.92915947272719E-14
     -2.27704026609384E-24  -1.60017924691601E-08  -1.60017731775654E-08  -6.05944991188006E-20
      5.64790341828078E-07
      0.00000000000000E+00  -1.60846769824170E-11   0.00000000000000E+00  -4.25826241972742E-16   2.19641257181010E-24
      1.60846936866004E-08   1.60846932607742E-08   2.39983291136340E-20  -6.25946473747406E-01  -6.25946473747303E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02831317216589E-10   0.00000000000000E+00  -1.02831317216589E-10
     -1.33629090223988E-19  -7.39716796901005E-03  -2.36177214841936E-03   0.00000000000000E+00   1.74272805393138E-14
     -2.16355927182815E-24  -1.59818793708382E-08  -1.59818619435576E-08   1.09630761110354E-19
      5.66790341828078E-07
      0.00000000000000E+00  -1.60626342454871E-11   0.00000000000000E+00  -3.91381507344375E-16   2.12924670321964E-24
      1.60626171382959E-08   1.60626167469144E-08   5.51118549211595E-20  -6.41887108386255E-01  -6.41887108386162E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.32440507631214E-11   0.00000000000000E+00  -9.32440507631214E-11
     -3.20117191750231E-19  -7.35443868758870E-03  -2.32297689514071E-03   0.00000000000000E+00   1.48211129911548E-14
     -2.07901159468605E-24  -1.59693875172643E-08  -1.59693726961513E-08   2.65005336829072E-19
      5.68790341828079E-07
      0.00000000000000E+00  -1.60388464585504E-11   0.00000000000000E+00  -4.67811191215115E-16   2.07869912415047E-24
      1.60388151025949E-08   1.60388146347837E-08   7.97600755608496E-20  -6.54691640552295E-01  -6.54691640552220E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.57808675079019E-11   0.00000000000000E+00  -7.57808675079019E-11
     -4.71678926766035E-19  -7.32292821727984E-03  -2.29346288827056E-03   0.00000000000000E+00   1.14504493755848E-14
     -2.01676696836334E-24  -1.59630452177252E-08  -1.59630337672758E-08   3.91918851205185E-19
      5.69790341828079E-07
      0.00000000000000E+00  -1.60228654742763E-11   0.00000000000000E+00  -6.91120859719775E-16   2.05810701379496E-24
      1.60228506641930E-08   1.60228499730721E-08   8.98318311678726E-20  -6.59967001651261E-01  -6.59967001651198E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.28727265272811E-11   0.00000000000000E+00  -6.28727265272811E-11
     -5.34551653293316E-19  -7.30979777331241E-03  -2.28129516168799E-03   0.00000000000000E+00   9.28350892837831E-15
     -1.99234472129639E-24  -1.59599865300538E-08  -1.59599772465448E-08   4.44719822125444E-19
      5.71140341828079E-07
      0.00000000000000E+00  -1.59960468110117E-11   0.00000000000000E+00  -9.19065408371117E-16   2.03930382468728E-24
      1.59960346067131E-08   1.59960336876477E-08   9.84767528376117E-20  -6.64513970213337E-01  -6.64513970213297E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.02919899562817E-11   0.00000000000000E+00  -4.02919899562817E-11
     -5.88945839734297E-19  -7.29702707787032E-03  -2.26985870230621E-03   0.00000000000000E+00   5.92973849353470E-15
     -1.97142537183483E-24  -1.59557476274299E-08  -1.59557416976915E-08   4.90469086896685E-19
      5.72962841828079E-07
      0.00000000000000E+00  -1.59496652187219E-11   0.00000000000000E+00  -1.25594781019454E-15   2.03334190243187E-24
      1.59496204338949E-08   1.59496191779471E-08   9.86318083418244E-20  -6.64593098408757E-01  -6.64593098408756E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44533291009673E-13   0.00000000000000E+00  -5.44533291009673E-13
     -5.89938251657161E-19  -7.29043603932284E-03  -2.26536823839045E-03   0.00000000000000E+00   2.58612990767855E-16
     -1.96980961251549E-24  -1.59490749032691E-08  -1.59490746446561E-08   4.91306443315337E-19
      5.74962841828079E-07
      0.00000000000000E+00  -1.58831696289836E-11   0.00000000000000E+00  -1.72657133651213E-15   2.05746527026480E-24
      1.58831915339345E-08   1.58831898073632E-08   8.06105807060965E-20  -6.55127456966876E-01  -6.55127456966933E-01
      0.00000000000000E+00   0.00000000000000E+00   5.64628838575328E-11   0.00000000000000E+00   5.64628838575328E-11
     -4.77012483942096E-19  -7.29996286694779E-03  -2.27786415535897E-03   0.00000000000000E+00  -7.91013624586716E-15
     -2.01073828936515E-24  -1.59396447810845E-08  -1.59396526912207E-08   3.96401903235999E-19
      5.76962841828079E-07
      0.00000000000000E+00  -1.57973866444318E-11   0.00000000000000E+00  -2.35121814822827E-15   2.12693277923878E-24
      1.57974531822499E-08   1.57974508310317E-08   3.84798119689979E-20  -6.33318736051600E-01  -6.33318736051729E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28592483584749E-10   0.00000000000000E+00   1.28592483584749E-10
     -2.19827516772598E-19  -7.33418229195922E-03  -2.31637272176951E-03   0.00000000000000E+00  -1.90302498840479E-14
     -2.11699669763758E-24  -1.59260242843666E-08  -1.59260433146165E-08   1.81347704803599E-19
      5.78962841828079E-07
      0.00000000000000E+00  -1.56720185781435E-11   0.00000000000000E+00  -4.01517556236665E-15   2.29046824829003E-24
      1.56719704994976E-08   1.56719664843221E-08  -3.61848173187014E-20  -5.95817274025933E-01  -5.95817274026149E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15496391416197E-10   0.00000000000000E+00   2.15496391416197E-10
      2.11165266059796E-19  -7.44150500130403E-03  -2.43585321265214E-03   0.00000000000000E+00  -3.43596113208559E-14
     -2.36631585967354E-24  -1.58874285161270E-08  -1.58874628757383E-08  -1.74980448741095E-19
      5.80962841828079E-07
      0.00000000000000E+00  -1.54637147141569E-11   0.00000000000000E+00  -7.77059723982815E-15   2.69333160952648E-24
      1.54636688929439E-08   1.54636611223466E-08  -1.56108969403655E-19  -5.38869809133809E-01  -5.38869809134119E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09898221489414E-10   0.00000000000000E+00   3.09898221489414E-10
      8.30961709038623E-19  -7.76778653508450E-03  -2.79802665502976E-03   0.00000000000000E+00  -5.79672559735642E-14
     -3.02388842569437E-24  -1.57735013765801E-08  -1.57735593438360E-08  -6.74852739634968E-19
      5.82962841828079E-07
      0.00000000000000E+00  -1.49897958701660E-11   0.00000000000000E+00  -1.40287748971236E-14   3.78328739106982E-24
      1.49898071543957E-08   1.49897931256208E-08  -3.39452157346529E-19  -4.59349314798691E-01  -4.59349314799075E-01
      0.00000000000000E+00   0.00000000000000E+00   3.84083625613267E-10   0.00000000000000E+00   3.84083625613267E-10
      1.59912896026516E-18  -8.86724446524515E-03  -4.02342375469085E-03   0.00000000000000E+00  -1.04791278739269E-13
     -5.44325534717308E-24  -1.53737719599553E-08  -1.53738767512341E-08  -1.25967680291863E-18
      5.84962841828079E-07
      0.00000000000000E+00  -1.21337919219608E-11   0.00000000000000E+00  -9.98724054677879E-14   5.71892649542485E-24
      1.21338874426446E-08   1.21337875702391E-08  -5.92517358387944E-19  -3.56320609263337E-01  -3.56320609263736E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99242609271295E-10   0.00000000000000E+00   3.99242609271295E-10
      2.39761417880775E-18  -1.54944779369538E-02  -1.15457321498656E-02   0.00000000000000E+00  -1.61793887387927E-13
     -2.52072974523958E-23  -1.25328683856230E-08  -1.25330301795104E-08  -1.80509682041980E-18
      5.86962841828079E-07
      0.00000000000000E+00  -2.33267263559676E-12   0.00000000000000E+00  -2.47751588754525E-13  -2.51067782271022E-23
      2.33290763226987E-09   2.33265988068109E-09  -8.59749633449558E-19  -2.34480959730330E-01  -2.34480959730739E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09057879219392E-10   0.00000000000000E+00   4.09057879219392E-10
      3.21572993724653E-18  -4.11173028034040E-02  -4.02534896608556E-02   0.00000000000000E+00  -3.91594910938206E-13
     -8.02879173349941E-23  -2.74132616498947E-09  -2.74171775990048E-09  -2.35598030379697E-18
      5.88962841828079E-07
      0.00000000000000E+00   9.46000793237526E-15   0.00000000000000E+00  -6.50058906037582E-14  -4.41986461223181E-23
     -9.38545259251646E-12  -9.45045848316442E-12  -1.11287184430114E-18  -1.11153450625192E-01  -1.11153450625559E-01
      0.00000000000000E+00   0.00000000000000E+00   3.67318563793195E-10   0.00000000000000E+00   3.67318563793195E-10
      3.95036706483292E-18  -7.08806039533057E-02  -7.07678539464399E-02   0.00000000000000E+00  -1.09773192409513E-12
     -9.40035866850442E-23  -3.56770373385843E-10  -3.57868105310032E-10  -2.83749522053178E-18
      5.90962841828079E-07
      0.00000000000000E+00   6.79651055335698E-14   0.00000000000000E+00  -6.63973191602327E-15  -4.61037025674580E-23
     -6.79648189464367E-11  -6.79714586783988E-11  -1.25259481256810E-18  -4.12245971003383E-02  -4.12245971005659E-02
      0.00000000000000E+00   0.00000000000000E+00   2.27594134677310E-10   0.00000000000000E+00   2.27594134677310E-10
      4.40555533418754E-18  -1.00429921832192E-01  -1.00379631181303E-01   0.00000000000000E+00  -1.08697528591014E-12
     -1.02765662558437E-22  -1.58535700712898E-10  -1.59622675998911E-10  -3.15296052161945E-18
      5.92962841828079E-07
      0.00000000000000E+00   2.22264264042215E-14   0.00000000000000E+00  -3.59081679435040E-17  -4.63962339614183E-23
     -2.22209130784310E-11  -2.22209489866453E-11  -1.30148860615675E-18  -1.81611795403587E-02  -1.81611795404808E-02
      0.00000000000000E+00   0.00000000000000E+00   1.22106286852938E-10   0.00000000000000E+00   1.22106286852938E-10
      4.64976790789342E-18  -1.29493884922002E-01  -1.29462415434659E-01   0.00000000000000E+00  -6.25814729581719E-13
     -1.06779742029752E-22  -9.92595231366045E-11  -9.98853378662930E-11  -3.34827930173666E-18
      5.94962841828079E-07
      0.00000000000000E+00  -4.40854738596128E-15   0.00000000000000E+00   9.03219552842445E-16  -4.62001058209895E-23
      4.44013680790775E-12   4.44104002741439E-12  -1.31673848290221E-18  -1.14792951704897E-02  -1.14792951705667E-02
      0.00000000000000E+00   0.00000000000000E+00   7.69946750725874E-11   0.00000000000000E+00   7.69946750725874E-11
      4.80375725803859E-18  -1.57995206505109E-01  -1.57969549948441E-01   0.00000000000000E+00  -4.42710568042490E-13
     -1.09364574501057E-22  -8.09930045318496E-11  -8.14357151000015E-11  -3.48701877513638E-18
      5.95462841828079E-07
      0.00000000000000E+00  -1.01947658300355E-14   0.00000000000000E+00   1.01604671325673E-15  -4.60841970400080E-23
      1.02052648201903E-11   1.02062808668575E-11  -1.31907761724490E-18  -1.04747901813853E-02  -1.04747901814538E-02
      0.00000000000000E+00   0.00000000000000E+00   6.84435218714123E-11   0.00000000000000E+00   6.84435218714123E-11
      4.83797901897430E-18  -1.65083914833808E-01  -1.65059136046037E-01   0.00000000000000E+00  -4.22662322669966E-13
     -1.09961693359323E-22  -7.82271404154893E-11  -7.86498027382692E-11  -3.51890140172940E-18
      5.96137841828079E-07
      0.00000000000000E+00  -1.64402079601473E-14   0.00000000000000E+00   9.81004944906105E-16  -4.58588549134388E-23
      1.64654690949560E-11   1.64664500998551E-11  -1.32069339187038E-18  -9.71940325986205E-03  -9.71940325992266E-03
      0.00000000000000E+00   0.00000000000000E+00   6.06144710780597E-11   0.00000000000000E+00   6.06144710780597E-11
      4.87889378695199E-18  -1.74586343932473E-01  -1.74562059494228E-01   0.00000000000000E+00  -4.07823721582340E-13
     -1.10728809090779E-22  -7.66730974562199E-11  -7.70809211779129E-11  -3.55820039508161E-18
      5.97049091828079E-07
      0.00000000000000E+00  -2.34204079879193E-14   0.00000000000000E+00   8.69091883577034E-16  -4.54169650029144E-23
      2.33908897945029E-11   2.33917588863411E-11  -1.32135975257450E-18  -9.16620696162265E-03  -9.16620696167599E-03
      0.00000000000000E+00   0.00000000000000E+00   5.33331363501451E-11   0.00000000000000E+00   5.33331363501451E-11
      4.92749360745106E-18  -1.87291933592836E-01  -1.87267761401703E-01   0.00000000000000E+00  -4.09569794200716E-13
     -1.11752450753774E-22  -7.63153254421751E-11  -7.67248952364875E-11  -3.60613385487656E-18
      5.98279279328079E-07
      0.00000000000000E+00  -3.12272106505591E-14   0.00000000000000E+00   7.23414108640674E-16  -4.45055566571388E-23
      3.11861387353846E-11   3.11868621494488E-11  -1.32084452712663E-18  -8.73938103165909E-03  -8.73938103170557E-03
      0.00000000000000E+00   0.00000000000000E+00   4.64800826198618E-11   0.00000000000000E+00   4.64800826198618E-11
      4.98467282408898E-18  -2.04223664560649E-01  -2.04199195687378E-01   0.00000000000000E+00  -4.22011518825977E-13
     -1.13148707665387E-22  -7.72449332503708E-11  -7.76669447693100E-11  -3.66382829696235E-18
      5.99940032453079E-07
      0.00000000000000E+00  -4.00443054224817E-14   0.00000000000000E+00   5.71890829410497E-16  -4.25188706944765E-23
      4.00606411373152E-11   4.00612130281021E-11  -1.31894043616882E-18  -8.37700938263695E-03  -8.37700938267702E-03
      0.00000000000000E+00   0.00000000000000E+00   4.00677457256254E-11   0.00000000000000E+00   4.00677457256254E-11
      5.05121545801452E-18  -2.26688269244296E-01  -2.26663024878430E-01   0.00000000000000E+00  -4.39776519699046E-13
     -1.15066046807585E-22  -7.96891822339133E-11  -8.01289587537274E-11  -3.73227502184570E-18
      6.01940032453079E-07
      0.00000000000000E+00  -4.93206238804419E-14   0.00000000000000E+00   4.52669214336633E-16  -3.85607486690582E-23
      4.93501803913422E-11   4.93506330605180E-11  -1.31593990705773E-18  -8.07903063044775E-03  -8.07903063048248E-03
      0.00000000000000E+00   0.00000000000000E+00   3.47346274095784E-11   0.00000000000000E+00   3.47346274095784E-11
      5.12068471283368E-18  -2.53186812554601E-01  -2.53160321987191E-01   0.00000000000000E+00  -4.58656568707615E-13
     -1.17409233924640E-22  -8.36266039012719E-11  -8.40852604700969E-11  -3.80474480577595E-18
      6.03940032453079E-07
      0.00000000000000E+00  -5.77703397035343E-14   0.00000000000000E+00   3.77220089295662E-16  -3.22695472369675E-23
      5.78034205301178E-11   5.78037977501748E-11  -1.31273204247339E-18  -7.86258014883983E-03  -7.86258014887076E-03
      0.00000000000000E+00   0.00000000000000E+00   3.09269673556493E-11   0.00000000000000E+00   3.09269673556493E-11
      5.18253864754498E-18  -2.79142371772594E-01  -2.79114417908475E-01   0.00000000000000E+00  -4.76583855986901E-13
     -1.19779561390828E-22  -8.82541812497174E-11  -8.87307651058240E-11  -3.86980660507158E-18
      6.05940032453079E-07
      0.00000000000000E+00  -6.56689871033816E-14   0.00000000000000E+00   3.27840430241659E-16  -2.31115321456840E-23
      6.56879477778725E-11   6.56882756182797E-11  -1.30956370185626E-18  -7.69836857174734E-03  -7.69836857177547E-03
      0.00000000000000E+00   0.00000000000000E+00   2.81235433831751E-11   0.00000000000000E+00   2.81235433831751E-11
      5.23878573431132E-18  -3.04560780434399E-01  -3.04531226092096E-01   0.00000000000000E+00  -4.93296855085300E-13
     -1.22171905772039E-22  -9.33185221462478E-11  -9.38118190014553E-11  -3.92922203245506E-18
      6.07940032453079E-07
      0.00000000000000E+00  -7.32002555543988E-14   0.00000000000000E+00   2.95102493659277E-16  -1.08159836874223E-23
      7.31863928820881E-11   7.31866879845710E-11  -1.30654444910278E-18  -7.56929872661743E-03  -7.56929872664341E-03
      0.00000000000000E+00   0.00000000000000E+00   2.59755326499750E-11   0.00000000000000E+00   2.59755326499750E-11
      5.29073679961127E-18  -3.29445312238443E-01  -3.29414072597042E-01   0.00000000000000E+00  -5.10481550752116E-13
     -1.24588232581744E-22  -9.86517390836682E-11  -9.91622206345449E-11  -3.98419235050849E-18
      6.09940032453079E-07
      0.00000000000000E+00  -8.04559897937934E-14   0.00000000000000E+00   2.73039382304598E-16   4.38121333612929E-24
      8.04264222875345E-11   8.04266953269212E-11  -1.30371203769599E-18  -7.46483184603832E-03  -7.46483184606258E-03
      0.00000000000000E+00   0.00000000000000E+00   2.42574000679662E-11   0.00000000000000E+00   2.42574000679662E-11
      5.33925159974720E-18  -3.53804296587102E-01  -3.53771317661395E-01   0.00000000000000E+00  -5.29567357357791E-13
     -1.27035765754054E-22  -1.04154528037403E-10  -1.04684095394888E-10  -4.03553956205122E-18
      6.11940032453079E-07
      0.00000000000000E+00  -8.75280345587730E-14   0.00000000000000E+00   2.61054854094602E-16   2.10716235483608E-23
      8.75541752099286E-11   8.75544362648038E-11  -1.30102943093537E-18  -7.39802270553727E-03  -7.39802270556004E-03
      0.00000000000000E+00   0.00000000000000E+00   2.27662868976033E-11   0.00000000000000E+00   2.27662868976033E-11
      5.38478417354241E-18  -3.77626504839154E-01  -3.77591750516815E-01   0.00000000000000E+00  -5.50313013020266E-13
     -1.29518954395085E-22  -1.09770410149257E-10  -1.10320723162407E-10  -4.08375474260705E-18
      6.13940032453079E-07
      0.00000000000000E+00  -9.46000793237526E-14   0.00000000000000E+00   2.51670983918566E-16   3.80492513381405E-23
      9.45914033910042E-11   9.45916550620262E-11  -1.29849777051924E-18  -7.35502346746330E-03  -7.35502346748482E-03
      0.00000000000000E+00   0.00000000000000E+00   2.15177866641195E-11   0.00000000000000E+00   2.15177866641195E-11
      5.42781974687065E-18  -4.00984746403367E-01  -4.00948168811137E-01   0.00000000000000E+00  -5.76702565042940E-13
     -1.32057801865094E-22  -1.15532739160970E-10  -1.16109441726145E-10  -4.12932197635141E-18
      6.15940032453079E-07
      0.00000000000000E+00  -1.01580279351525E-13   0.00000000000000E+00   2.44335385115661E-16   5.43897539175379E-23
      1.01571564860640E-10   1.01571809196079E-10  -1.29611336767529E-18  -7.32329260420482E-03  -7.32329260422530E-03
      0.00000000000000E+00   0.00000000000000E+00   2.04866221298735E-11   0.00000000000000E+00   2.04866221298735E-11
      5.46879299113040E-18  -4.24001234707496E-01  -4.23962783400683E-01   0.00000000000000E+00  -6.11097860285533E-13
     -1.34678314903674E-22  -1.21447333465533E-10  -1.22058431325953E-10  -4.17267962345511E-18
      6.16940032453079E-07
      0.00000000000000E+00  -1.05070379365411E-13   0.00000000000000E+00   2.42305278252495E-16   6.25124777188756E-23
      1.05079269666874E-10   1.05079511972215E-10  -1.29495851941225E-18  -7.31004873615554E-03  -7.31004873617547E-03
      0.00000000000000E+00   0.00000000000000E+00   1.99296777382311E-11   0.00000000000000E+00   1.99296777382311E-11
      5.48872266886863E-18  -4.35412740395335E-01  -4.35373359724534E-01   0.00000000000000E+00  -6.37867038337095E-13
     -1.36016709169647E-22  -1.24371322671971E-10  -1.25009189710444E-10  -4.19376414945638E-18
      6.18290032453079E-07
      0.00000000000000E+00  -1.09754460962994E-13   0.00000000000000E+00   2.37496138300429E-16   7.25196523407238E-23
      1.09767241178621E-10   1.09767478674832E-10  -1.29346002641561E-18  -7.29709591891647E-03  -7.29709591893571E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92431126112329E-11   0.00000000000000E+00   1.92431126112329E-11
      5.51470087089379E-18  -4.50619376912218E-01  -4.50578735999650E-01   0.00000000000000E+00  -6.59954518366784E-13
     -1.37853227567881E-22  -1.28350636767561E-10  -1.29010591286065E-10  -4.22124084447819E-18
      6.20112532453079E-07
      0.00000000000000E+00  -1.15999903093106E-13   0.00000000000000E+00   2.32301378653099E-16   8.41770100153610E-23
      1.16024972812182E-10   1.16025205113645E-10  -1.29153118768671E-18  -7.29017787892908E-03  -7.29017787894744E-03
      0.00000000000000E+00   0.00000000000000E+00   1.83590828085844E-11   0.00000000000000E+00   1.83590828085844E-11
      5.54816029931244E-18  -4.70773637720375E-01  -4.70731304406749E-01   0.00000000000000E+00  -6.90373006874751E-13
     -1.40378983730680E-22  -1.33693914915214E-10  -1.34384287922229E-10  -4.25662911162572E-18
      6.22112532453079E-07
      0.00000000000000E+00  -1.22888258383671E-13   0.00000000000000E+00   2.28523032788569E-16   9.48905719017832E-23
      1.22848641712695E-10   1.22848870235823E-10  -1.28950575068952E-18  -7.29918408975780E-03  -7.29918408977522E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74165947360107E-11   0.00000000000000E+00   1.74165947360107E-11
      5.58299348878446E-18  -4.92441705054654E-01  -4.92397519572638E-01   0.00000000000000E+00  -7.28214607605065E-13
     -1.43200313695563E-22  -1.39537250364085E-10  -1.40265464971833E-10  -4.29348773809494E-18
      6.24112532453079E-07
      0.00000000000000E+00  -1.29684768937028E-13   0.00000000000000E+00   2.27005886406010E-16   1.03719530605839E-22
      1.29674942581251E-10   1.29675169587241E-10  -1.28754219379613E-18  -7.33258472423220E-03  -7.33258472424870E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64988820878825E-11   0.00000000000000E+00   1.64988820878825E-11
      5.61599125296023E-18  -5.13668426125318E-01  -5.13622379906355E-01   0.00000000000000E+00  -7.68572552825868E-13
     -1.46056372359613E-22  -1.45405479122152E-10  -1.46174051675124E-10  -4.32844905916410E-18
      6.26112532453079E-07
      0.00000000000000E+00  -1.36756813702007E-13   0.00000000000000E+00   2.35626646774702E-16   1.11049040317679E-22
      1.36730404743106E-10   1.36730640369864E-10  -1.28553019858058E-18  -7.43584797443892E-03  -7.43584797445448E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55512103145471E-11   0.00000000000000E+00   1.55512103145471E-11
      5.64709367358932E-18  -5.34462882458006E-01  -5.34414912821100E-01   0.00000000000000E+00  -8.06838763009838E-13
     -1.48920275145931E-22  -1.51475011921252E-10  -1.52281850684411E-10  -4.36156347500874E-18
      6.28112532453080E-07
      0.00000000000000E+00  -1.44747305839062E-13   0.00000000000000E+00   2.75743147270227E-16   1.17603115051846E-22
      1.44750606606210E-10   1.44750882349475E-10  -1.28314161873418E-18  -7.75315364872553E-03  -7.75315364873993E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44013505733711E-11   0.00000000000000E+00   1.44013505733711E-11
      5.67589637473606E-18  -5.54833149055373E-01  -5.54783015866347E-01   0.00000000000000E+00  -8.36522262871439E-13
     -1.51748198991600E-22  -1.58315710659823E-10  -1.59152232922846E-10  -4.39275475600188E-18
      6.30112532453080E-07
      0.00000000000000E+00  -1.56595276938833E-13   0.00000000000000E+00   4.35104551329785E-16   1.25270465384105E-22
      1.56576172250881E-10   1.56576607355557E-10  -1.27920911254748E-18  -8.80955624898058E-03  -8.80955624899294E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23625918539924E-11   0.00000000000000E+00   1.23625918539924E-11
      5.70062155844404E-18  -5.74782930316696E-01  -5.74729714964700E-01   0.00000000000000E+00  -8.36473523427059E-13
     -1.54439898036529E-22  -1.68102725685969E-10  -1.68939199209551E-10  -4.42141244589656E-18
      6.32112532453080E-07
      0.00000000000000E+00  -2.00129682375201E-13   0.00000000000000E+00   1.67662330422396E-15   1.49403207550149E-22
      2.00083409204485E-10   2.00085085827938E-10  -1.26389142377238E-18  -1.50841970030875E-02  -1.50841970030897E-02
      0.00000000000000E+00   0.00000000000000E+00   2.26834082319729E-12   0.00000000000000E+00   2.26834082319729E-12
      5.70515824009044E-18  -5.94275576413544E-01  -5.94211836755151E-01   0.00000000000000E+00  -6.02161146505490E-13
     -1.56297434778948E-22  -2.01751265504473E-10  -2.02353426651135E-10  -4.44126681631806E-18
      6.34112532453080E-07
      0.00000000000000E+00  -4.30292593817263E-13   0.00000000000000E+00   7.78486700910059E-15   2.41066540785288E-22
      4.30245953122453E-10   4.30253737989703E-10  -1.20487632571207E-18  -4.03653325673789E-02  -4.03653325673440E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.49297084536024E-11   0.00000000000000E+00  -3.49297084536024E-11
      5.63529882318324E-18  -6.13011484384278E-01  -6.12886961800474E-01   0.00000000000000E+00   3.36084841593353E-13
     -1.55259274499990E-22  -3.95660114377539E-10  -3.95324029536101E-10  -4.43042249747116E-18
      6.36112532453080E-07
      0.00000000000000E+00  -9.27631845796020E-13   0.00000000000000E+00   1.43167968465238E-14   3.19225276564634E-22
      9.27587108241613E-10   9.27601425038778E-10  -1.13107010028339E-18  -7.01186854348244E-02  -7.01186854347730E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.14225553639136E-11   0.00000000000000E+00  -5.14225553639136E-11
      5.53245371245541E-18  -6.30448352776149E-01  -6.30172364006179E-01   0.00000000000000E+00   5.02874311415031E-13
     -1.53669670963940E-22  -8.76681743986125E-10  -8.76178869674864E-10  -4.40138361217202E-18
      6.38112532453080E-07
      0.00000000000000E+00  -1.88327633644034E-12   0.00000000000000E+00   2.52906844246584E-14   3.66996791946807E-22
      1.88322641595938E-09   1.88325170664417E-09  -1.05779284583399E-18  -9.96781516620715E-02  -9.96781516620104E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.11620402012155E-11   0.00000000000000E+00  -6.11620402012155E-11
      5.41012963205298E-18  -6.45710779638421E-01  -6.45136832565899E-01   0.00000000000000E+00   4.31099903256748E-13
     -1.52249780667673E-22  -1.82252076634606E-09  -1.82208966644296E-09  -4.35233678621899E-18
      6.40112532453080E-07
      0.00000000000000E+00  -3.56807619577521E-12   0.00000000000000E+00   4.30284256717054E-14   4.02766030858370E-22
      3.56802684293649E-09   3.56806987136256E-09  -9.90275039293750E-19  -1.28755751689734E-01  -1.28755751689661E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28636483905506E-11   0.00000000000000E+00  -7.28636483905506E-11
      5.26440233527188E-18  -6.57432616630090E-01  -6.56331641294542E-01   0.00000000000000E+00   3.35770538389058E-13
     -1.51082278558116E-22  -3.49554199351025E-09  -3.49520622297201E-09  -4.27412729597813E-18
      6.42112532453080E-07
      0.00000000000000E+00  -6.24112542746307E-12   0.00000000000000E+00   6.72032970575589E-14   4.31126235800916E-22
      6.24102726681837E-09   6.24109447011586E-09  -9.30106850581650E-19  -1.57271845921816E-01  -1.57271845921729E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.75581736143145E-11   0.00000000000000E+00  -8.75581736143145E-11
      5.08928598804325E-18  -6.63774281990963E-01  -6.61835933841405E-01   0.00000000000000E+00   2.50583192758083E-13
     -1.50142442218073E-22  -6.15378687969416E-09  -6.15353629650155E-09  -4.15917913746160E-18
      6.42612532453080E-07
      0.00000000000000E+00  -7.12595762572038E-12   0.00000000000000E+00   8.84923501171122E-14   4.41966817294281E-22
      7.12589889867132E-09   7.12598739102188E-09  -9.15618091544899E-19  -1.64364290359079E-01  -1.64364290358987E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.26912618542546E-11   0.00000000000000E+00  -9.26912618542546E-11
      5.04294035711612E-18  -6.64919314395630E-01  -6.62703841433218E-01   0.00000000000000E+00   2.09242277016246E-13
     -1.49931772440671E-22  -7.03350537144449E-09  -7.03329612916763E-09  -4.12732226557122E-18
      6.43287532453080E-07
      0.00000000000000E+00  -8.43979659147405E-12   0.00000000000000E+00   9.71315039874574E-14   4.53132830095220E-22
      8.43964454766211E-09   8.43974167916655E-09  -8.96959262701021E-19  -1.73871786911370E-01  -1.73871786911271E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89794239192765E-11   0.00000000000000E+00  -9.89794239192765E-11
      4.97612924597061E-18  -6.65588541093456E-01  -6.62961214953944E-01   0.00000000000000E+00   1.89932049721472E-13
     -1.49664519646617E-22  -8.34095218729685E-09  -8.34076225524728E-09  -4.07916998326959E-18
      6.44198782453080E-07
      0.00000000000000E+00  -1.04328273888774E-11   0.00000000000000E+00   1.08975079346880E-13   4.61899531136635E-22
      1.04327612759247E-08   1.04328702510045E-08  -8.72998212450484E-19  -1.86584192832830E-01  -1.86584192832723E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06937378164877E-10   0.00000000000000E+00  -1.06937378164877E-10
      4.87868256011787E-18  -6.64712315895021E-01  -6.61459656751808E-01   0.00000000000000E+00   2.07485655705066E-13
     -1.49267226958452E-22  -1.03261403584952E-08  -1.03259328728397E-08  -4.00568434766738E-18
      6.45428969953080E-07
      0.00000000000000E+00  -1.35440678617823E-11   0.00000000000000E+00   1.25715652433491E-13   4.65627550991496E-22
      1.35439319970467E-08   1.35440577126996E-08  -8.42250460509062E-19  -2.03525005255588E-01  -2.03525005255471E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16223314962394E-10   0.00000000000000E+00  -1.16223314962394E-10
      4.73570609084257E-18  -6.59818044311379E-01  -6.55588270677947E-01   0.00000000000000E+00   3.23652096131160E-13
     -1.48464258551364E-22  -1.34281580498332E-08  -1.34278343977372E-08  -3.89345563033350E-18
      6.47089723078080E-07
      0.00000000000000E+00  -1.86004880240055E-11   0.00000000000000E+00   1.51237905846773E-13   4.61233398332887E-22
      1.86003084684707E-08   1.86004597063770E-08  -8.02620368596924E-19  -2.26001596525782E-01  -2.26001596525656E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25969759523462E-10   0.00000000000000E+00  -1.25969759523462E-10
      4.52650141905848E-18  -6.45167754868519E-01  -6.39348222382020E-01   0.00000000000000E+00   6.53927733840082E-13
     -1.46348895750536E-22  -1.84751438745872E-08  -1.84744899468535E-08  -3.72388105046155E-18
      6.49089723078080E-07
      0.00000000000000E+00  -2.62591451255296E-11   0.00000000000000E+00   1.90043255094152E-13   4.46704119493745E-22
      2.62589856043894E-08   2.62591756476450E-08  -7.56377498491792E-19  -2.52514208012612E-01  -2.52514208012478E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34579002361300E-10   0.00000000000000E+00  -1.34579002361300E-10
      4.25734341433588E-18  -6.13032111407444E-01  -6.04802582478661E-01   0.00000000000000E+00   1.25147032453143E-12
     -1.41325584492575E-22  -2.61258481156080E-08  -2.61245966452836E-08  -3.50096591584409E-18
      6.51089723078080E-07
      0.00000000000000E+00  -3.59633682141396E-11   0.00000000000000E+00   2.40783413853695E-13   4.22240625181968E-22
      3.59631089222357E-08   3.59633497056500E-08  -7.10734999913858E-19  -2.78483590587404E-01  -2.78483590587262E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41868073809254E-10   0.00000000000000E+00  -1.41868073809254E-10
      3.97360726671737E-18  -5.62697524262005E-01  -5.51412994875671E-01   0.00000000000000E+00   1.86549012132847E-12
     -1.33057352151062E-22  -3.58233471219619E-08  -3.58214816318407E-08  -3.26287226680351E-18
      6.53089723078080E-07
      0.00000000000000E+00  -4.76519886948555E-11   0.00000000000000E+00   2.90258893462820E-13   3.79849681490258E-22
      4.76517112795143E-08   4.76520015384081E-08  -6.65441550957513E-19  -3.03915753689205E-01  -3.03915753689054E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51083652946058E-10   0.00000000000000E+00  -1.51083652946058E-10
      3.67143996082525E-18  -4.90618674153588E-01  -4.75654277512862E-01   0.00000000000000E+00   2.16659411320450E-12
     -1.22077153413532E-22  -4.75030844795751E-08  -4.75009178854621E-08  -3.00599840986774E-18
      6.55089723078080E-07
      0.00000000000000E+00  -6.04410009720548E-11   0.00000000000000E+00   3.18074504269116E-13   3.07718165925750E-22
      6.04406825830764E-08   6.04410006575810E-08  -6.20656923354213E-19  -3.28813849489664E-01  -3.28813849489500E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63791345905553E-10   0.00000000000000E+00  -1.63791345905553E-10
      3.34385726901415E-18  -3.94971667516760E-01  -3.75981579029167E-01   0.00000000000000E+00   2.02695773463038E-12
     -1.10159069341342E-22  -6.02792362694099E-08  -6.02772093116754E-08  -2.72320034565993E-18
      6.57089723078080E-07
      0.00000000000000E+00  -7.24029513907003E-11   0.00000000000000E+00   2.98107979642754E-13   2.39921342732292E-22
      7.24026454408450E-08   7.24029435488248E-08  -5.76407880369055E-19  -3.53186328598920E-01  -3.53186328598742E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77356214516038E-10   0.00000000000000E+00  -1.77356214516038E-10
      2.98914483998207E-18  -2.77783103278071E-01  -2.55027957413368E-01   0.00000000000000E+00   1.66521044790508E-12
     -9.65110796106268E-23  -7.22272525447566E-08  -7.22255873343088E-08  -2.41273695961301E-18
      6.59089723078080E-07
      0.00000000000000E+00  -7.84542337463554E-11   0.00000000000000E+00   1.51259344143535E-13   1.54416939965130E-22
      7.84540378218183E-08   7.84541890811627E-08  -5.33344666798467E-19  -3.77022336162112E-01  -3.77022336161910E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.01597913521397E-10   0.00000000000000E+00  -2.01597913521397E-10
      2.58594901293927E-18  -1.51039197278746E-01  -1.26384651669367E-01   0.00000000000000E+00   1.03614517325097E-12
     -8.23673986444399E-23  -7.82536273128144E-08  -7.82525911676412E-08  -2.05260434614081E-18
      6.60089723078080E-07
      0.00000000000000E+00  -7.43517130247696E-11   0.00000000000000E+00  -2.03980108081064E-13   9.11092397984018E-23
      7.43519290323841E-08   7.43517250522761E-08  -5.11677916027671E-19  -3.88801983796889E-01  -3.88801983796670E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19324972124882E-10   0.00000000000000E+00  -2.19324972124882E-10
      2.36662404081439E-18  -9.23226841024140E-02  -6.89661104238661E-02   0.00000000000000E+00   8.46201862025335E-13
     -6.73665328788944E-23  -7.41332462820131E-08  -7.41324000801512E-08  -1.85494612478672E-18
      6.61439723078080E-07
      0.00000000000000E+00  -5.19818251410300E-11   0.00000000000000E+00  -8.23347075187041E-13   3.39529442576631E-23
      5.19826153987532E-08   5.19817920516781E-08  -4.76427268516611E-19  -4.04543192916649E-01  -4.04543192916471E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77397033137231E-10   0.00000000000000E+00  -1.77397033137231E-10
      2.12713804607913E-18  -4.37116883464597E-02  -2.73898344274718E-02   0.00000000000000E+00   1.10838914442257E-12
     -3.17838842500192E-23  -5.18055034076853E-08  -5.18043950185409E-08  -1.65071077756252E-18
      6.63262223078080E-07
      0.00000000000000E+00  -2.91573058081131E-11   0.00000000000000E+00  -6.19816669615809E-13   1.20462932650004E-23
      2.91579604269380E-08   2.91573406102684E-08  -4.23716594664708E-19  -4.25505131961135E-01  -4.25505131961015E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20738611700505E-10   0.00000000000000E+00  -1.20738611700505E-10
      1.90709192625496E-18  -1.98304561348182E-02  -1.06819619508280E-02   0.00000000000000E+00   7.23495966255582E-13
     -1.26671779887516E-23  -2.90373254945341E-08  -2.90366019985679E-08  -1.48337533159025E-18
      6.65262223078080E-07
      0.00000000000000E+00  -1.99521670214887E-11   0.00000000000000E+00  -2.26974997325868E-13   6.20478979915102E-24
      1.99523740376071E-08   1.99521470626098E-08  -3.67364393084160E-19  -4.48083318877066E-01  -4.48083318876964E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01702805995723E-10   0.00000000000000E+00  -1.01702805995723E-10
      1.70368631426351E-18  -1.20518961425207E-02  -5.79765517489008E-03   0.00000000000000E+00   2.82881340712823E-13
     -6.86752134942395E-24  -1.98507271379548E-08  -1.98504442566141E-08  -1.33632192117935E-18
      6.67262223078080E-07
      0.00000000000000E+00  -1.72580853449803E-11   0.00000000000000E+00  -6.61130676998855E-14   4.42760385189791E-24
      1.72581610334846E-08   1.72580949204169E-08  -3.13559645871753E-19  -4.70211696228387E-01  -4.70211696228288E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94463272366234E-11   0.00000000000000E+00  -9.94463272366234E-11
      1.50479365979027E-18  -9.65949999046627E-03  -4.25335292408160E-03   0.00000000000000E+00   1.07810295020443E-13
     -4.93044757693818E-24  -1.71587564034753E-08  -1.71586485931803E-08  -1.19123401391852E-18
      6.69262223078080E-07
      0.00000000000000E+00  -1.65111120972715E-11   0.00000000000000E+00  -1.80922893935964E-14   3.66365016585597E-24
      1.65111105439557E-08   1.65110924516663E-08  -2.62286389236663E-19  -4.91891004561168E-01  -4.91891004561066E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01313872050729E-10   0.00000000000000E+00  -1.01313872050729E-10
      1.30216591568881E-18  -8.75842804133918E-03  -3.58822240498390E-03   0.00000000000000E+00   5.31344277752019E-14
     -4.03535580246241E-24  -1.64098317140433E-08  -1.64097785796156E-08  -1.03987952645215E-18
      6.71262223078080E-07
      0.00000000000000E+00  -1.62864598700619E-11   0.00000000000000E+00  -5.23739292301933E-15   3.22159624636108E-24
      1.62864367480289E-08   1.62864315106359E-08  -2.13474786895616E-19  -5.13128889017514E-01  -5.13128889017410E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03741262151766E-10   0.00000000000000E+00  -1.03741262151766E-10
      1.09468339138528E-18  -8.30536043767443E-03  -3.20670001279081E-03   0.00000000000000E+00   3.58796796846246E-14
     -3.48799444505595E-24  -1.61827261281639E-08  -1.61826902484842E-08  -8.81208604489661E-19
      6.73262223078080E-07
      0.00000000000000E+00  -1.62024219355170E-11   0.00000000000000E+00  -2.65734935750232E-15   2.91863248176538E-24
      1.62024211349858E-08   1.62024184776364E-08  -1.67019664702545E-19  -5.33934312592178E-01  -5.33934312592073E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05818699962664E-10   0.00000000000000E+00  -1.05818699962664E-10
      8.83045991459949E-19  -8.01988023100493E-03  -2.94834126858021E-03   0.00000000000000E+00   2.99511536485228E-14
     -3.10061129871658E-24  -1.60966297288274E-08  -1.60965997776738E-08  -7.16026326757403E-19
      6.75262223078080E-07
      0.00000000000000E+00  -1.61612754932480E-11   0.00000000000000E+00  -7.65007808070546E-16   2.69286793337555E-24
      1.61612473596452E-08   1.61612465946374E-08  -1.22777852548995E-19  -5.54315364035988E-01  -5.54315364035880E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07351702018314E-10   0.00000000000000E+00  -1.07351702018314E-10
      6.68342587423321E-19  -7.81657147595179E-03  -2.75848591099487E-03   0.00000000000000E+00   2.53786331047590E-14
     -2.80770162106564E-24  -1.60539202712522E-08  -1.60538948926191E-08  -5.45564734874327E-19
      6.77262223078080E-07
      0.00000000000000E+00  -1.61365692589392E-11   0.00000000000000E+00  -3.78986547022692E-16   2.51666593959071E-24
      1.61365667983609E-08   1.61365664193744E-08  -8.05920365191395E-20  -5.74275976272242E-01  -5.74275976272134E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08323487119782E-10   0.00000000000000E+00  -1.08323487119782E-10
      4.51695613183759E-19  -7.66225661731655E-03  -2.61225135360881E-03   0.00000000000000E+00   2.28022170704446E-14
     -2.57800326626503E-24  -1.60282657344716E-08  -1.60282429322546E-08  -3.71103576664619E-19
      6.79262223078080E-07
      0.00000000000000E+00  -1.61197616720302E-11   0.00000000000000E+00  -2.01614223039967E-16   2.37498198719491E-24
      1.61198069471381E-08   1.61198067455239E-08  -4.03767418297063E-20  -5.93782237867443E-01  -5.93782237867334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08578651189400E-10   0.00000000000000E+00  -1.08578651189400E-10
      2.34538310804958E-19  -7.54025569112826E-03  -2.49560965197369E-03   0.00000000000000E+00   2.07680492858404E-14
     -2.39338312062102E-24  -1.60112488623838E-08  -1.60112280943345E-08  -1.94161568975251E-19
      6.81262223078080E-07
      0.00000000000000E+00  -1.61059849614491E-11   0.00000000000000E+00  -1.47004897607483E-16   2.25952102928361E-24
      1.61059526987532E-08   1.61059525517484E-08  -2.56113460735774E-21  -6.12542536735285E-01  -6.12542536735179E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06692126072155E-10   0.00000000000000E+00  -1.06692126072155E-10
      2.11540586606482E-20  -7.44082742589869E-03  -2.39995070677703E-03   0.00000000000000E+00   1.88104186141780E-14
     -2.24370021333224E-24  -1.59992792360948E-08  -1.59992604256762E-08  -1.85929240532907E-20
      6.83262223078081E-07
      0.00000000000000E+00  -1.60776049376520E-11   0.00000000000000E+00  -5.26653166448599E-16   2.17848862410152E-24
      1.60775965077969E-08   1.60775959811437E-08   3.19972466592022E-20  -6.30020244583738E-01  -6.30020244583637E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01100296464256E-10   0.00000000000000E+00  -1.01100296464256E-10
     -1.81046534267865E-19  -7.38508601724327E-03  -2.35138069513053E-03   0.00000000000000E+00   1.69602285573046E-14
     -2.14095171626444E-24  -1.59765126449080E-08  -1.59764956846794E-08   1.49049287608662E-19
      6.85262223078081E-07
      0.00000000000000E+00  -1.60573990954663E-11   0.00000000000000E+00  -3.50977106549166E-16   2.11537694246883E-24
      1.60574439510838E-08   1.60574436001067E-08   6.18076887229899E-20  -6.45350433954608E-01  -6.45350433954518E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.99575125497669E-11   0.00000000000000E+00  -8.99575125497669E-11
     -3.60961559367398E-19  -7.34577730655412E-03  -2.31490972440962E-03   0.00000000000000E+00   1.40608531745703E-14
     -2.06171742734360E-24  -1.59675001484101E-08  -1.59674860875570E-08   2.99153870644408E-19
      6.87262223078081E-07
      0.00000000000000E+00  -1.60317744137854E-11   0.00000000000000E+00  -5.23558345615368E-16   2.06899235809442E-24
      1.60317783105080E-08   1.60317777869497E-08   8.45157781580606E-20  -6.57179500578158E-01  -6.57179500578087E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.01688691503866E-11   0.00000000000000E+00  -7.01688691503866E-11
     -5.01299297668172E-19  -7.31674427819662E-03  -2.28772773434986E-03   0.00000000000000E+00   1.05133718715907E-14
     -2.00513856112079E-24  -1.59616194311711E-08  -1.59616089177993E-08   4.16783519510112E-19
      6.89262223078081E-07
      0.00000000000000E+00  -1.59943017610047E-11   0.00000000000000E+00  -8.66497666899072E-16   2.04190705287584E-24
      1.59942602468614E-08   1.59942593803637E-08   9.68904648129319E-20  -6.63677903030992E-01  -6.63677903030953E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.88191980464483E-11   0.00000000000000E+00  -3.88191980464483E-11
     -5.78937693761068E-19  -7.29838294143030E-03  -2.27130961019839E-03   0.00000000000000E+00   5.74345677699664E-15
     -1.97502875494390E-24  -1.59554459257740E-08  -1.59554401823173E-08   4.82047228948137E-19
      6.89762223078081E-07
      0.00000000000000E+00  -1.59822701004306E-11   0.00000000000000E+00  -1.13784079500765E-15   2.03642936956261E-24
      1.59822957211026E-08   1.59822945832618E-08   9.91452966850080E-20  -6.64865695826629E-01  -6.64865695826601E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84683390422781E-11   0.00000000000000E+00  -2.84683390422781E-11
     -5.93171863282207E-19  -7.29446416198788E-03  -2.26789926614985E-03   0.00000000000000E+00   4.21754962008273E-15
     -1.96953269273471E-24  -1.59538304617691E-08  -1.59538262442195E-08   4.94026566597200E-19
      6.90437223078081E-07
      0.00000000000000E+00  -1.59644522214123E-11   0.00000000000000E+00  -2.53579887125081E-15   2.03179976851853E-24
      1.59644229385150E-08   1.59644204027161E-08   1.00537821120662E-19  -6.65599262536630E-01  -6.65599262536617E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30470859167894E-11   0.00000000000000E+00  -1.30470859167894E-11
     -6.01978646276041E-19  -7.29061806409093E-03  -2.26482557461929E-03   0.00000000000000E+00   3.28351828192776E-15
     -1.96584304411834E-24  -1.59513766003176E-08  -1.59513733167993E-08   5.01440825155379E-19
      6.91348473078081E-07
      0.00000000000000E+00  -1.59374498686733E-11   0.00000000000000E+00  -4.95130984456721E-15   2.03109442520944E-24
      1.59374592885162E-08   1.59374543372063E-08   9.90676988070185E-20  -6.64822246265414E-01  -6.64822246265425E-01
      0.00000000000000E+00   0.00000000000000E+00   1.01882496756584E-11   0.00000000000000E+00   1.01882496756584E-11
     -5.92694603759097E-19  -7.28842615364401E-03  -2.26380844104356E-03   0.00000000000000E+00   2.22973997876276E-15
     -1.96849727624854E-24  -1.59476448166220E-08  -1.59476425868820E-08   4.93626904952078E-19
      6.92578660578081E-07
      0.00000000000000E+00  -1.58958442027183E-11   0.00000000000000E+00  -7.18536778287065E-14   2.04192393153541E-24
      1.58957692975219E-08   1.58956974438441E-08   9.00716469247049E-20  -6.60085770210666E-01  -6.60085770210712E-01
      0.00000000000000E+00   0.00000000000000E+00   4.60113781542952E-11   0.00000000000000E+00   4.60113781542952E-11
     -5.36091981495909E-19  -7.29191373235040E-03  -2.26914483041729E-03   0.00000000000000E+00   6.37573359231062E-14
     -1.98841441423744E-24  -1.59417725793343E-08  -1.59417088219984E-08   4.46020334571205E-19
      6.94239413703081E-07
      0.00000000000000E+00  -1.58287975445568E-11   0.00000000000000E+00  -2.15084697762182E-15   2.08427879810741E-24
      1.58287870858830E-08   1.58287849350360E-08   6.25025938683101E-20  -6.45697666878336E-01  -6.45697666878439E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02850852313289E-10   0.00000000000000E+00   1.02850852313289E-10
     -3.65282107107701E-19  -7.31187259371653E-03  -2.29230029420595E-03   0.00000000000000E+00  -1.48241319527001E-14
     -2.05446280053079E-24  -1.59316209632174E-08  -1.59316357873493E-08   3.02779513239391E-19
      6.96239413703081E-07
      0.00000000000000E+00  -1.57290541599494E-11   0.00000000000000E+00  -3.12430941551637E-15   2.19648688226876E-24
      1.57289696070460E-08   1.57289664827366E-08   3.10890120977667E-22  -6.13962539221583E-01  -6.13962539221768E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84878551007485E-10   0.00000000000000E+00   1.84878551007485E-10
      4.47499490726804E-21  -7.36858918259840E-03  -2.35462397712856E-03   0.00000000000000E+00  -2.83730017816960E-14
     -2.22477282124470E-24  -1.59138166607423E-08  -1.59138450337441E-08  -4.78588502824569E-21
      6.98239413703081E-07
      0.00000000000000E+00  -1.55469260460669E-11   0.00000000000000E+00  -1.28121713688510E-14   2.48753683204600E-24
      1.55468745550070E-08   1.55468617428356E-08  -1.01845638190585E-19  -5.64122478039893E-01  -5.64122478040171E-01
      0.00000000000000E+00   0.00000000000000E+00   2.78787654733668E-10   0.00000000000000E+00   2.78787654733668E-10
      5.62050304374604E-19  -7.59499126139061E-03  -2.60881533572421E-03   0.00000000000000E+00  -4.13134424445034E-14
     -2.68015988913640E-24  -1.58256080841269E-08  -1.58256493975693E-08  -4.60204666184019E-19
      7.00239413703081E-07
      0.00000000000000E+00  -1.52351131632473E-11   0.00000000000000E+00  -8.63081424635140E-15   3.22026068757730E-24
      1.52350767268328E-08   1.52350680960186E-08  -2.60462307828317E-19  -4.92611615596190E-01  -4.92611615596556E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65912106646625E-10   0.00000000000000E+00   3.65912106646625E-10
      1.29387451766785E-18  -8.25454564957836E-03  -3.33916665726380E-03   0.00000000000000E+00  -8.57279805503782E-14
     -4.04991380774598E-24  -1.56008944746846E-08  -1.56009802026652E-08  -1.03341220983954E-18
      7.02239413703081E-07
      0.00000000000000E+00  -1.39074974869125E-11   0.00000000000000E+00  -3.72593270325081E-14   5.30720961310699E-24
      1.39075475276729E-08   1.39075102683459E-08  -4.91896893721947E-19  -3.97546672093593E-01  -3.97546672093997E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03305760625986E-10   0.00000000000000E+00   4.03305760625986E-10
      2.10048603891982E-18  -1.14207325395303E-02  -6.91186119485000E-03   0.00000000000000E+00  -1.52312240067424E-13
     -1.23920754646347E-23  -1.43106637167318E-08  -1.43108160289719E-08  -1.60858914519788E-18
      7.04239413703081E-07
      0.00000000000000E+00  -5.65304357512327E-12   0.00000000000000E+00  -2.42603730430958E-13  -7.53304635966862E-24
      5.65322240720742E-09   5.65297980347698E-09  -7.62060844898281E-19  -2.80797380206277E-01  -2.80797380206686E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08711914461426E-10   0.00000000000000E+00   4.08711914461426E-10
      2.91790986784268E-18  -3.06397097708945E-02  -2.87298766153129E-02   0.00000000000000E+00  -2.33833155398190E-13
     -6.64576835240596E-23  -6.06145788478295E-09  -6.06169171793842E-09  -2.15584902294440E-18
      7.06239413703081E-07
      0.00000000000000E+00  -2.58542935239188E-13   0.00000000000000E+00  -1.39350400713992E-13  -4.13976019701481E-23
      2.58721597195246E-10   2.58582246794490E-10  -1.02602506585930E-18  -1.54048513072891E-01  -1.54048513073283E-01
      0.00000000000000E+00   0.00000000000000E+00   3.92231458863697E-10   0.00000000000000E+00   3.92231458863697E-10
      3.70237278557007E-18  -6.00419829856810E-02  -5.98369373885713E-02   0.00000000000000E+00  -8.28737005359644E-13
     -8.93734862151662E-23  -6.49984968652739E-10  -6.50813705658188E-10  -2.67634771971077E-18
      7.07239413703081E-07
      0.00000000000000E+00   5.04227607269322E-14   0.00000000000000E+00  -2.34790616973932E-14  -4.48248644457812E-23
     -5.03972371796775E-11  -5.04207162414197E-11  -1.14426372305212E-18  -9.48253775830963E-02  -9.48253775834384E-02
      0.00000000000000E+00   0.00000000000000E+00   3.42075747448978E-10   0.00000000000000E+00   3.42075747448978E-10
      4.04444853301905E-18  -7.49470757634865E-02  -7.48551866849324E-02   0.00000000000000E+00  -1.35535678810480E-12
     -9.58498487975727E-23  -2.90299674419358E-10  -2.91655031207559E-10  -2.90018480996693E-18
      7.08589413703081E-07
      0.00000000000000E+00   7.17307397590784E-14   0.00000000000000E+00  -6.41731030930568E-15  -4.60617276930008E-23
     -7.17129380381590E-11  -7.17193553485144E-11  -1.24388733684225E-18  -4.49234576749158E-02  -4.49234576751533E-02
      0.00000000000000E+00   0.00000000000000E+00   2.37520893263008E-10   0.00000000000000E+00   2.37520893263008E-10
      4.36510173892411E-18  -9.49596786098693E-02  -9.49074411625380E-02   0.00000000000000E+00  -1.15125019937756E-12
     -1.02018671646019E-22  -1.64650287715014E-10  -1.65801537914493E-10  -3.12121440208186E-18
      7.10411913703081E-07
      0.00000000000000E+00   2.87474027459559E-14   0.00000000000000E+00  -3.34705369469356E-16  -4.64144650675946E-23
     -2.87030817550212E-11  -2.87034164604370E-11  -1.29630445868664E-18  -2.02169118352039E-02  -2.02169118353373E-02
      0.00000000000000E+00   0.00000000000000E+00   1.33446064161384E-10   0.00000000000000E+00   1.33446064161384E-10
      4.60830719085823E-18  -1.21584618536339E-01  -1.21551618649183E-01   0.00000000000000E+00  -6.65832708738899E-13
     -1.06010618695832E-22  -1.04076814992102E-10  -1.04742647700947E-10  -3.31200273217160E-18
      7.12411913703081E-07
      0.00000000000000E+00  -1.83689474415054E-16   0.00000000000000E+00   8.88758783394935E-16  -4.62801941641279E-23
      2.14071788707313E-13   2.14960547444428E-13  -1.31504337603989E-18  -1.21627793414316E-02  -1.21627793415141E-02
      0.00000000000000E+00   0.00000000000000E+00   8.25606830537327E-11   0.00000000000000E+00   8.25606830537327E-11
      4.77342855696570E-18  -1.50245841368319E-01  -1.50219762608721E-01   0.00000000000000E+00  -4.51923786370426E-13
     -1.08696768943065E-22  -8.23237198146974E-11  -8.27756436011765E-11  -3.45838518092580E-18
      7.14411913703081E-07
      0.00000000000000E+00  -1.80015684926752E-14   0.00000000000000E+00   9.02184138349726E-16  -4.57435078953102E-23
      1.79689038447277E-11   1.79698060288204E-11  -1.32011624562963E-18  -9.69548284860552E-03  -9.69548284866499E-03
      0.00000000000000E+00   0.00000000000000E+00   5.94706964561462E-11   0.00000000000000E+00   5.94706964561462E-11
      4.89236994987799E-18  -1.78324607672757E-01  -1.78300209965989E-01   0.00000000000000E+00  -4.12025227566489E-13
     -1.11012987354483E-22  -7.70284772572896E-11  -7.74405024849671E-11  -3.57225370424836E-18
      7.16411913703081E-07
      0.00000000000000E+00  -3.09516764389365E-14   0.00000000000000E+00   7.20365487038874E-16  -4.44966004691803E-23
      3.09404672471773E-11   3.09411876126199E-11  -1.32008642280068E-18  -8.77371887179461E-03  -8.77371887184169E-03
      0.00000000000000E+00   0.00000000000000E+00   4.70734220433735E-11   0.00000000000000E+00   4.70734220433735E-11
      4.98651679396474E-18  -2.05822368199802E-01  -2.05797789804550E-01   0.00000000000000E+00  -4.23036129390899E-13
     -1.13298048271460E-22  -7.75915735264887E-11  -7.80146096559929E-11  -3.66643037116406E-18
      7.18411913703081E-07
      0.00000000000000E+00  -4.16056659550096E-14   0.00000000000000E+00   5.59955237624687E-16  -4.19765044224142E-23
      4.15699297165185E-11   4.15704896717141E-11  -1.31800673016946E-18  -8.31398481845111E-03  -8.31398481849048E-03
      0.00000000000000E+00   0.00000000000000E+00   3.93704513518304E-11   0.00000000000000E+00   3.93704513518304E-11
      5.06525769666840E-18  -2.32751779213741E-01  -2.32726279081789E-01   0.00000000000000E+00  -4.43048092822792E-13
     -1.15613842059169E-22  -8.04978929306068E-11  -8.09409410235452E-11  -3.74725096649894E-18
      7.20411913703081E-07
      0.00000000000000E+00  -5.08819844129698E-14   0.00000000000000E+00   4.48098074965161E-16  -3.77267269079280E-23
      5.08652736807835E-11   5.08657217788208E-11  -1.31512153297500E-18  -8.02569631196421E-03  -8.02569631199838E-03
      0.00000000000000E+00   0.00000000000000E+00   3.41703065491515E-11   0.00000000000000E+00   3.41703065491515E-11
      5.13359830976670E-18  -2.59127766508175E-01  -2.59100976458418E-01   0.00000000000000E+00  -4.62200188878778E-13
     -1.17959900933067E-22  -8.45738281389751E-11  -8.50360283279719E-11  -3.81847677679170E-18
      7.22411913703081E-07
      0.00000000000000E+00  -5.93317002360623E-14   0.00000000000000E+00   3.74211170557040E-16  -3.09961015449894E-23
      5.93129957923498E-11   5.93133700034894E-11  -1.31199535308464E-18  -7.82086318182587E-03  -7.82086318185636E-03
      0.00000000000000E+00   0.00000000000000E+00   3.04863141343261E-11   0.00000000000000E+00   3.04863141343261E-11
      5.19457093803535E-18  -2.84961818107963E-01  -2.84933527546851E-01   0.00000000000000E+00  -4.79637301697273E-13
     -1.20331448550322E-22  -8.93200468359976E-11  -8.97996841378152E-11  -3.88257558495071E-18
      7.24411913703081E-07
      0.00000000000000E+00  -6.72303476359096E-14   0.00000000000000E+00   3.25619407758419E-16  -2.13258308158408E-23
      6.71918088836121E-11   6.71921345029985E-11  -1.30889116137448E-18  -7.66558672201773E-03  -7.66558672204550E-03
      0.00000000000000E+00   0.00000000000000E+00   2.77683137532496E-11   0.00000000000000E+00   2.77683137532496E-11
      5.25010756554185E-18  -3.10258824328861E-01  -3.10228908185255E-01   0.00000000000000E+00  -4.96472521283063E-13
     -1.22725756236309E-22  -9.44639757348424E-11  -9.49604482562482E-11  -3.94121640416738E-18
      7.26411913703081E-07
      0.00000000000000E+00  -7.46697713497193E-14   0.00000000000000E+00   2.93422218714016E-16  -8.50916693914888E-24
      7.46876968176699E-11   7.46879902398801E-11  -1.30592414789193E-18  -7.54293092141505E-03  -7.54293092144073E-03
      0.00000000000000E+00   0.00000000000000E+00   2.56774456283151E-11   0.00000000000000E+00   2.56774456283151E-11
      5.30146245679848E-18  -3.35023984275895E-01  -3.34992365644257E-01   0.00000000000000E+00  -5.14156362725298E-13
     -1.25146274724947E-22  -9.98512795053453E-11  -1.00365435868196E-10  -3.99553830890656E-18
      7.28411913703081E-07
      0.00000000000000E+00  -8.19255055891139E-14   0.00000000000000E+00   2.71685459485449E-16   7.06409255137927E-24
      8.19266356648916E-11   8.19269073503582E-11  -1.30313552739262E-18  -7.44304916633036E-03  -7.44304916635435E-03
      0.00000000000000E+00   0.00000000000000E+00   2.39936873403624E-11   0.00000000000000E+00   2.39936873403624E-11
      5.34944983147921E-18  -3.59263103482891E-01  -3.59229735089562E-01   0.00000000000000E+00  -5.33877113999745E-13
     -1.27600439127857E-22  -1.05386717576593E-10  -1.05920594690720E-10  -4.04631430408659E-18
      7.30411913703081E-07
      0.00000000000000E+00  -8.90893950913009E-14   0.00000000000000E+00   2.61107378985197E-16   2.38886320151941E-23
      8.90768850284470E-11   8.90771461358499E-11  -1.30047638604892E-18  -7.38628620203241E-03  -7.38628620205492E-03
      0.00000000000000E+00   0.00000000000000E+00   2.25107144858156E-11   0.00000000000000E+00   2.25107144858156E-11
      5.39447126045084E-18  -3.82964921085342E-01  -3.82929767652598E-01   0.00000000000000E+00  -5.55160268421393E-13
     -1.30091772728313E-22  -1.11032700353114E-10  -1.11587860621666E-10  -4.09399487440192E-18
      7.32411913703081E-07
      0.00000000000000E+00  -9.61614398562805E-14   0.00000000000000E+00   2.50990264330081E-16   4.08402031838239E-23
      9.61206177480767E-11   9.61208687383819E-11  -1.29797203170577E-18  -7.34663065586643E-03  -7.34663065588774E-03
      0.00000000000000E+00   0.00000000000000E+00   2.13164931643242E-11   0.00000000000000E+00   2.13164931643242E-11
      5.43710424677949E-18  -4.06246741161868E-01  -4.06209745320076E-01   0.00000000000000E+00  -5.84011240752227E-13
     -1.32648044107539E-22  -1.16853350661820E-10  -1.17437361902705E-10  -4.13913221507372E-18
      7.34411913703081E-07
      0.00000000000000E+00  -1.03141639884053E-13   0.00000000000000E+00   2.43629390580605E-16   5.70117541815607E-23
      1.03104838241857E-10   1.03105081871305E-10  -1.29561319541767E-18  -7.31734370798413E-03  -7.31734370800441E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02857664696792E-11   0.00000000000000E+00   2.02857664696792E-11
      5.47767577971884E-18  -4.29176369415662E-01  -4.29137498454781E-01   0.00000000000000E+00  -6.18993090813177E-13
     -1.35285802211532E-22  -1.22771855250036E-10  -1.23390848340985E-10  -4.18206258430118E-18
      7.36411913703081E-07
      0.00000000000000E+00  -1.10029995174617E-13   0.00000000000000E+00   2.37389266417352E-16   7.16774893723339E-23
      1.10028918759495E-10   1.10029156148833E-10  -1.29338662715741E-18  -7.29870345350775E-03  -7.29870345352702E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92687634599520E-11   0.00000000000000E+00   1.92687634599520E-11
      5.51621330663875E-18  -4.51680440825188E-01  -4.51639709423764E-01   0.00000000000000E+00  -6.54980294789999E-13
     -1.37995271263287E-22  -1.28642939313856E-10  -1.29297919608784E-10  -4.22282667948134E-18
      7.36911913703082E-07
      0.00000000000000E+00  -1.11775045181560E-13   0.00000000000000E+00   2.37775142381638E-16   7.53583114245000E-23
      1.11778407142745E-10   1.11778644917963E-10  -1.29283914630548E-18  -7.29471323803474E-03  -7.29471323805369E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89584768821843E-11   0.00000000000000E+00   1.89584768821843E-11
      5.52569254507984E-18  -4.57277866104773E-01  -4.57236681428913E-01   0.00000000000000E+00  -6.77384705511637E-13
     -1.38681121116228E-22  -1.30059737094500E-10  -1.30737121800150E-10  -4.23285339877436E-18
      7.37586913703081E-07
      0.00000000000000E+00  -1.14163008348956E-13   0.00000000000000E+00   2.35567908031877E-16   8.00551151009388E-23
      1.14128839807509E-10   1.14129075375497E-10  -1.29211420713178E-18  -7.29076299830402E-03  -7.29076299832263E-03
      0.00000000000000E+00   0.00000000000000E+00   1.86076525093924E-11   0.00000000000000E+00   1.86076525093924E-11
      5.53825271052368E-18  -4.64783162249094E-01  -4.64741347813074E-01   0.00000000000000E+00  -6.89549702603666E-13
     -1.39614910695376E-22  -1.32047178182144E-10  -1.32736727884887E-10  -4.24613850339190E-18
      7.38498163703082E-07
      0.00000000000000E+00  -1.17285729414012E-13   0.00000000000000E+00   2.32829840380442E-16   8.58685264237630E-23
      1.17280712585965E-10   1.17280945415891E-10  -1.29115881367706E-18  -7.28841066654984E-03  -7.28841066656799E-03
      0.00000000000000E+00   0.00000000000000E+00   1.81493236640150E-11   0.00000000000000E+00   1.81493236640150E-11
      5.55479128171251E-18  -4.74821303642089E-01  -4.74778640908384E-01   0.00000000000000E+00  -7.06104479563728E-13
     -1.40887738883849E-22  -1.34724164600203E-10  -1.35430269079908E-10  -4.26363246803546E-18
      7.39728351203081E-07
      0.00000000000000E+00  -1.21510587325558E-13   0.00000000000000E+00   2.29914580489334E-16   9.28072857685676E-23
      1.21505729730314E-10   1.21505959644987E-10  -1.28990518238498E-18  -7.29163119386282E-03  -7.29163119388038E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75568809853081E-11   0.00000000000000E+00   1.75568809853081E-11
      5.57638953723963E-18  -4.88202438205572E-01  -4.88158631459805E-01   0.00000000000000E+00  -7.28423301694942E-13
     -1.42624678080202E-22  -1.38334417328459E-10  -1.39062840630296E-10  -4.28648435485465E-18
      7.41389104328081E-07
      0.00000000000000E+00  -1.27204961032425E-13   0.00000000000000E+00   2.27442169340880E-16   1.00710769361029E-22
      1.27178499927615E-10   1.27178727369885E-10  -1.28826199725951E-18  -7.31108270696644E-03  -7.31108270698323E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67955838472041E-11   0.00000000000000E+00   1.67955838472041E-11
      5.60428285560007E-18  -5.05961156957757E-01  -5.05915803473723E-01   0.00000000000000E+00  -7.58336866513226E-13
     -1.44994445728904E-22  -1.43215974350430E-10  -1.43974311217089E-10  -4.31602085834056E-18
      7.43389104328082E-07
      0.00000000000000E+00  -1.34001471585782E-13   0.00000000000000E+00   2.27395986722787E-16   1.08477567377089E-22
      1.34031748176749E-10   1.34031975572844E-10  -1.28631912513672E-18  -7.36648283194849E-03  -7.36648283196441E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59125975704602E-11   0.00000000000000E+00   1.59125975704602E-11
      5.63610805074099E-18  -5.26912716624832E-01  -5.26865483022383E-01   0.00000000000000E+00  -7.95160544048075E-13
     -1.47866711066711E-22  -1.49149412599108E-10  -1.49944573143304E-10  -4.34978892560427E-18
      7.45389104328082E-07
      0.00000000000000E+00  -1.41624584774006E-13   0.00000000000000E+00   2.57314902504559E-16   1.15234397450014E-22
      1.41609265926234E-10   1.41609523241252E-10  -1.28411424648284E-18  -7.58714932494689E-03  -7.58714932496173E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48375221164877E-11   0.00000000000000E+00   1.48375221164877E-11
      5.66578309497397E-18  -5.47437296938740E-01  -5.47388015646517E-01   0.00000000000000E+00  -8.27762648785447E-13
     -1.50716454592380E-22  -1.55619282708803E-10  -1.56447045357739E-10  -4.38166884849113E-18
      7.47389104328082E-07
      0.00000000000000E+00  -1.51268282180797E-13   0.00000000000000E+00   3.42129532837116E-16   1.21999965728637E-22
      1.51223709782278E-10   1.51224051911933E-10  -1.28106725521778E-18  -8.22754141447000E-03  -8.22754141448335E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33550035764871E-11   0.00000000000000E+00   1.33550035764871E-11
      5.69249310212694E-18  -5.67541201013946E-01  -5.67489358818604E-01   0.00000000000000E+00  -8.44965201043340E-13
     -1.53484693161765E-22  -1.63734090287224E-10  -1.64579055488421E-10  -4.41142584690916E-18
      7.49389104328082E-07
      0.00000000000000E+00  -1.74321311219886E-13   0.00000000000000E+00   8.85258677817535E-16   1.35448129024848E-22
      1.74287412860464E-10   1.74288298119277E-10  -1.27286601315703E-18  -1.12552212568451E-02  -1.12552212568535E-02
      0.00000000000000E+00   0.00000000000000E+00   8.38581910018169E-12   0.00000000000000E+00   8.38581910018169E-12
      5.70926474032731E-18  -5.87214331639186E-01  -5.87156790408964E-01   0.00000000000000E+00  -7.57698380466336E-13
     -1.55853763506432E-22  -1.81916418838836E-10  -1.82674117219459E-10  -4.43639872717027E-18
      7.51389104328082E-07
      0.00000000000000E+00  -3.19895219693816E-13   0.00000000000000E+00   5.22803586277501E-15   2.04050483778686E-22
      3.19847750628702E-10   3.19852978664768E-10  -1.22959365109275E-18  -2.99539009226893E-02  -2.99539009226679E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.13627827102817E-11   0.00000000000000E+00  -2.13627827102817E-11
      5.66653917490675E-18  -6.06276491558924E-01  -6.06182470491538E-01   0.00000000000000E+00   1.37648487663517E-14
     -1.55805087767211E-22  -2.98503960803098E-10  -2.98490195954488E-10  -4.43694552381400E-18
      7.53389104328082E-07
      0.00000000000000E+00  -7.06928942286333E-13   0.00000000000000E+00   1.17165247405660E-14   2.95117539097157E-22
      7.06888589487606E-10   7.06900306012642E-10  -1.15816996403591E-18  -5.93088400462669E-02  -5.93088400462196E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.73201261067584E-11   0.00000000000000E+00  -4.73201261067584E-11
      5.57189892269323E-18  -6.24265032679234E-01  -6.24057271320025E-01   0.00000000000000E+00   5.05819492773209E-13
     -1.54224575252960E-22  -6.60085999398503E-10  -6.59580179905884E-10  -4.41372895865731E-18
      7.55389104328082E-07
      0.00000000000000E+00  -1.46685229794141E-12   0.00000000000000E+00   2.05723777025084E-14   3.51612971627553E-22
      1.46680451228930E-09   1.46682508466736E-09  -1.08390303987508E-18  -8.90011408295512E-02  -8.90011408294937E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.75337994324391E-11   0.00000000000000E+00  -5.75337994324391E-11
      5.45683132382835E-18  -6.40448406700661E-01  -6.40004489746269E-01   0.00000000000000E+00   4.60803315000694E-13
     -1.52730813612509E-22  -1.40975208854976E-09  -1.40929128523492E-09  -4.37292828395327E-18
      7.57389104328082E-07
      0.00000000000000E+00  -2.85462627714714E-12   0.00000000000000E+00   3.57855362082153E-14   3.90571137571561E-22
      2.85458764774848E-09   2.85462343328508E-09  -1.01393739436500E-18  -1.18267829158149E-01  -1.18267829158081E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82579209214169E-11   0.00000000000000E+00  -6.82579209214169E-11
      5.32031548198551E-18  -6.53646671814080E-01  -6.52768980123545E-01   0.00000000000000E+00   3.71807671370650E-13
     -1.51465689860521E-22  -2.78673732003488E-09  -2.78636551236366E-09  -4.30637808762052E-18
      7.59389104328082E-07
      0.00000000000000E+00  -5.14321343888429E-12   0.00000000000000E+00   5.77899851814931E-14   4.21785328193588E-22
      5.14310986353724E-09   5.14316765352285E-09  -9.51117440013462E-19  -1.46992262831672E-01  -1.46992262831590E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.19325123770667E-11   0.00000000000000E+00  -8.19325123770667E-11
      5.15645045723138E-18  -6.62178886194118E-01  -6.60584612943324E-01   0.00000000000000E+00   2.75983450771002E-13
     -1.50460603138372E-22  -5.06151112459641E-09  -5.06123514114579E-09  -4.20533301721792E-18
      7.61389104328082E-07
      0.00000000000000E+00  -8.54817338137893E-12   0.00000000000000E+00   8.51552205644290E-14   4.44229422240972E-22
      8.54810888429122E-09   8.54819403951223E-09  -8.95197666646746E-19  -1.75137683284937E-01  -1.75137683284839E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.77882508955417E-11   0.00000000000000E+00  -9.77882508955417E-11
      4.96087395544030E-18  -6.63976977220906E-01  -6.61315111892186E-01   0.00000000000000E+00   2.38918321544288E-13
     -1.49524270775983E-22  -8.45064470693808E-09  -8.45040578861669E-09  -4.06567628879355E-18
      7.63389104328082E-07
      0.00000000000000E+00  -1.32306936184303E-11   0.00000000000000E+00   1.16477320680278E-13   4.55256593675799E-22
      1.32305340188497E-08   1.32306504961708E-08  -8.44351580502133E-19  -2.02701608674305E-01  -2.02701608674191E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13110986361962E-10   0.00000000000000E+00  -1.13110986361962E-10
      4.73465198271637E-18  -6.56694894292434E-01  -6.52562857146281E-01   0.00000000000000E+00   3.68189589240291E-13
     -1.48075929207640E-22  -1.31179076993979E-08  -1.31175395098089E-08  -3.89030040221424E-18
      7.65389104328082E-07
      0.00000000000000E+00  -1.93909956771507E-11   0.00000000000000E+00   1.48894992733307E-13   4.54072579154680E-22
      1.93908322100634E-08   1.93909811050566E-08  -7.96567818589154E-19  -2.29695511224006E-01  -2.29695511223881E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25547050785905E-10   0.00000000000000E+00  -1.25547050785905E-10
      4.48355788114456E-18  -6.37636555272596E-01  -6.31567839969149E-01   0.00000000000000E+00   7.47699743426361E-13
     -1.45172155951531E-22  -1.92661817540140E-08  -1.92654340542707E-08  -3.68699006255541E-18
      7.67389104328082E-07
      0.00000000000000E+00  -2.73256462139834E-11   0.00000000000000E+00   1.96854086854831E-13   4.41270186583426E-22
      2.73254923820161E-08   2.73256892361033E-08  -7.50302019801941E-19  -2.56134319667581E-01  -2.56134319667446E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34742987016596E-10   0.00000000000000E+00  -1.34742987016596E-10
      4.21407190711137E-18  -6.03576775842806E-01  -5.95011279869716E-01   0.00000000000000E+00   1.32252144000361E-12
     -1.39744745581806E-22  -2.71922687705266E-08  -2.71909462490868E-08  -3.46376988730943E-18
      7.69389104328082E-07
      0.00000000000000E+00  -3.73099957510764E-11   0.00000000000000E+00   2.45910516567456E-13   4.16185285123403E-22
      3.73097845254462E-08   3.73100304359632E-08  -7.04650137243671E-19  -2.82030150368243E-01  -2.82030150368100E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42578425188248E-10   0.00000000000000E+00  -1.42578425188248E-10
      3.92891505673487E-18  -5.50807583990518E-01  -5.39098960372868E-01   0.00000000000000E+00   1.89598768427481E-12
     -1.31116403275906E-22  -3.71693479984590E-08  -3.71674520107749E-08  -3.22426491949120E-18
      7.71389104328082E-07
      0.00000000000000E+00  -4.91877245457026E-11   0.00000000000000E+00   2.93237315631883E-13   3.69886335848450E-22
      4.91874712837778E-08   4.91877645210938E-08  -6.59395432920746E-19  -3.07388619698780E-01  -3.07388619698627E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52550816249633E-10   0.00000000000000E+00  -1.52550816249633E-10
      3.62381342423561E-18  -4.75962536691975E-01  -4.60514681622210E-01   0.00000000000000E+00   2.12735606487170E-12
     -1.20087409212974E-22  -4.90373410609089E-08  -4.90352137048442E-08  -2.96441799131486E-18
      7.73389104328082E-07
      0.00000000000000E+00  -6.19895032413737E-11   0.00000000000000E+00   3.18456558878920E-13   2.95477689288366E-22
      6.19891740436424E-08   6.19894925002016E-08  -6.14652933150118E-19  -3.32214217172766E-01  -3.32214217172601E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.65346927655199E-10   0.00000000000000E+00  -1.65346927655199E-10
      3.29311956892521E-18  -3.77560256588198E-01  -3.58082701993957E-01   0.00000000000000E+00   1.95866684386590E-12
     -1.08178104410232E-22  -6.18261042393902E-08  -6.18241455725464E-08  -2.67846663577509E-18
      7.75389104328082E-07
      0.00000000000000E+00  -7.34731262686424E-11   0.00000000000000E+00   2.86262592307270E-13   2.30975410578025E-22
      7.34728471121806E-08   7.34731333747731E-08  -5.70486461808473E-19  -3.56514262164458E-01  -3.56514262164278E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79577088112915E-10   0.00000000000000E+00  -1.79577088112915E-10
      2.93396539269938E-18  -2.58617311475779E-01  -2.35525595736448E-01   0.00000000000000E+00   1.56941020230842E-12
     -9.42084737969113E-23  -7.32951256968624E-08  -7.32935562866602E-08  -2.36347893089091E-18
      7.77389104328082E-07
      0.00000000000000E+00  -7.80691287632442E-11   0.00000000000000E+00   1.50032164591644E-13   1.36717394118730E-22
      7.80689705871298E-08   7.80691206192946E-08  -5.27566472564021E-19  -3.80276563741212E-01  -3.80276563741007E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05167799125095E-10   0.00000000000000E+00  -2.05167799125095E-10
      2.52362979444919E-18  -1.32991918539768E-01  -1.08459777521493E-01   0.00000000000000E+00   9.12656063370866E-13
     -7.99782709475023E-23  -7.78648654762328E-08  -7.78639528201695E-08  -1.99606332188517E-18
      7.79389104328082E-07
      0.00000000000000E+00  -5.75119804577696E-11   0.00000000000000E+00  -5.10967126344272E-13   3.98245514547513E-23
      5.75124438846845E-08   5.75119329175582E-08  -4.78836535763985E-19  -4.03596912493918E-01  -4.03596912493731E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.87115633243534E-10   0.00000000000000E+00  -1.87115633243534E-10
      2.14939852796212E-18  -4.98597165062997E-02  -3.17985663148762E-02   0.00000000000000E+00   8.99036391821981E-13
     -3.66016246610217E-23  -5.73257163207065E-08  -5.73248172843147E-08  -1.67056199219814E-18
      7.81389104328082E-07
      0.00000000000000E+00  -3.06152491665453E-11   0.00000000000000E+00  -6.65987645707928E-13   1.25766670190438E-23
      3.06159001649635E-08   3.06152341773178E-08  -4.21211416269985E-19  -4.26571350018002E-01  -4.26571350017878E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24369389957477E-10   0.00000000000000E+00  -1.24369389957477E-10
      1.90065974804717E-18  -2.07359126305422E-02  -1.11292270779117E-02   0.00000000000000E+00   7.77584447193437E-13
     -1.31432596551766E-23  -3.04916423718075E-08  -3.04908647873603E-08  -1.47944833177719E-18
      7.83389104328082E-07
      0.00000000000000E+00  -2.03180764545235E-11   0.00000000000000E+00  -2.53988943804468E-13   6.26048345201875E-24
      2.03182963436942E-08   2.03180423547504E-08  -3.64855322209084E-19  -4.49126153723657E-01  -4.49126153723554E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02723750279345E-10   0.00000000000000E+00  -1.02723750279345E-10
      1.69521224748848E-18  -1.22266791912348E-02  -5.85747773848505E-03   0.00000000000000E+00   3.10460867319524E-13
     -6.93393108041288E-24  -2.02156290653384E-08  -2.02153186044710E-08  -1.33035692527940E-18
      7.85389104328082E-07
      0.00000000000000E+00  -1.73375310426648E-11   0.00000000000000E+00  -7.31897752571309E-14   4.41473908349943E-24
      1.73375663979736E-08   1.73374932081984E-08  -3.11127174070341E-19  -4.71232907862572E-01  -4.71232907862472E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97961590154512E-11   0.00000000000000E+00  -9.97961590154512E-11
      1.49561992945758E-18  -9.67648591870813E-03  -4.24543299590883E-03   0.00000000000000E+00   1.14758662067920E-13
     -4.91551883493146E-24  -1.72378118078450E-08  -1.72376970491829E-08  -1.18449275538724E-18
      7.87389104328082E-07
      0.00000000000000E+00  -1.65253480315387E-11   0.00000000000000E+00  -1.97062628670074E-14   3.64515160873853E-24
      1.65253664356532E-08   1.65253467293903E-08  -2.59959091907029E-19  -4.92891333880902E-01  -4.92891333880800E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01494555050496E-10   0.00000000000000E+00  -1.01494555050496E-10
      1.29263081935659E-18  -8.74764561144846E-03  -3.57300566670485E-03   0.00000000000000E+00   5.45557185711105E-14
     -4.01226253949852E-24  -1.64239067300584E-08  -1.64238521743398E-08  -1.03267172744956E-18
      7.89389104328083E-07
      0.00000000000000E+00  -1.62875620069084E-11   0.00000000000000E+00  -5.56324262388464E-15   3.20644680468787E-24
      1.62875564667204E-08   1.62875509034778E-08  -2.11257393634986E-19  -5.14108841501327E-01  -5.14108841501223E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03863230751586E-10   0.00000000000000E+00  -1.03863230751586E-10
      1.08490435785341E-18  -8.29287453677536E-03  -3.19389970377752E-03   0.00000000000000E+00   3.60382917244893E-14
     -3.46860356566612E-24  -1.61837237110179E-08  -1.61836876727262E-08  -8.73646964218428E-19
      7.91389104328083E-07
      0.00000000000000E+00  -1.62014116434077E-11   0.00000000000000E+00  -1.84987439379163E-15   2.90695816695315E-24
      1.62014508343824E-08   1.62014489845080E-08  -1.64908372047816E-19  -5.34894281883618E-01  -5.34894281883512E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05905596741651E-10   0.00000000000000E+00  -1.05905596741651E-10
      8.73093164370112E-19  -8.00971392773593E-03  -2.93850797211533E-03   0.00000000000000E+00   2.90079526362722E-14
     -3.08547122427284E-24  -1.60955723957190E-08  -1.60955433877663E-08  -7.08184792322297E-19
      7.93389104328083E-07
      0.00000000000000E+00  -1.61602652011387E-11   0.00000000000000E+00  -7.74475551613832E-16   2.68376769037551E-24
      1.61602481939544E-08   1.61602474194789E-08  -1.20765956967856E-19  -5.55255620980327E-01  -5.55255620980219E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07409706834874E-10   0.00000000000000E+00  -1.07409706834874E-10
      6.58273750700363E-19  -7.80865777368047E-03  -2.75090519208324E-03   0.00000000000000E+00   2.52758230320606E-14
     -2.79583429233150E-24  -1.60528629884670E-08  -1.60528377126440E-08  -5.37507793732507E-19
      7.95389104328083E-07
      0.00000000000000E+00  -1.61358345010415E-11   0.00000000000000E+00  -4.27633409961245E-16   2.50940351830784E-24
      1.61358017544108E-08   1.61358013267774E-08  -7.86732864895133E-20  -5.75196109851056E-01  -5.75196109850948E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08352769437258E-10   0.00000000000000E+00  -1.08352769437258E-10
      4.41568211825847E-19  -7.65601880160081E-03  -2.60626372274099E-03   0.00000000000000E+00   2.27585538348137E-14
     -2.56852620691515E-24  -1.60274713158940E-08  -1.60274485573402E-08  -3.62894925336334E-19
      7.97389104328083E-07
      0.00000000000000E+00  -1.61192106036070E-11   0.00000000000000E+00  -2.67628206655040E-16   2.36908886743861E-24
      1.61191860591000E-08   1.61191857914718E-08  -3.85605195054277E-20  -5.94674086727867E-01  -5.94674086727759E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08538666164003E-10   0.00000000000000E+00  -1.08538666164003E-10
      2.24490879497842E-19  -7.53522805660635E-03  -2.49076498175146E-03   0.00000000000000E+00   2.07464200944905E-14
     -2.38572187549532E-24  -1.60106678717278E-08  -1.60106471253078E-08  -1.85930359992415E-19
      7.99389104328083E-07
      0.00000000000000E+00  -1.61052502035514E-11   0.00000000000000E+00  -1.49661757655295E-16   2.25476353781333E-24
      1.61052942424133E-08   1.61052940927516E-08  -8.96090498499416E-22  -6.13377727289783E-01  -6.13377727289676E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06466130284830E-10   0.00000000000000E+00  -1.06466130284830E-10
      1.15586189281830E-20  -7.43668054129250E-03  -2.39594002171328E-03   0.00000000000000E+00   1.87076748413159E-14
     -2.23756960580232E-24  -1.59988466701416E-08  -1.59988279624668E-08  -1.06625284296827E-20
      8.01389104328083E-07
      0.00000000000000E+00  -1.60761354218567E-11   0.00000000000000E+00  -5.48619667268436E-16   2.17526343041216E-24
      1.60760916038735E-08   1.60760910552539E-08   3.34371559071030E-20  -6.30755367384051E-01  -6.30755367383950E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00590071629771E-10   0.00000000000000E+00  -1.00590071629771E-10
     -1.89621524331359E-19  -7.38289033387454E-03  -2.34949836739444E-03   0.00000000000000E+00   1.68460335031294E-14
     -2.13692350578378E-24  -1.59755178296576E-08  -1.59755009836241E-08   1.56184368424256E-19
      8.03389104328083E-07
      0.00000000000000E+00  -1.60561132691454E-11   0.00000000000000E+00  -3.48744159812358E-16   2.11307723379490E-24
      1.60561039572522E-08   1.60561036085080E-08   6.28960717951152E-20  -6.45914435022662E-01  -6.45914435022573E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.90013006530780E-11   0.00000000000000E+00  -8.90013006530780E-11
     -3.67624125637515E-19  -7.34430793067771E-03  -2.31356123292358E-03   0.00000000000000E+00   1.38714025354456E-14
     -2.05892368088281E-24  -1.59671161792575E-08  -1.59671023078549E-08   3.04728053842400E-19
      8.05389104328083E-07
      0.00000000000000E+00  -1.60298456743041E-11   0.00000000000000E+00  -5.41027403296038E-16   2.06773009309532E-24
      1.60298373282803E-08   1.60298367872529E-08   8.50677595027164E-20  -6.57468556355006E-01  -6.57468556354937E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.85606117564958E-11   0.00000000000000E+00  -6.85606117564958E-11
     -5.04745349150507E-19  -7.31587184051800E-03  -2.28696011709100E-03   0.00000000000000E+00   1.02621192800831E-14
     -2.00377176659360E-24  -1.59612864376157E-08  -1.59612761754964E-08   4.19677589647791E-19
      8.07389104328083E-07
      0.00000000000000E+00  -1.59914545741513E-11   0.00000000000000E+00  -8.89204669514920E-16   2.04194861235309E-24
      1.59914448056137E-08   1.59914439164091E-08   9.66709846595314E-20  -6.63562126694953E-01  -6.63562126694917E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.64046882266426E-11   0.00000000000000E+00  -3.64046882266426E-11
     -5.77554725603792E-19  -7.29821833080063E-03  -2.27127133483295E-03   0.00000000000000E+00   5.39357721145615E-15
     -1.97546610192216E-24  -1.59550446217596E-08  -1.59550392281824E-08   4.80883740944261E-19
      8.09389104328083E-07
      0.00000000000000E+00  -1.59381846265709E-11   0.00000000000000E+00  -1.32834032014701E-15   2.04061538445972E-24
      1.59381850643659E-08   1.59381837360256E-08   9.37287968915202E-20  -6.62010360880994E-01  -6.62010360881003E-01
      0.00000000000000E+00   0.00000000000000E+00   9.25518477249828E-12   0.00000000000000E+00   9.25518477249828E-12
     -5.59044356058795E-19  -7.29386684247728E-03  -2.26931454970397E-03   0.00000000000000E+00  -1.13617142065438E-15
     -1.98091490454926E-24  -1.59474377846267E-08  -1.59474389207981E-08   4.65315559167275E-19
      8.11389104328083E-07
      0.00000000000000E+00  -1.58678315578700E-11   0.00000000000000E+00   7.00515552006845E-15   2.07244747614635E-24
      1.58679093282785E-08   1.58679163334340E-08   7.14469449591645E-20  -6.50345900594359E-01  -6.50345900594428E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93993543001802E-11   0.00000000000000E+00   6.93993543001802E-11
     -4.20245647458435E-19  -7.30759053776733E-03  -2.28623120071650E-03   0.00000000000000E+00  -1.87083773997514E-14
     -2.03288908449477E-24  -1.59372969793568E-08  -1.59373156877342E-08   3.48798702499272E-19
      8.13389104328083E-07
      0.00000000000000E+00  -1.57776400259322E-11   0.00000000000000E+00  -2.46195162013733E-15   2.15455141673789E-24
      1.57776632544236E-08   1.57776607924720E-08   2.35054925611812E-20  -6.25678744078181E-01  -6.25678744078326E-01
      0.00000000000000E+00   0.00000000000000E+00   1.44715925528262E-10   0.00000000000000E+00   1.44715925528262E-10
     -1.30813796401911E-19  -7.34850946319552E-03  -2.33185558925582E-03   0.00000000000000E+00  -2.18750375712781E-14
     -2.15810540170754E-24  -1.59223548429627E-08  -1.59223767180003E-08   1.07308303840729E-19
      8.15389104328083E-07
      0.00000000000000E+00  -1.56346377701001E-11   0.00000000000000E+00  -3.95345322575048E-15   2.35561271997316E-24
      1.56346106214280E-08   1.56346066679747E-08  -5.92251597799143E-20  -5.84555028767718E-01  -5.84555028767952E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34113901096286E-10   0.00000000000000E+00   2.34113901096286E-10
      3.37414005790662E-19  -7.49187145361258E-03  -2.49212582027953E-03   0.00000000000000E+00  -3.90297308290761E-14
     -2.46668773456002E-24  -1.58686815393402E-08  -1.58687205690710E-08  -2.78188846010748E-19
      8.17389104328083E-07
      0.00000000000000E+00  -1.54025461191767E-11   0.00000000000000E+00  -1.40246855750885E-14   2.84677768334629E-24
      1.54025749558790E-08   1.54025609311934E-08  -1.90624623791732E-19  -5.23244331193338E-01  -5.23244331193665E-01
      0.00000000000000E+00   0.00000000000000E+00   3.27254573950802E-10   0.00000000000000E+00   3.27254573950802E-10
      9.91923153692267E-19  -7.90234047525768E-03  -2.94636289811734E-03   0.00000000000000E+00  -5.98408873368426E-14
     -3.29770619725577E-24  -1.57297556642569E-08  -1.57298155051442E-08  -8.01298529900534E-19
      8.19389104328083E-07
      0.00000000000000E+00  -1.47592655797751E-11   0.00000000000000E+00  -1.72195894969868E-14   4.22356122580754E-24
      1.47592960263339E-08   1.47592788067444E-08  -3.89221821406899E-19  -4.38963453238846E-01  -4.38963453239237E-01
      0.00000000000000E+00   0.00000000000000E+00   3.90927698308032E-10   0.00000000000000E+00   3.90927698308032E-10
      1.77377855030833E-18  -9.43592990690558E-03  -4.66258490748634E-03   0.00000000000000E+00  -1.20213845009701E-13
     -6.85063487764598E-24  -1.51500862912074E-08  -1.51502065050524E-08  -1.38455672890143E-18
      8.21389104328083E-07
      0.00000000000000E+00  -1.03633927675485E-11   0.00000000000000E+00  -1.21712318529941E-13   4.48806010309205E-24
      1.03635705983429E-08   1.03634488860244E-08  -6.50577590305240E-19  -3.31457243642942E-01  -3.31457243643341E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98586373418395E-10   0.00000000000000E+00   3.98586373418395E-10
      2.57095129714512E-18  -1.95119114089491E-02  -1.61211589470737E-02   0.00000000000000E+00  -1.98302468220692E-13
     -3.78608216585190E-23  -1.07618369569746E-08  -1.07620352594428E-08  -1.92037370683988E-18
      8.23389104328083E-07
      0.00000000000000E+00  -1.25257852603625E-12   0.00000000000000E+00  -2.30137093094658E-13  -3.29021741072315E-23
      1.25279467602955E-09   1.25256453893643E-09  -9.15854633617817E-19  -2.07528388523391E-01  -2.07528388523797E-01
      0.00000000000000E+00   0.00000000000000E+00   4.05333582597295E-10   0.00000000000000E+00   4.05333582597295E-10
      3.38161846233971E-18  -4.71710943432563E-02  -4.66487540774860E-02   0.00000000000000E+00  -5.10062846185737E-13
     -8.40972460913420E-23  -1.65738805868745E-09  -1.65789812153372E-09  -2.46576382872189E-18
      8.25389104328083E-07
      0.00000000000000E+00   6.22707318267031E-14   0.00000000000000E+00  -3.90074951708864E-14  -4.49483707897436E-23
     -6.21517048395689E-11  -6.21907123347847E-11  -1.15450398881904E-18  -9.02493444563326E-02  -9.02493444566781E-02
      0.00000000000000E+00   0.00000000000000E+00   3.45474232254922E-10   0.00000000000000E+00   3.45474232254922E-10
      4.07256692684956E-18  -7.69580292431110E-02  -7.68687781159170E-02   0.00000000000000E+00  -1.20088899163493E-12
     -9.64856426505330E-23  -2.82082630928407E-10  -2.83283519920139E-10  -2.91806293803052E-18
      8.27389104328083E-07
      0.00000000000000E+00   5.70355818058741E-14   0.00000000000000E+00  -4.01882365287866E-15  -4.62339321193304E-23
     -5.70681929502918E-11  -5.70722117739909E-11  -1.26801488860649E-18  -3.37440116406605E-02  -3.37440116408586E-02
      0.00000000000000E+00   0.00000000000000E+00   1.98011398809568E-10   0.00000000000000E+00   1.98011398809568E-10
      4.46858972446869E-18  -1.06420548884869E-01  -1.06376144730405E-01   0.00000000000000E+00  -9.74887236037978E-13
     -1.03845936038074E-22  -1.39964299799435E-10  -1.40939187035576E-10  -3.20057483586221E-18
      8.29389104328083E-07
      0.00000000000000E+00   1.52462263764494E-14   0.00000000000000E+00   3.55174802454427E-16  -4.63871760742993E-23
     -1.52731159269324E-11  -1.52727607521763E-11  -1.30645105630159E-18  -1.59812772009469E-02  -1.59812772010560E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09075804703807E-10   0.00000000000000E+00   1.09075804703807E-10
      4.68674133387631E-18  -1.35373475841651E-01  -1.35343922689355E-01   0.00000000000000E+00  -5.63961454684919E-13
     -1.07368537823447E-22  -9.32390824968390E-11  -9.38030439516313E-11  -3.38029027757472E-18
      8.31389104328083E-07
      0.00000000000000E+00  -8.44971582309246E-15   0.00000000000000E+00   9.29450516630248E-16  -4.61119529106444E-23
      8.45974296344952E-12   8.46067241392004E-12  -1.31813946958051E-18  -1.08399082915243E-02  -1.08399082915957E-02
      0.00000000000000E+00   0.00000000000000E+00   7.14048345615397E-11   0.00000000000000E+00   7.14048345615397E-11
      4.82955100299939E-18  -1.63756168615082E-01  -1.63731006801747E-01   0.00000000000000E+00  -4.28882600342752E-13
     -1.09842101700201E-22  -7.94366243750074E-11  -7.98655069754600E-11  -3.51141153341888E-18
      8.33389104328084E-07
      0.00000000000000E+00  -2.38796316739570E-14   0.00000000000000E+00   8.25788904488047E-16  -4.53360903979557E-23
      2.39238570735877E-11   2.39246828624468E-11  -1.32050745870531E-18  -9.20306861269662E-03  -9.20306861275020E-03
      0.00000000000000E+00   0.00000000000000E+00   5.35794250927402E-11   0.00000000000000E+00   5.35794250927402E-11
      4.93670985318487E-18  -1.91555794723069E-01  -1.91531377064701E-01   0.00000000000000E+00  -4.15132914986441E-13
     -1.12127649168160E-22  -7.70889750400885E-11  -7.75041079551871E-11  -3.61620239447956E-18
      8.35389104328084E-07
      0.00000000000000E+00  -3.58194475109354E-14   0.00000000000000E+00   6.47195094550886E-16  -4.36494861322535E-23
      3.58025673145513E-11   3.58032145096022E-11  -1.31935310912107E-18  -8.53237481892859E-03  -8.53237481897206E-03
      0.00000000000000E+00   0.00000000000000E+00   4.34687368842415E-11   0.00000000000000E+00   4.34687368842415E-11
      5.02364732695335E-18  -2.18779836609114E-01  -2.18754862182769E-01   0.00000000000000E+00  -4.31521518977355E-13
     -1.14419765995008E-22  -7.88404298747524E-11  -7.92719513938442E-11  -3.70429421783228E-18
      8.37389104328084E-07
      0.00000000000000E+00  -4.58305238665558E-14   0.00000000000000E+00   5.08187374384990E-16  -4.04937727264822E-23
      4.58343308581317E-11   4.58348390454656E-11  -1.31679982151498E-18  -8.16521962138558E-03  -8.16521962142254E-03
      0.00000000000000E+00   0.00000000000000E+00   3.69600856341582E-11   0.00000000000000E+00   3.69600856341582E-11
      5.09756749822167E-18  -2.45442754889621E-01  -2.45416670770316E-01   0.00000000000000E+00  -4.51510256701031E-13
     -1.16745595711938E-22  -8.23434144228057E-11  -8.27949246796235E-11  -3.78076767670668E-18
      8.39389104328084E-07
      0.00000000000000E+00  -5.47394633756859E-14   0.00000000000000E+00   4.13997982364091E-16  -3.52530462950470E-23
      5.47642013834482E-11   5.47646153813953E-11  -1.31374142498732E-18  -7.92130789200410E-03  -7.92130789203657E-03
      0.00000000000000E+00   0.00000000000000E+00   3.24733027663950E-11   0.00000000000000E+00   3.24733027663950E-11
      5.16251410375446E-18  -2.71558413847330E-01  -2.71530930220680E-01   0.00000000000000E+00  -4.69959537897373E-13
     -1.19100803297078E-22  -8.67679586097740E-11  -8.72379181477905E-11  -3.84877267876714E-18
      8.41389104328084E-07
      0.00000000000000E+00  -6.30054897243633E-14   0.00000000000000E+00   3.51914259520557E-16  -2.73413922631563E-23
      6.29717245350219E-11   6.29720764492541E-11  -1.31058663525411E-18  -7.74247552559250E-03  -7.74247552562174E-03
      0.00000000000000E+00   0.00000000000000E+00   2.92397321339350E-11   0.00000000000000E+00   2.92397321339350E-11
      5.22099356802233E-18  -2.97135237833380E-01  -2.97106187478994E-01   0.00000000000000E+00  -4.87134539075212E-13
     -1.21480479843349E-22  -9.17246740439924E-11  -9.22118085831891E-11  -3.91040693276822E-18
      8.43389104328084E-07
      0.00000000000000E+00  -7.07204476497956E-14   0.00000000000000E+00   3.10950763884265E-16  -1.63531460766199E-23
      7.06915889555522E-11   7.06918999062997E-11  -1.30752138775791E-18  -7.60415612472999E-03  -7.60415612475680E-03
      0.00000000000000E+00   0.00000000000000E+00   2.68105665755257E-11   0.00000000000000E+00   2.68105665755257E-11
      5.27461470117338E-18  -3.22176519649938E-01  -3.22145802807624E-01   0.00000000000000E+00  -5.04333088360557E-13
     -1.23884642613878E-22  -9.69981333933413E-11  -9.75024664818257E-11  -3.96709331341547E-18
      8.45389104328084E-07
      0.00000000000000E+00  -7.80680266263977E-14   0.00000000000000E+00   2.83649948418135E-16  -2.26431287431817E-24
      7.80845191927318E-11   7.80848028426780E-11  -1.30462112749075E-18  -7.49328379899458E-03  -7.49328379901949E-03
      0.00000000000000E+00   0.00000000000000E+00   2.49073455284196E-11   0.00000000000000E+00   2.49073455284196E-11
      5.32442939223022E-18  -3.46690743371643E-01  -3.46658297376164E-01   0.00000000000000E+00  -5.23030424196594E-13
     -1.26319040131451E-22  -1.02469117946775E-10  -1.02992148371098E-10  -4.01980826473947E-18
      8.47389104328084E-07
      0.00000000000000E+00  -8.53237608657924E-14   0.00000000000000E+00   2.66875327262476E-16   1.40374654173981E-23
      8.52916751143967E-11   8.52919419897380E-11  -1.30188445239548E-18  -7.41326005320322E-03  -7.41326005322654E-03
      0.00000000000000E+00   0.00000000000000E+00   2.33141250206378E-11   0.00000000000000E+00   2.33141250206378E-11
      5.37105764227149E-18  -3.70672448094862E-01  -3.70638233844895E-01   0.00000000000000E+00  -5.43527463418998E-13
     -1.28789203482832E-22  -1.08062539546827E-10  -1.08606067010375E-10  -4.06917318987601E-18
      8.49389104328084E-07
      0.00000000000000E+00  -9.23958056307719E-14   0.00000000000000E+00   2.56669616180333E-16   3.10449797257110E-23
      9.24020405947887E-11   9.24022972644359E-11  -1.29929007829796E-18  -7.36614491230756E-03  -7.36614491232950E-03
      0.00000000000000E+00   0.00000000000000E+00   2.19397489638035E-11   0.00000000000000E+00   2.19397489638035E-11
      5.41493714019910E-18  -3.94146437261784E-01  -3.94110416344597E-01   0.00000000000000E+00  -5.67462236153581E-13
     -1.31306037745776E-22  -1.13774583991955E-10  -1.14342046228240E-10  -4.11564706190115E-18
      8.51389104328084E-07
      0.00000000000000E+00  -9.94678503957515E-14   0.00000000000000E+00   2.47875705067027E-16   4.77915835774361E-23
      9.94302997544067E-11   9.94305476301596E-11  -1.29684882702801E-18  -7.33149876242995E-03  -7.33149876245080E-03
      0.00000000000000E+00   0.00000000000000E+00   2.08479765167544E-11   0.00000000000000E+00   2.08479765167544E-11
      5.45663309323261E-18  -4.17270191608854E-01  -4.17232300903848E-01   0.00000000000000E+00  -6.00522099524331E-13
     -1.33901975176470E-22  -1.19678002047256E-10  -1.20278524146914E-10  -4.15978426620460E-18
      8.53389104328084E-07
      0.00000000000000E+00  -1.06356205686316E-13   0.00000000000000E+00   2.40910034911263E-16   6.34207947986736E-23
      1.06395237775435E-10   1.06395478685533E-10  -1.29454936591661E-18  -7.30702758715308E-03  -7.30702758717289E-03
      0.00000000000000E+00   0.00000000000000E+00   1.98170677909573E-11   0.00000000000000E+00   1.98170677909573E-11
      5.49626722881452E-18  -4.40002263529461E-01  -4.39962503863789E-01   0.00000000000000E+00  -6.35939903776348E-13
     -1.36574909993825E-22  -1.25576606572577E-10  -1.26212546476490E-10  -4.20171786289792E-18
      8.55389104328084E-07
      0.00000000000000E+00  -1.13336405714088E-13   0.00000000000000E+00   2.35115913331328E-16   7.73280283614002E-23
      1.13300003187579E-10   1.13300238303569E-10  -1.29237535670264E-18  -7.29410468550165E-03  -7.29410468552046E-03
      0.00000000000000E+00   0.00000000000000E+00   1.88050425008535E-11   0.00000000000000E+00   1.88050425008535E-11
      5.53387731381623E-18  -4.62292268539891E-01  -4.62250652978094E-01   0.00000000000000E+00  -6.72845657054034E-13
     -1.39315634874605E-22  -1.31432435147230E-10  -1.32105280804423E-10  -4.24150195711360E-18
      8.57389104328084E-07
      0.00000000000000E+00  -1.20132916267445E-13   0.00000000000000E+00   2.30654220792223E-16   8.92337567717514E-23
      1.20157332386972E-10   1.20157563041282E-10  -1.29030572549367E-18  -7.29593319905794E-03  -7.29593319907576E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78261887496574E-11   0.00000000000000E+00   1.78261887496574E-11
      5.56952969131555E-18  -4.84132445336221E-01  -4.84088978432514E-01   0.00000000000000E+00  -7.11891086660396E-13
     -1.42114575999758E-22  -1.37271860704137E-10  -1.37983751790940E-10  -4.27922396582187E-18
      8.59389104328084E-07
      0.00000000000000E+00  -1.27021271558009E-13   0.00000000000000E+00   2.27980018921442E-16   9.91480173996566E-23
      1.26994678008483E-10   1.26994905988601E-10  -1.28831349328915E-18  -7.31864123474789E-03  -7.31864123476478E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68828624788475E-11   0.00000000000000E+00   1.68828624788475E-11
      5.60329541627324E-18  -5.05528302404406E-01  -5.05482979326864E-01   0.00000000000000E+00  -7.52334178818556E-13
     -1.44956846871481E-22  -1.43125434288485E-10  -1.43877768467448E-10  -4.31498192298409E-18
      8.61389104328084E-07
      0.00000000000000E+00  -1.33909626848574E-13   0.00000000000000E+00   2.28704559155203E-16   1.07292830651361E-22
      1.33881255057968E-10   1.33881483762634E-10  -1.28635516789182E-18  -7.37618426504376E-03  -7.37618426505972E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59671593278144E-11   0.00000000000000E+00   1.59671593278144E-11
      5.63522973492887E-18  -5.26488563334272E-01  -5.26441359941418E-01   0.00000000000000E+00  -7.92585303073405E-13
     -1.47821371797650E-22  -1.49056057787227E-10  -1.49848643090448E-10  -4.34887456703705E-18
      8.63389104328084E-07
      0.00000000000000E+00  -1.41440895299591E-13   0.00000000000000E+00   2.58300890419833E-16   1.14348730339810E-22
      1.41478858461993E-10   1.41479116762998E-10  -1.28413926415557E-18  -7.59795309245349E-03  -7.59795309246837E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48795215555264E-11   0.00000000000000E+00   1.48795215555264E-11
      5.66498877803992E-18  -5.47021681512628E-01  -5.46972428058033E-01   0.00000000000000E+00  -8.25738582226261E-13
     -1.50666355515312E-22  -1.55532899736148E-10  -1.56358638318525E-10  -4.38084951388435E-18
      8.65389104328084E-07
      0.00000000000000E+00  -1.51084592706382E-13   0.00000000000000E+00   3.45622027096758E-16   1.21335085774011E-22
      1.51093955101681E-10   1.51094300723829E-10  -1.28108944363211E-18  -8.23652597770368E-03  -8.23652597771707E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33920629234267E-11   0.00000000000000E+00   1.33920629234267E-11
      5.69177290388678E-18  -5.67133952293214E-01  -5.67082139283982E-01   0.00000000000000E+00  -8.43500955466681E-13
     -1.53432223492642E-22  -1.63642862691636E-10  -1.64486363647256E-10  -4.41068346025467E-18
      8.67389104328084E-07
      0.00000000000000E+00  -1.73862087533848E-13   0.00000000000000E+00   8.74883758941709E-16   1.34788907478221E-22
      1.73885167451033E-10   1.73886042334927E-10  -1.27298401502458E-18  -1.12176840113731E-02  -1.12176840113816E-02
      0.00000000000000E+00   0.00000000000000E+00   8.49569605846658E-12   0.00000000000000E+00   8.49569605846658E-12
      5.70876429600371E-18  -5.86815656067448E-01  -5.86758206917954E-01   0.00000000000000E+00  -7.58866969005206E-13
     -1.55807076002155E-22  -1.81622871424232E-10  -1.82381738393393E-10  -4.43578028097913E-18
      8.69389104328084E-07
      0.00000000000000E+00  -3.16313274942722E-13   0.00000000000000E+00   5.14232795213169E-15   2.02283383967184E-22
      3.16318299061432E-10   3.16323441389586E-10  -1.23043284884875E-18  -2.95985062482594E-02  -2.95985062482386E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.07360460998740E-11   0.00000000000000E+00  -2.07360460998740E-11
      5.66729220380396E-18  -6.05891266709369E-01  -6.05798159978138E-01   0.00000000000000E+00  -1.65915251698458E-15
     -1.55805625642307E-22  -2.95585736137039E-10  -2.95587395289712E-10  -4.43685935495521E-18
      8.71389104328084E-07
      0.00000000000000E+00  -6.99489518572524E-13   0.00000000000000E+00   1.16234236833221E-14   2.93828838816851E-22
      6.99484965823360E-10   6.99496589247338E-10  -1.15917667977312E-18  -5.89095051309862E-02  -5.89095051309391E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.71047299983676E-11   0.00000000000000E+00  -4.71047299983676E-11
      5.57308274380723E-18  -6.23901283092146E-01  -6.23695785992459E-01   0.00000000000000E+00   5.04696701635715E-13
     -1.54228741716498E-22  -6.52896555950452E-10  -6.52391859248970E-10  -4.41390606403410E-18
      8.73389104328084E-07
      0.00000000000000E+00  -1.45270820841145E-12   0.00000000000000E+00   2.04102339397065E-14   3.50854810196338E-22
      1.45264919855418E-09   1.45266960878848E-09  -1.08489350753708E-18  -8.86044774758839E-02  -8.86044774758265E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.73872832626020E-11   0.00000000000000E+00  -5.73872832626020E-11
      5.45830817728202E-18  -6.40118920874678E-01  -6.39679416652479E-01   0.00000000000000E+00   4.61902618540819E-13
     -1.52731793425539E-22  -1.39574422814426E-09  -1.39528232552587E-09  -4.37341466974494E-18
      8.75389104328084E-07
      0.00000000000000E+00  -2.82992004283831E-12   0.00000000000000E+00   3.55279701145767E-14   3.90018307826205E-22
      2.82985709226975E-09   2.82989262024026E-09  -1.01484371119220E-18  -1.17877285656966E-01  -1.17877285656897E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.80827660045360E-11   0.00000000000000E+00  -6.80827660045360E-11
      5.32214264527295E-18  -6.53371204901856E-01  -6.52501248119048E-01   0.00000000000000E+00   3.73183636541906E-13
     -1.51462530970299E-22  -2.76218303787211E-09  -2.76180985423572E-09  -4.30729893408075E-18
      8.76389104328084E-07
      0.00000000000000E+00  -3.86528576537876E-12   0.00000000000000E+00   5.24847927102802E-14   4.14495170769445E-22
      3.86524910392824E-09   3.86530158872137E-09  -9.81769090431591E-19  -1.32384985366085E-01  -1.32384985366010E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.54331311584784E-11   0.00000000000000E+00  -7.54331311584784E-11
      5.24670951411447E-18  -6.58925933166612E-01  -6.57732139452396E-01   0.00000000000000E+00   3.01693776742119E-13
     -1.50922705536994E-22  -3.79017015133948E-09  -3.78986845756289E-09  -4.26494042368288E-18
      8.77739104328084E-07
      0.00000000000000E+00  -5.67187174625081E-12   0.00000000000000E+00   6.72997748951123E-14   4.36748823454528E-22
      5.67178624545845E-09   5.67185354523378E-09  -9.40734930010390E-19  -1.51711528878448E-01  -1.51711528878363E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.58727360597780E-11   0.00000000000000E+00  -8.58727360597780E-11
      5.13078132043377E-18  -6.63961185275982E-01  -6.62201617435222E-01   0.00000000000000E+00   2.31581647509039E-13
     -1.50330938943342E-22  -5.58621239082137E-09  -5.58598080917401E-09  -4.19004639042338E-18
      8.79561604328084E-07
      0.00000000000000E+00  -8.91959349864617E-12   0.00000000000000E+00   8.90588312203376E-14   4.52140967196924E-22
      8.91949349191482E-09   8.91958255074650E-09  -8.90676859330171E-19  -1.77316664293872E-01  -1.77316664293772E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00283278696539E-10   0.00000000000000E+00  -1.00283278696539E-10
      4.94801504500933E-18  -6.64918369243832E-01  -6.62140302891339E-01   0.00000000000000E+00   2.17184388856381E-13
     -1.49539304061737E-22  -8.81951645643867E-09  -8.81929927204996E-09  -4.05733818567916E-18
      8.81561604328084E-07
      0.00000000000000E+00  -1.37000202255607E-11   0.00000000000000E+00   1.18965442141724E-13   4.58542585581477E-22
      1.36999230295196E-08   1.37000419949622E-08  -8.40350538107581E-19  -2.04834334683070E-01  -2.04834334682955E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14951854050564E-10   0.00000000000000E+00  -1.14951854050564E-10
      4.71811133690820E-18  -6.56711914499122E-01  -6.52432597645083E-01   0.00000000000000E+00   3.76926067479064E-13
     -1.48057373813465E-22  -1.35854670669790E-08  -1.35850901409117E-08  -3.87776079880062E-18
      8.83561604328085E-07
      0.00000000000000E+00  -1.99798122873882E-11   0.00000000000000E+00   1.55941736542980E-13   4.54750617399156E-22
      1.99796901339718E-08   1.99798460757088E-08  -7.92818519085780E-19  -2.31783506736030E-01  -2.31783506735903E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26767992037597E-10   0.00000000000000E+00  -1.26767992037597E-10
      4.46457535283300E-18  -6.36514111380958E-01  -6.30260281264300E-01   0.00000000000000E+00   7.80087430555447E-13
     -1.45008958038270E-22  -1.98538581711016E-08  -1.98530780836712E-08  -3.67175683374722E-18
      8.85561604328085E-07
      0.00000000000000E+00  -2.80648126590295E-11   0.00000000000000E+00   2.00599289333910E-13   4.40360091639741E-22
      2.80646226623775E-08   2.80648232616673E-08  -7.46658621812796E-19  -2.58179051764731E-01  -2.58179051764595E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35550127460954E-10   0.00000000000000E+00  -1.35550127460954E-10
      4.19347509791110E-18  -6.01043948412084E-01  -5.92245854721032E-01   0.00000000000000E+00   1.37665640023576E-12
     -1.39339706757879E-22  -2.79306497906065E-08  -2.79292731342064E-08  -3.44681647609830E-18
      8.87561604328085E-07
      0.00000000000000E+00  -3.82164114625775E-11   0.00000000000000E+00   2.51909154389632E-13   4.13896029502081E-22
      3.82161902753365E-08   3.82164421844913E-08  -7.01049375754316E-19  -2.84032531507577E-01  -2.84032531507433E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43303448990261E-10   0.00000000000000E+00  -1.43303448990261E-10
      3.90686819993058E-18  -5.46564473617508E-01  -5.34570507210348E-01   0.00000000000000E+00   1.93797071432602E-12
     -1.30446226398351E-22  -3.80750767062153E-08  -3.80731387355011E-08  -3.20581882417626E-18
      8.89561604328085E-07
      0.00000000000000E+00  -5.02198757024408E-11   0.00000000000000E+00   2.98153566007077E-13   3.65300961700272E-22
      5.02195372749293E-08   5.02198354284957E-08  -6.55836971668933E-19  -3.09348949411429E-01  -3.09348949411275E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53523158825505E-10   0.00000000000000E+00  -1.53523158825505E-10
      3.59982188227957E-18  -4.69791859369779E-01  -4.54019127946989E-01   0.00000000000000E+00   2.13246990426042E-12
     -1.19268762817343E-22  -5.00684447395743E-08  -5.00663122696702E-08  -2.94398491061063E-18
      8.91561604328085E-07
      0.00000000000000E+00  -6.30391048981813E-11   0.00000000000000E+00   3.18950054713031E-13   2.89867289767379E-22
      6.30388155728275E-08   6.30391345228825E-08  -6.11138405328063E-19  -3.34133155160199E-01  -3.34133155160033E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66391654855452E-10   0.00000000000000E+00  -1.66391654855452E-10
      3.26703857256866E-18  -3.69456188817678E-01  -3.49648223935083E-01   0.00000000000000E+00   1.94462559209747E-12
     -1.07248305800787E-22  -6.28746874936190E-08  -6.28727428680270E-08  -2.65590016724060E-18
      8.93561604328085E-07
      0.00000000000000E+00  -7.42222119453070E-11   0.00000000000000E+00   2.78827661804012E-13   2.26157306713945E-22
      7.42219082411323E-08   7.42221870687943E-08  -5.67051419709295E-19  -3.58391540725012E-01  -3.58391540724831E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81168191677522E-10   0.00000000000000E+00  -1.81168191677522E-10
      2.90470218921362E-18  -2.49208499115750E-01  -2.25881242016339E-01   0.00000000000000E+00   1.52868205050978E-12
     -9.30709294305391E-23  -7.40425475591672E-08  -7.40410188771167E-08  -2.33765076950432E-18
      8.95561604328085E-07
      0.00000000000000E+00  -7.78773569519549E-11   0.00000000000000E+00   9.15615608499553E-14   1.27182555389191E-22
      7.78772892321480E-08   7.78773807937089E-08  -5.24200690756311E-19  -3.82112326190166E-01  -3.82112326189959E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07099121558606E-10   0.00000000000000E+00  -2.07099121558606E-10
      2.49050394609641E-18  -1.24137985592048E-01  -9.96668271719497E-02   0.00000000000000E+00   9.14121093932885E-13
     -7.83415501761179E-23  -7.76711957932443E-08  -7.76702816721504E-08  -1.96630325534010E-18
      8.97561604328085E-07
      0.00000000000000E+00  -5.49170910974453E-11   0.00000000000000E+00  -5.70612529380143E-13   3.60392164079817E-23
      5.49176529532965E-08   5.49170823407672E-08  -4.74444192396666E-19  -4.05405946099798E-01  -4.05405946099616E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81906371661773E-10   0.00000000000000E+00  -1.81906371661773E-10
      2.12669120277286E-18  -4.62337919631918E-02  -2.89885467737539E-02   0.00000000000000E+00   9.21139351172602E-13
     -3.34762305365448E-23  -5.47360971084565E-08  -5.47351759691053E-08  -1.65224701037619E-18
      8.99561604328085E-07
      0.00000000000000E+00  -2.93498123773000E-11   0.00000000000000E+00  -6.32850966138886E-13   1.20188840312407E-23
      2.93504509690722E-08   2.93498181181060E-08  -4.16720355387107E-19  -4.28349789131033E-01  -4.28349789130912E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21402797357993E-10   0.00000000000000E+00  -1.21402797357993E-10
      1.88388560805687E-18  -1.96449318989166E-02  -1.04360021975158E-02   0.00000000000000E+00   7.36516245242685E-13
     -1.30364890768450E-23  -2.92291518369933E-08  -2.92284153207480E-08  -1.46716525266977E-18
      9.01561604328085E-07
      0.00000000000000E+00  -1.99309508871938E-11   0.00000000000000E+00  -2.32262677442052E-13   6.03595376783981E-24
      1.99312220968758E-08   1.99309898341984E-08  -3.60562737023440E-19  -4.50869958617149E-01  -4.50869958617047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02129616725547E-10   0.00000000000000E+00  -1.02129616725547E-10
      1.67962637460578E-18  -1.19100127066099E-02  -5.66257144859559E-03   0.00000000000000E+00   2.86918156679281E-13
     -6.69551575714478E-24  -1.98291471356295E-08  -1.98288602174728E-08  -1.31906363758234E-18
      9.02561604328085E-07
      0.00000000000000E+00  -1.77741609233494E-11   0.00000000000000E+00  -1.06089494284370E-13   4.84020980305335E-24
      1.77742433218230E-08   1.77741372323287E-08  -3.33301841648935E-19  -4.62017165401416E-01  -4.62017165401316E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00609679913170E-10   0.00000000000000E+00  -1.00609679913170E-10
      1.57901669469261E-18  -1.02000006061229E-02  -4.63163321053569E-03   0.00000000000000E+00   1.49690808446879E-13
     -5.45823547974593E-24  -1.76736772432240E-08  -1.76735275524155E-08  -1.24571485304367E-18
      9.03911604328085E-07
      0.00000000000000E+00  -1.67851767930988E-11   0.00000000000000E+00  -3.57912529345505E-14   4.09756427749084E-24
      1.67852352989935E-08   1.67851995077406E-08  -2.97666466635333E-19  -4.76860370392642E-01  -4.76860370392542E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00432425773208E-10   0.00000000000000E+00  -1.00432425773208E-10
      1.44343291989878E-18  -9.22385525974267E-03  -3.96701199062825E-03   0.00000000000000E+00   7.39727346731055E-14
     -4.58140346494108E-24  -1.66848410547020E-08  -1.66847670819674E-08  -1.14576645326345E-18
      9.05734104328085E-07
      0.00000000000000E+00  -1.63950203494412E-11   0.00000000000000E+00  -1.02330811149487E-14   3.53929180443572E-24
      1.63950250355153E-08   1.63950148024342E-08  -2.51504440644655E-19  -4.96527649000519E-01  -4.96527649000417E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01976911230752E-10   0.00000000000000E+00  -1.01976911230752E-10
      1.25757999918073E-18  -8.61391802267852E-03  -3.48049296835134E-03   0.00000000000000E+00   4.39453354794910E-14
     -3.88861702902640E-24  -1.62930818365389E-08  -1.62930378912034E-08  -1.00607555853608E-18
      9.07734104328085E-07
      0.00000000000000E+00  -1.62522017830835E-11   0.00000000000000E+00  -3.22460745559817E-15   3.14534076135431E-24
      1.62522084914116E-08   1.62522052668042E-08  -2.03217279315746E-19  -5.17671195768239E-01  -5.17671195768135E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04212776248738E-10   0.00000000000000E+00  -1.04212776248738E-10
      1.04915444668326E-18  -8.22882923825409E-03  -3.14110035251409E-03   0.00000000000000E+00   3.30552119699813E-14
     -3.39166214687074E-24  -1.61480255457674E-08  -1.61479924905554E-08  -8.45937167367514E-19
      9.09734104328085E-07
      0.00000000000000E+00  -1.61892881380963E-11   0.00000000000000E+00  -1.28325580235059E-15   2.86407095611771E-24
      1.61892514942034E-08   1.61892502109476E-08  -1.57255408400064E-19  -5.38384105883220E-01  -5.38384105883114E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06194393845826E-10   0.00000000000000E+00  -1.06194393845826E-10
      8.36765658991605E-19  -7.96942655689715E-03  -2.90215471754042E-03   0.00000000000000E+00   2.79465311756160E-14
     -3.03014528641815E-24  -1.60830837636329E-08  -1.60830558171017E-08  -6.79510250591542E-19
      9.11734104328085E-07
      0.00000000000000E+00  -1.61544789826947E-11   0.00000000000000E+00  -6.12365385200487E-16   2.65107194960161E-24
      1.61544601882040E-08   1.61544595758386E-08  -1.13472138880380E-19  -5.58674085341327E-01  -5.58674085341219E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07609045549783E-10   0.00000000000000E+00  -1.07609045549783E-10
      6.21547567892039E-19  -7.77949503125679E-03  -2.72362851153174E-03   0.00000000000000E+00   2.47145975515320E-14
     -2.75327698801414E-24  -1.60468752448864E-08  -1.60468505302889E-08  -5.08075429011660E-19
      9.13734104328085E-07
      0.00000000000000E+00  -1.61323444010277E-11   0.00000000000000E+00  -3.20670674487056E-16   2.48340621528553E-24
      1.61323104236710E-08   1.61323101030003E-08  -7.17137387800993E-20  -5.78542420939718E-01  -5.78542420939609E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08455480818970E-10   0.00000000000000E+00  -1.08455480818970E-10
      4.04636606254099E-19  -7.63344170710654E-03  -2.58481869458041E-03   0.00000000000000E+00   2.23214124207830E-14
     -2.53463591085123E-24  -1.60238769435938E-08  -1.60238546221813E-08  -3.32922867473999E-19
      9.15734104328085E-07
      0.00000000000000E+00  -1.61166389509652E-11   0.00000000000000E+00  -1.78421698302989E-16   2.34794970457121E-24
      1.61166440278846E-08   1.61166438494629E-08  -3.19583468225067E-20  -5.97923901897649E-01  -5.97923901897541E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08420915657387E-10   0.00000000000000E+00  -1.08420915657387E-10
      1.87794774939325E-19  -7.51705899349003E-03  -2.47335950336255E-03   0.00000000000000E+00   2.03506437137967E-14
     -2.35824923047827E-24  -1.60082432844492E-08  -1.60082229338055E-08  -1.55836428116818E-19
      9.17734104328085E-07
      0.00000000000000E+00  -1.61008416561655E-11   0.00000000000000E+00  -2.00210609491857E-16   2.23955261184801E-24
      1.61008470002647E-08   1.61008468000541E-08   5.24346232791134E-21  -6.16462219896108E-01  -6.16462219896003E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05856299437062E-10   0.00000000000000E+00  -1.05856299437062E-10
     -2.39178239347992E-20  -7.42574573908678E-03  -2.38621409295993E-03   0.00000000000000E+00   1.84147791785284E-14
     -2.21812956069733E-24  -1.59950089153962E-08  -1.59949905006170E-08   1.86743616068873E-20
      9.19734104328085E-07
      0.00000000000000E+00  -1.60728290113172E-11   0.00000000000000E+00  -5.23250597840076E-16   2.16339151987536E-24
      1.60728365916500E-08   1.60728360683994E-08   3.89347170232787E-20  -6.33567224693645E-01  -6.33567224693546E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.92755624025933E-11   0.00000000000000E+00  -9.92755624025933E-11
     -2.22468948739986E-19  -7.37545339156606E-03  -2.34267264141837E-03   0.00000000000000E+00   1.64287496709870E-14
     -2.12190141720349E-24  -1.59735769347464E-08  -1.59735605059968E-08   1.83534231716708E-19
      9.21734104328085E-07
      0.00000000000000E+00  -1.60526231691315E-11   0.00000000000000E+00  -3.59007903740192E-16   2.10380581864334E-24
      1.60526435949157E-08   1.60526432359078E-08   6.74513484796156E-20  -6.48278356551850E-01  -6.48278356551763E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.65550335397503E-11   0.00000000000000E+00  -8.65550335397503E-11
     -3.95579015819486E-19  -7.33859682563277E-03  -2.30816950450005E-03   0.00000000000000E+00   1.33689494603124E-14
     -2.04738009215341E-24  -1.59661015713175E-08  -1.59660882023681E-08   3.28127667339872E-19
      9.22734104328085E-07
      0.00000000000000E+00  -1.60398567506597E-11   0.00000000000000E+00  -5.12410783098794E-16   2.07853746635482E-24
      1.60398270849069E-08   1.60398265724961E-08   7.98795436527229E-20  -6.54754136937092E-01  -6.54754136937015E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.68421912555190E-11   0.00000000000000E+00  -7.68421912555190E-11
     -4.72421207075006E-19  -7.32286900741904E-03  -2.29341923498810E-03   0.00000000000000E+00   1.14985623503681E-14
     -2.01658291922751E-24  -1.59629958798030E-08  -1.59629843812406E-08   3.92541663422282E-19
      9.24084104328085E-07
      0.00000000000000E+00  -1.60179977032043E-11   0.00000000000000E+00  -7.06205661752279E-16   2.05249911390946E-24
      1.60180326588785E-08   1.60180319526728E-08   9.26100193521152E-20  -6.61426489607167E-01  -6.61426489607108E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.89387810311088E-11   0.00000000000000E+00  -5.89387810311088E-11
     -5.51988561467003E-19  -7.30617295893058E-03  -2.27794881030849E-03   0.00000000000000E+00   8.68564668540042E-15
     -1.98565351360921E-24  -1.59591018572884E-08  -1.59590931716417E-08   4.59378542114887E-19
      9.25906604328085E-07
      0.00000000000000E+00  -1.59791473793655E-11   0.00000000000000E+00  -1.25167910990329E-15   2.03433443425733E-24
      1.59791861987961E-08   1.59791849471170E-08   1.00123123132982E-19  -6.65381288783107E-01  -6.65381288783081E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.59882891558800E-11   0.00000000000000E+00  -2.59882891558800E-11
     -5.99352218453594E-19  -7.29297254608968E-03  -2.26660591004089E-03   0.00000000000000E+00   4.11201445073735E-15
     -1.96716117198655E-24  -1.59532007699755E-08  -1.59531966579611E-08   4.99229095320612E-19
      9.27906604328085E-07
      0.00000000000000E+00  -1.59221117975596E-11   0.00000000000000E+00  -1.44358725600970E-15   2.04029634048164E-24
      1.59221044767390E-08   1.59221030331518E-08   9.27996387218278E-20  -6.61520781215207E-01  -6.61520781215230E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30721865847916E-11   0.00000000000000E+00   2.30721865847916E-11
     -5.53207845284010E-19  -7.29260868680098E-03  -2.26876964225099E-03   0.00000000000000E+00  -3.09706039495418E-15
     -1.98265359218520E-24  -1.59451721226762E-08  -1.59451752197366E-08   4.60408206562184E-19
      9.29906604328085E-07
      0.00000000000000E+00  -1.58473501814727E-11   0.00000000000000E+00  -6.61514974347113E-16   2.08225811891496E-24
      1.58474108913030E-08   1.58474102297880E-08   6.48352662530044E-20  -6.46908448633155E-01  -6.46908448633242E-01
      0.00000000000000E+00   0.00000000000000E+00   8.68179226079157E-11   0.00000000000000E+00   8.68179226079157E-11
     -3.79572000068179E-19  -7.31188137202220E-03  -2.29149264502776E-03   0.00000000000000E+00  -1.37666072991207E-14
     -2.04896484251430E-24  -1.59342143857886E-08  -1.59342281523959E-08   3.14736733815175E-19
      9.31906604328085E-07
      0.00000000000000E+00  -1.57520153442513E-11   0.00000000000000E+00  -7.28112047940691E-16   2.18037953700607E-24
      1.57520122609596E-08   1.57520115328476E-08   9.35952802359953E-21  -6.18516106700859E-01  -6.18516106701025E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65823730568739E-10   0.00000000000000E+00   1.65823730568739E-10
     -4.79245389307008E-20  -7.36114121048151E-03  -2.34591923979121E-03   0.00000000000000E+00  -2.74108120369259E-14
     -2.19822777491518E-24  -1.59178078526043E-08  -1.59178352634163E-08   3.85650109071020E-20
      9.33906604328085E-07
      0.00000000000000E+00  -1.55875214199126E-11   0.00000000000000E+00  -4.53993221003779E-15   2.42949086351953E-24
      1.55875667447869E-08   1.55875622048547E-08  -8.37011064626296E-20  -5.72757160896229E-01  -5.72757160896487E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57885399837145E-10   0.00000000000000E+00   2.57885399837145E-10
      4.67846260743589E-19  -7.54931807571678E-03  -2.55690603517216E-03   0.00000000000000E+00  -4.43638035899899E-14
     -2.58437157301558E-24  -1.58454032408882E-08  -1.58454476046918E-08  -3.84145154280960E-19
      9.35906604328085E-07
      0.00000000000000E+00  -1.53173142030481E-11   0.00000000000000E+00  -7.51037334702209E-15   3.04417864009728E-24
      1.53173075115171E-08   1.53173000011437E-08  -2.29651032166030E-19  -5.05970431282920E-01  -5.05970431283268E-01
      0.00000000000000E+00   0.00000000000000E+00   3.48337890574007E-10   0.00000000000000E+00   3.48337890574007E-10
      1.16452204189160E-18  -8.08369872179517E-03  -3.14794618242834E-03   0.00000000000000E+00  -7.70656531699545E-14
     -3.67850412062570E-24  -1.56655608260646E-08  -1.56656378917177E-08  -9.34871009725574E-19
      9.37906604328085E-07
      0.00000000000000E+00  -1.43666293282130E-11   0.00000000000000E+00  -3.13561561774712E-14   4.84124293881806E-24
      1.43666521863623E-08   1.43666208302061E-08  -4.46456860678886E-19  -4.15839849260445E-01  -4.15839849260843E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98013182107846E-10   0.00000000000000E+00   3.98013182107846E-10
      1.96054840610729E-18  -1.03667546753784E-02  -5.71489431246007E-03   0.00000000000000E+00  -1.32451154763508E-13
     -9.30787156832008E-24  -1.47645015611592E-08  -1.47646340123140E-08  -1.51409154542841E-18
      9.39906604328086E-07
      0.00000000000000E+00  -7.77998399937518E-12   0.00000000000000E+00  -1.65704582504684E-13  -3.92977486482028E-25
      7.78015382527193E-09   7.77998812068942E-09  -7.13808572340127E-19  -3.03144061141966E-01  -3.03144061142369E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03040980411222E-10   0.00000000000000E+00   4.03040980411222E-10
      2.76663036692974E-18  -2.54626774377533E-02  -2.28844919066973E-02   0.00000000000000E+00  -2.36270524742802E-13
     -5.45312187937288E-23  -8.18279283057585E-09  -8.18302910110065E-09  -2.05282179458961E-18
      9.41906604328086E-07
      0.00000000000000E+00  -5.60987654863573E-13   0.00000000000000E+00  -1.83775599031402E-13  -3.86142761613618E-23
      5.61118061054355E-10   5.60934285455285E-10  -9.78251060561555E-19  -1.77323025671278E-01  -1.77323025671677E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98948773739413E-10   0.00000000000000E+00   3.98948773739413E-10
      3.56452791440856E-18  -5.43655358671211E-02  -5.40631143442636E-02   0.00000000000000E+00  -6.79773944591879E-13
     -8.71328499154673E-23  -9.59203285250019E-10  -9.59883059194698E-10  -2.58627685384701E-18
      9.43906604328086E-07
      0.00000000000000E+00   8.17418161146988E-14   0.00000000000000E+00  -2.31275510633385E-14  -4.54668580159102E-23
     -8.16858564163948E-11  -8.17089839675036E-11  -1.19232316629295E-18  -7.11422388828057E-02  -7.11422388831194E-02
      0.00000000000000E+00   0.00000000000000E+00   3.13700344046841E-10   0.00000000000000E+00   3.13700344046841E-10
      4.19192860250225E-18  -8.41074981938529E-02  -8.40344069095582E-02   0.00000000000000E+00  -1.24568779594320E-12
     -9.88308409416087E-23  -2.30745672283295E-10  -2.31991360079337E-10  -2.99960543620929E-18
      9.45906604328086E-07
      0.00000000000000E+00   4.51876107061032E-14   0.00000000000000E+00  -2.15465710918915E-15  -4.63348265601148E-23
     -4.51831076722215E-11  -4.51852623293770E-11  -1.28131094113578E-18  -2.73676348196789E-02  -2.73676348198487E-02
      0.00000000000000E+00   0.00000000000000E+00   1.69795625305850E-10   0.00000000000000E+00   1.69795625305850E-10
      4.53151985311395E-18  -1.13456534586731E-01  -1.13417275074486E-01   0.00000000000000E+00  -8.52737181962384E-13
     -1.04938524064836E-22  -1.23757625794406E-10  -1.24610362976474E-10  -3.25020891197817E-18
      9.47906604328086E-07
      0.00000000000000E+00   8.44971582309246E-15   0.00000000000000E+00   6.43506363533062E-16  -4.63518598036404E-23
     -8.41629009487846E-12  -8.41564658856128E-12  -1.31061796311499E-18  -1.41361624240054E-02  -1.41361624241025E-02
      0.00000000000000E+00   0.00000000000000E+00   9.70596689504248E-11   0.00000000000000E+00   9.70596689504248E-11
      4.72563919101480E-18  -1.42274805488843E-01  -1.42246877788727E-01   0.00000000000000E+00  -5.12164773309245E-13
     -1.08008437514784E-22  -8.81318575884459E-11  -8.86440223618631E-11  -3.41502122789980E-18
      9.48906604328086E-07
      0.00000000000000E+00  -4.77592633479139E-15   0.00000000000000E+00   1.02772438474190E-15  -4.62139254485102E-23
      4.75767662646676E-12   4.75870435080529E-12  -1.31743620045741E-18  -1.12503266984800E-02  -1.12503266985556E-02
      0.00000000000000E+00   0.00000000000000E+00   7.56602379388114E-11   0.00000000000000E+00   7.56602379388114E-11
      4.80129942895361E-18  -1.56540733628178E-01  -1.56515397415697E-01   0.00000000000000E+00  -4.32568105541024E-13
     -1.09255711333557E-22  -7.99863741839659E-11  -8.04189422896162E-11  -3.48386322849620E-18
      9.50256604328086E-07
      0.00000000000000E+00  -1.68994316461849E-14   0.00000000000000E+00   9.47937715676332E-16  -4.58279133235762E-23
      1.69271941332035E-11   1.69281420708733E-11  -1.32065446575024E-18  -9.70864282145727E-03  -9.70864282151750E-03
      0.00000000000000E+00   0.00000000000000E+00   6.02319378719420E-11   0.00000000000000E+00   6.02319378719420E-11
      4.88261254508073E-18  -1.75532329405557E-01  -1.75508020032406E-01   0.00000000000000E+00  -4.07210829572645E-13
     -1.10795754769433E-22  -7.67528691131319E-11  -7.71600799428153E-11  -3.56195807933049E-18
      9.52079104328086E-07
      0.00000000000000E+00  -2.90229369575785E-14   0.00000000000000E+00   7.53973942039253E-16  -4.47911954010295E-23
      2.90441592350030E-11   2.90449132089003E-11  -1.32072837205952E-18  -8.85725170523945E-03  -8.85725170528795E-03
      0.00000000000000E+00   0.00000000000000E+00   4.85000367457320E-11   0.00000000000000E+00   4.85000367457320E-11
      4.97100386204983E-18  -2.00686871645914E-01  -2.00662441183231E-01   0.00000000000000E+00  -4.17978517542191E-13
     -1.12863703630863E-22  -7.71269714369768E-11  -7.75449499546319E-11  -3.65027548999031E-18
      9.54079104328086E-07
      0.00000000000000E+00  -3.98606159480666E-14   0.00000000000000E+00   5.79772146943183E-16  -4.25877830256146E-23
      3.98672219120199E-11   3.98678016841242E-11  -1.31869300819612E-18  -8.37607287118813E-03  -8.37607287122854E-03
      0.00000000000000E+00   0.00000000000000E+00   4.04055234392325E-11   0.00000000000000E+00   4.04055234392325E-11
      5.05181490892829E-18  -2.27720960275729E-01  -2.27695670435741E-01   0.00000000000000E+00  -4.38879314117143E-13
     -1.15170650856068E-22  -7.98344458091244E-11  -8.02733251233567E-11  -3.73312190073217E-18
      9.56079104328086E-07
      0.00000000000000E+00  -4.93206238804419E-14   0.00000000000000E+00   4.60730703993625E-16  -3.86786506021491E-23
      4.92980870386417E-11   4.92985477693070E-11  -1.31580036788817E-18  -8.07148787197004E-03  -8.07148787200496E-03
      0.00000000000000E+00   0.00000000000000E+00   3.49186696615079E-11   0.00000000000000E+00   3.49186696615079E-11
      5.12165224825131E-18  -2.54199533173271E-01  -2.54173001041905E-01   0.00000000000000E+00  -4.58864973512289E-13
     -1.17512432273575E-22  -8.37583524571853E-11  -8.42172174308151E-11  -3.80585188036314E-18
      9.58079104328085E-07
      0.00000000000000E+00  -5.78621844407419E-14   0.00000000000000E+00   3.82684408154840E-16  -3.24509684298177E-23
      5.78409700682878E-11   5.78413527526635E-11  -1.31264024326638E-18  -7.85546123728079E-03  -7.85546123731183E-03
      0.00000000000000E+00   0.00000000000000E+00   3.10392725401682E-11   0.00000000000000E+00   3.10392725401682E-11
      5.18373079333164E-18  -2.80134841369987E-01  -2.80106840303093E-01   0.00000000000000E+00  -4.76604352249628E-13
     -1.19880428837280E-22  -8.84040209404625E-11  -8.88806252928320E-11  -3.87109055006526E-18
      9.60079104328085E-07
      0.00000000000000E+00  -6.57608318405892E-14   0.00000000000000E+00   3.31412820312155E-16  -2.33571500464755E-23
      6.57864227986254E-11   6.57867542114223E-11  -1.30949222094061E-18  -7.69253779776358E-03  -7.69253779779177E-03
      0.00000000000000E+00   0.00000000000000E+00   2.81912525739091E-11   0.00000000000000E+00   2.81912525739091E-11
      5.24011329847946E-18  -3.05532771171125E-01  -3.05503164483426E-01   0.00000000000000E+00  -4.93416184950203E-13
     -1.22271061345454E-22  -9.34845906002594E-11  -9.39780067853319E-11  -3.93062107753885E-18
      9.62079104328085E-07
      0.00000000000000E+00  -7.32921002916063E-14   0.00000000000000E+00   2.97391858601203E-16  -1.11232828072520E-23
      7.33277402041437E-11   7.33280375959912E-11  -1.30648040795205E-18  -7.56456529984954E-03  -7.56456529987556E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60136510454810E-11   0.00000000000000E+00   2.60136510454810E-11
      5.29214060057042E-18  -3.30397145325749E-01  -3.30365849156400E-01   0.00000000000000E+00  -5.10783463682714E-13
     -1.24686596973249E-22  -9.88309051776641E-11  -9.93416886414715E-11  -3.98566019261837E-18
      9.64079104328085E-07
      0.00000000000000E+00  -8.06396792682085E-14   0.00000000000000E+00   2.74508399233202E-16   4.03218787471096E-24
      8.05984023763559E-11   8.05986768847592E-11  -1.30364973093940E-18  -7.46092560713356E-03  -7.46092560715784E-03
      0.00000000000000E+00   0.00000000000000E+00   2.42747528470928E-11   0.00000000000000E+00   2.42747528470928E-11
      5.34069010626461E-18  -3.54736033263977E-01  -3.54702994703411E-01   0.00000000000000E+00  -5.30062587002969E-13
     -1.27134210998417E-22  -1.04343367144722E-10  -1.04873429731852E-10  -4.03704037532521E-18
      9.66079104328085E-07
      0.00000000000000E+00  -8.77117240331881E-14   0.00000000000000E+00   2.62213119488083E-16   2.07211070750335E-23
      8.77522355031718E-11   8.77524977163121E-11  -1.30096423902317E-18  -7.39593729823164E-03  -7.39593729825441E-03
      0.00000000000000E+00   0.00000000000000E+00   2.27662321609578E-11   0.00000000000000E+00   2.27662321609578E-11
      5.38622257058653E-18  -3.78537659675381E-01  -3.78502842987635E-01   0.00000000000000E+00  -5.50948674477233E-13
     -1.29618012733414E-22  -1.09967781202663E-10  -1.10518729877270E-10  -4.08525833156336E-18
      9.68079104328085E-07
      0.00000000000000E+00  -9.47837687981676E-14   0.00000000000000E+00   2.52332756487858E-16   3.77183020188052E-23
      9.48065435642144E-11   9.48067958970086E-11  -1.29843085888717E-18  -7.35354317716763E-03  -7.35354317718914E-03
      0.00000000000000E+00   0.00000000000000E+00   2.15144567171714E-11   0.00000000000000E+00   2.15144567171714E-11
      5.42925148402086E-18  -4.01882942818331E-01  -4.01846298513487E-01   0.00000000000000E+00  -5.77806868136815E-13
     -1.32159320496171E-22  -1.15743445745911E-10  -1.16321252614180E-10  -4.13082062513370E-18
      9.70079104328085E-07
      0.00000000000000E+00  -1.01763968825940E-13   0.00000000000000E+00   2.44760687017271E-16   5.40972750889439E-23
      1.01799373562354E-10   1.01799618323095E-10  -1.29604531861489E-18  -7.32226675809137E-03  -7.32226675811184E-03
      0.00000000000000E+00   0.00000000000000E+00   2.04748592518484E-11   0.00000000000000E+00   2.04748592518484E-11
      5.47020120252457E-18  -4.24885293419962E-01  -4.24846774068304E-01   0.00000000000000E+00  -6.12358172502511E-13
     -1.34782532698202E-22  -1.21662119402307E-10  -1.22274477574944E-10  -4.17415588390968E-18
      9.72079104328085E-07
      0.00000000000000E+00  -1.08744168853712E-13   0.00000000000000E+00   2.38373296752211E-16   6.90842475331011E-23
      1.08732635154140E-10   1.08732873527506E-10  -1.29379526706264E-18  -7.30145045491069E-03  -7.30145045493015E-03
      0.00000000000000E+00   0.00000000000000E+00   1.94563760514465E-11   0.00000000000000E+00   1.94563760514465E-11
      5.50911395462746E-18  -4.47472587026499E-01  -4.47432204797516E-01   0.00000000000000E+00  -6.48078587342531E-13
     -1.37479198040202E-22  -1.27541170991471E-10  -1.28189249578951E-10  -4.21531868756482E-18
      9.74079104328085E-07
      0.00000000000000E+00  -1.15632524144276E-13   0.00000000000000E+00   2.33148577404576E-16   8.22025620566134E-23
      1.15611935968654E-10   1.15612169117314E-10  -1.29166276893110E-18  -7.29306461924371E-03  -7.29306461926217E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84603909101840E-11   0.00000000000000E+00   1.84603909101840E-11
      5.54603473644783E-18  -4.69612631253311E-01  -4.69570396116807E-01   0.00000000000000E+00  -6.85688104850012E-13
     -1.40240786869808E-22  -1.33386871922508E-10  -1.34072560027498E-10  -4.25437196751673E-18
      9.76079104328085E-07
      0.00000000000000E+00  -1.22429034697633E-13   0.00000000000000E+00   2.29307126479465E-16   9.32954995952269E-23
      1.22452931029085E-10   1.22453160336305E-10  -1.28962537353425E-18  -7.30108452842256E-03  -7.30108452844006E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74975145837963E-11   0.00000000000000E+00   1.74975145837963E-11
      5.58102976561542E-18  -4.91303998004397E-01  -4.91259911659390E-01   0.00000000000000E+00  -7.25307772029776E-13
     -1.43056263623383E-22  -1.39225367147928E-10  -1.39950674920101E-10  -4.29140439208117E-18
      9.78079104328085E-07
      0.00000000000000E+00  -1.29317389988198E-13   0.00000000000000E+00   2.27526826003193E-16   1.02464405250262E-22
      1.29290849417601E-10   1.29291076944529E-10  -1.28765314862717E-18  -7.33318213181213E-03  -7.33318213182869E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65682163273295E-11   0.00000000000000E+00   1.65682163273295E-11
      5.61416619827008E-18  -5.12553814341803E-01  -5.12507867245935E-01   0.00000000000000E+00  -7.65894532488347E-13
     -1.45908714817786E-22  -1.45093398739225E-10  -1.45859293271859E-10  -4.32651304964291E-18
      9.80079104328085E-07
      0.00000000000000E+00  -1.36297590015970E-13   0.00000000000000E+00   2.35423580036681E-16   1.10069991287859E-22
      1.36341709362045E-10   1.36341944785736E-10  -1.28564002126126E-18  -7.43263235731145E-03  -7.43263235732707E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56155240600342E-11   0.00000000000000E+00   1.56155240600342E-11
      5.64539724639015E-18  -5.33370936129054E-01  -5.33323068642514E-01   0.00000000000000E+00  -8.04480912944277E-13
     -1.48771268021250E-22  -1.51152987932677E-10  -1.51957468845770E-10  -4.35975722512888E-18
      9.82079104328085E-07
      0.00000000000000E+00  -1.44288082153025E-13   0.00000000000000E+00   2.74701916521069E-16   1.16821233238023E-22
      1.44318313176784E-10   1.44318587878817E-10  -1.28326728498687E-18  -7.73921532947407E-03  -7.73921532948854E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44704040452886E-11   0.00000000000000E+00   1.44704040452886E-11
      5.67433805448072E-18  -5.53763453686797E-01  -5.53713434884491E-01   0.00000000000000E+00  -8.34745484531963E-13
     -1.51600513016582E-22  -1.57954246439422E-10  -1.58788991924105E-10  -4.39107076949385E-18
      9.84079104328085E-07
      0.00000000000000E+00  -1.55860519041173E-13   0.00000000000000E+00   4.21731360717301E-16   1.24497122174200E-22
      1.55860144044544E-10   1.55860565776029E-10  -1.27944474192630E-18  -8.74245572690723E-03  -8.74245572691973E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25014683760224E-11   0.00000000000000E+00   1.25014683760224E-11
      5.69934099123277E-18  -5.73735414275821E-01  -5.73682380688313E-01   0.00000000000000E+00  -8.37130873983832E-13
     -1.54301319575206E-22  -1.67524903277914E-10  -1.68362034152052E-10  -4.41989624930647E-18
      9.86079104328085E-07
      0.00000000000000E+00  -1.96364048149692E-13   0.00000000000000E+00   1.55924859542522E-15   1.47164962649922E-22
      1.96324468321634E-10   1.96326027570376E-10  -1.26513670217832E-18  -1.45568451440677E-02  -1.45568451440709E-02
      0.00000000000000E+00   0.00000000000000E+00   3.14429537160779E-12   0.00000000000000E+00   3.14429537160779E-12
      5.70562958197598E-18  -5.93254231160734E-01  -5.93191399596593E-01   0.00000000000000E+00  -6.24168794300388E-13
     -1.56230647960232E-22  -1.98846154147528E-10  -1.99470322941985E-10  -4.44049287979766E-18
      9.88079104328085E-07
      0.00000000000000E+00  -4.17526175345417E-13   0.00000000000000E+00   7.52260817212497E-15   2.37177755365467E-22
      4.17513212340306E-10   4.17520734948715E-10  -1.20746873056653E-18  -3.92987246806443E-02  -3.92987246806105E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.37305017963810E-11   0.00000000000000E+00  -3.37305017963810E-11
      5.63816857838322E-18  -6.12032527629002E-01  -6.11911638044604E-01   0.00000000000000E+00   3.10075663470241E-13
     -1.55271982656344E-22  -3.84100308815648E-10  -3.83790233152333E-10  -4.43069984781669E-18
      9.90079104328085E-07
      0.00000000000000E+00  -9.02374543063950E-13   0.00000000000000E+00   1.40216125993033E-14   3.16827314853255E-22
      9.02351849113220E-10   9.02365870726136E-10  -1.13382245759652E-18  -6.90320183005483E-02  -6.90320183004973E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.10268476076896E-11   0.00000000000000E+00  -5.10268476076896E-11
      5.53611488316784E-18  -6.29536696680001E-01  -6.29268532275737E-01   0.00000000000000E+00   5.03853040047577E-13
     -1.53679998834481E-22  -8.51842876158342E-10  -8.51339023118448E-10  -4.40229242557133E-18
      9.92079104328084E-07
      0.00000000000000E+00  -1.83625183099008E-12   0.00000000000000E+00   2.47641646399487E-14   3.65402639510397E-22
      1.83621956747837E-09   1.83624433164337E-09  -1.06041184758425E-18  -9.86052655026781E-02  -9.86052655026173E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.07700219202862E-11   0.00000000000000E+00  -6.07700219202862E-11
      5.41457483932727E-18  -6.44907282474378E-01  -6.44348018972426E-01   0.00000000000000E+00   4.33914162660899E-13
     -1.52252005494589E-22  -1.77590822388560E-09  -1.77547430972309E-09  -4.35416299174301E-18
      9.94079104328084E-07
      0.00000000000000E+00  -3.48890603230232E-12   0.00000000000000E+00   4.22432057357274E-14   4.01487327481631E-22
      3.48885363429183E-09   3.48889587749796E-09  -9.92633245976502E-19  -1.27702095653794E-01  -1.27702095653721E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23643006690250E-11   0.00000000000000E+00  -7.23643006690250E-11
      5.26984623798922E-18  -6.56797258017008E-01  -6.55721064847556E-01   0.00000000000000E+00   3.39226694035483E-13
     -1.51074205234829E-22  -3.41687080352282E-09  -3.41653157682893E-09  -4.27721299201272E-18
      9.94329104328084E-07
      0.00000000000000E+00  -3.77233889132475E-12   0.00000000000000E+00   5.73149889375518E-14   4.08990166544874E-22
      3.77228811397064E-09   3.77234542895998E-09  -9.84280668345273E-19  -1.31331291419345E-01  -1.31331291419270E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.47814186118298E-11   0.00000000000000E+00  -7.47814186118298E-11
      5.25115088333626E-18  -6.58210495661156E-01  -6.57045777587478E-01   0.00000000000000E+00   3.06828372689821E-13
     -1.50935620823230E-22  -3.69787083872069E-09  -3.69756401034815E-09  -4.26687021499099E-18
      9.94666604328084E-07
      0.00000000000000E+00  -4.18141535084707E-12   0.00000000000000E+00   6.11553293956136E-14   4.19455301414486E-22
      4.18138729939317E-09   4.18144845472298E-09  -9.73308916535109E-19  -1.36215439745429E-01  -1.36215439745352E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.75316269585923E-11   0.00000000000000E+00  -7.75316269585923E-11
      5.22498395923774E-18  -6.59976921607458E-01  -6.58684202790698E-01   0.00000000000000E+00   2.79941871054587E-13
     -1.50762182343773E-22  -4.10419676963529E-09  -4.10391682776439E-09  -4.25167504270263E-18
      9.95122229328084E-07
      0.00000000000000E+00  -4.78318206903079E-12   0.00000000000000E+00   6.64765204624649E-14   4.31441258783283E-22
      4.78318347925114E-09   4.78324995577204E-09  -9.59000995668966E-19  -1.42779855928982E-01  -1.42779855928901E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.13972809731203E-11   0.00000000000000E+00  -8.13972809731203E-11
      5.18789732309436E-18  -6.62082857252975E-01  -6.60601789107014E-01   0.00000000000000E+00   2.45986985305720E-13
     -1.50551457901071E-22  -4.70209866178407E-09  -4.70185267479891E-09  -4.22889632742539E-18
      9.95737323078084E-07
      0.00000000000000E+00  -5.68739350683889E-12   0.00000000000000E+00   7.37774331758455E-14   4.43959829148534E-22
      5.68732404039784E-09   5.68739781783146E-09  -9.40501740465907E-19  -1.51586828451666E-01  -1.51586828451579E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.67697312540179E-11   0.00000000000000E+00  -8.67697312540179E-11
      5.13452580371084E-18  -6.64365647756642E-01  -6.62601465808094E-01   0.00000000000000E+00   2.06772648141350E-13
     -1.50303329172826E-22  -5.60083485922544E-09  -5.60062808657744E-09  -4.19402406324493E-18
      9.96567699640584E-07
      0.00000000000000E+00  -7.07847389658409E-12   0.00000000000000E+00   8.38225098045035E-14   4.55449065032556E-22
      7.07835426785102E-09   7.07843809036128E-09  -9.16803409413133E-19  -1.63374285967453E-01  -1.63374285967359E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.40509080225468E-11   0.00000000000000E+00  -9.40509080225468E-11
      5.05642813400707E-18  -6.66296084192918E-01  -6.64096018200951E-01   0.00000000000000E+00   1.72089779442861E-13
     -1.50009876881760E-22  -6.98455927211802E-09  -6.98438718233873E-09  -4.13962472459393E-18
      9.97688707999959E-07
      0.00000000000000E+00  -9.27613476848579E-12   0.00000000000000E+00   9.77271897186634E-14   4.63786219024011E-22
      9.27602788147359E-09   9.27612560866377E-09  -8.86686979200475E-19  -1.79101274663821E-01  -1.79101274663717E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03451635142614E-10   0.00000000000000E+00  -1.03451635142614E-10
      4.94045798622118E-18  -6.66476132349017E-01  -6.63586753839443E-01   0.00000000000000E+00   1.73373204696415E-13
     -1.49598539009355E-22  -9.17284734672570E-09  -9.17267397352116E-09  -4.05377100702071E-18
      9.99202069285116E-07
      0.00000000000000E+00  -1.28612940853816E-11   0.00000000000000E+00   1.17395344406514E-13   4.66382550750528E-22
      1.28611982369157E-08   1.28613156322605E-08  -8.48532871040117E-19  -1.99998043645322E-01  -1.99998043645208E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14595696391575E-10   0.00000000000000E+00  -1.14595696391575E-10
      4.76703329585665E-18  -6.61449527413212E-01  -6.57434310021154E-01   0.00000000000000E+00   2.92382098220445E-13
     -1.48707016943028E-22  -1.27470123179670E-08  -1.27467199358690E-08  -3.91850042481654E-18
      1.00000000000000E-06
      0.00000000000000E+00  -1.51182866575194E-11   0.00000000000000E+00   1.40572520360136E-13   4.67080356799080E-22
      1.51181431728788E-08   1.51182837453996E-08  -8.28972461014793E-19  -2.10923405851582E-01  -2.10923405851462E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20428696675862E-10   0.00000000000000E+00  -1.20428696675862E-10
      4.67093953982550E-18  -6.57058658952794E-01  -6.52334318248666E-01   0.00000000000000E+00   3.96069854980488E-13
     -1.48072519763296E-22  -1.49982511185786E-08  -1.49978550487238E-08  -3.84196707881071E-18
}
